/*
 * Decompiled with CFR 0.152.
 */
package de.darksmp.simpletimer;

import de.darksmp.simpletimer.SimpleTimerPlugin;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class TimerManager {
    private final SimpleTimerPlugin plugin;
    private Mode mode;
    private long valueSeconds;
    private long targetTimestamp;
    private BukkitTask task;
    private boolean running;
    private TimerManager timerManager;

    public TimerManager(SimpleTimerPlugin plugin) {
        this.plugin = plugin;
        File file = new File(plugin.getDataFolder(), "timer.yml");
        if (file.exists()) {
            YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)file);
            this.valueSeconds = yaml.getLong("time", 0L);
            try {
                this.mode = Mode.valueOf(yaml.getString("mode", "UP"));
            }
            catch (IllegalArgumentException e) {
                this.mode = Mode.UP;
            }
            this.running = yaml.getBoolean("running", false);
        } else {
            this.mode = Mode.UP;
            this.valueSeconds = 0L;
            this.running = false;
        }
        if (this.running) {
            plugin.getLogger().info("Timer automatisch gestartet (war beim Shutdown aktiv).");
            this.start();
        }
    }

    private void saveToFile() {
        File file = new File(this.plugin.getDataFolder(), "timer.yml");
        YamlConfiguration yaml = new YamlConfiguration();
        yaml.set("time", (Object)this.valueSeconds);
        yaml.set("mode", (Object)this.mode.name());
        yaml.set("running", (Object)this.running);
        try {
            yaml.save(file);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Konnte timer.yml nicht speichern: " + e.getMessage());
        }
    }

    public void start() {
        this.saveToFile();
        if (this.running) {
            return;
        }
        this.running = true;
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            this.tick();
            this.showActionBar();
        }, 0L, 20L);
    }

    public void stop() {
        this.saveToFile();
        if (!this.running) {
            return;
        }
        this.running = false;
        if (this.task != null) {
            this.task.cancel();
        }
    }

    public void reset() {
        this.stop();
        this.mode = Mode.UP;
        this.valueSeconds = 0L;
        this.running = false;
        this.saveToFile();
        this.showActionBar();
    }

    public void setMode(Mode m) {
        this.mode = m;
        this.saveToFile();
    }

    public void setValue(long seconds) {
        this.valueSeconds = Math.max(0L, seconds);
        this.saveToFile();
    }

    public void setTargetTimestamp(long unixTime) {
        this.targetTimestamp = unixTime;
        this.saveToFile();
    }

    private void tick() {
        switch (this.mode.ordinal()) {
            case 0: {
                ++this.valueSeconds;
                break;
            }
            case 1: {
                if (this.valueSeconds <= 0L) break;
                --this.valueSeconds;
                if (this.valueSeconds != 0L) break;
                this.onFinish();
                break;
            }
            case 2: {
                long now = Instant.now().getEpochSecond();
                long diff = this.targetTimestamp - now;
                this.valueSeconds = Math.max(diff, 0L);
                if (diff > 0L) break;
                this.onFinish();
            }
        }
    }

    private void onFinish() {
        this.stop();
        List cmds = this.plugin.getConfig().getStringList("timer.if_down_finish_commands");
        cmds.forEach(cmd -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd));
    }

    private void showActionBar() {
        String template = this.plugin.getConfig().getString("timer.timer", "<white>%timer%");
        String timeFormatted = this.formatSmart(this.valueSeconds);
        String finalMsg = template.replace("%timer%", timeFormatted);
        Component msg = MiniMessage.miniMessage().deserialize((Object)finalMsg);
        Bukkit.getOnlinePlayers().forEach(p -> p.sendActionBar(msg));
    }

    private String format(long total) {
        long h = TimeUnit.SECONDS.toHours(total);
        long m = TimeUnit.SECONDS.toMinutes(total) % 60L;
        long s = total % 60L;
        return String.format("%02d:%02d:%02d", h, m, s);
    }

    public boolean isRunning() {
        return this.running;
    }

    public Mode getMode() {
        return this.mode;
    }

    public long getTime() {
        return this.valueSeconds;
    }

    public void showActionBar(Player player) {
        String template = this.plugin.getConfig().getString("timer.timer", "<white>%timer%");
        String timeFormatted = this.format(this.valueSeconds);
        String finalMsg = template.replace("%timer%", timeFormatted);
        Component msg = MiniMessage.miniMessage().deserialize((Object)finalMsg);
        player.sendActionBar(msg);
    }

    public static String formatDuration(long secondsTotal) {
        long days = secondsTotal / 86400L;
        long hours = secondsTotal % 86400L / 3600L;
        long minutes = secondsTotal % 3600L / 60L;
        long seconds = secondsTotal % 60L;
        if (days > 0L) {
            return String.format("%d:%02d:%02d:%02d", days, hours, minutes, seconds);
        }
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    private String formatSmart(long totalSeconds) {
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        if (totalSeconds < 60L) {
            return String.valueOf(seconds);
        }
        if (totalSeconds < 3600L) {
            return String.format("%02d:%02d", minutes, seconds);
        }
        if (totalSeconds < 86400L) {
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format("%d:%02d:%02d:%02d", days, hours, minutes, seconds);
    }

    public static enum Mode {
        UP,
        DOWN,
        TIMESTAMP;

    }
}

