/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimeistdev.crystalline_sky.compat.sodium;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.textures.GpuTextureView;
import io.github.slimeistdev.crystalline_sky.registry.CrystallineItems;
import java.util.EnumMap;
import java.util.Map;
import net.caffeinemc.mods.sodium.client.gl.shader.uniform.GlUniformFloat3v;
import net.caffeinemc.mods.sodium.client.gl.shader.uniform.GlUniformFloat4v;
import net.caffeinemc.mods.sodium.client.gl.shader.uniform.GlUniformInt;
import net.caffeinemc.mods.sodium.client.gl.shader.uniform.GlUniformMatrix4f;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderFogComponent;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderInterface;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderOptions;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderTextureSlot;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ShaderBindingContext;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.caffeinemc.mods.sodium.client.util.FogParameters;
import net.minecraft.class_10868;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.joml.Matrix4fc;

public class SkyShaderInterface
implements ChunkShaderInterface {
    private final Map<ChunkShaderTextureSlot, GlUniformInt> uniformTextures;
    private final GlUniformMatrix4f uniformModelViewMatrix;
    private final GlUniformMatrix4f uniformProjectionMatrix;
    private final GlUniformFloat3v uniformRegionOffset;
    private final GlUniformFloat4v uniformColorModulator;
    private final ChunkShaderFogComponent fogShader;

    public SkyShaderInterface(ShaderBindingContext context, ChunkShaderOptions options) {
        this.uniformModelViewMatrix = (GlUniformMatrix4f)context.bindUniform("u_ModelViewMatrix", GlUniformMatrix4f::new);
        this.uniformProjectionMatrix = (GlUniformMatrix4f)context.bindUniform("u_ProjectionMatrix", GlUniformMatrix4f::new);
        this.uniformRegionOffset = (GlUniformFloat3v)context.bindUniform("u_RegionOffset", GlUniformFloat3v::new);
        this.uniformColorModulator = (GlUniformFloat4v)context.bindUniform("u_ColorModulator", GlUniformFloat4v::new);
        this.uniformTextures = new EnumMap<ChunkShaderTextureSlot, GlUniformInt>(ChunkShaderTextureSlot.class);
        this.uniformTextures.put(ChunkShaderTextureSlot.BLOCK, (GlUniformInt)context.bindUniform("u_BlockTex", GlUniformInt::new));
        this.fogShader = (ChunkShaderFogComponent)options.fog().getFactory().apply(context);
    }

    public void setupState(TerrainRenderPass pass, FogParameters parameters) {
        this.bindTexture(ChunkShaderTextureSlot.BLOCK, pass.getAtlas());
        class_310 client = class_310.method_1551();
        if (client.field_1687 != null && client.field_1724 != null && (client.field_1724.method_6047().method_31574(CrystallineItems.SKY) || client.field_1724.method_6079().method_31574(CrystallineItems.SKY) || client.field_1724.method_6047().method_31574(CrystallineItems.WEEPING_SKY) || client.field_1724.method_6079().method_31574(CrystallineItems.WEEPING_SKY))) {
            float f = (float)client.field_1687.method_8510() + client.method_61966().method_60637(true);
            float alpha = (class_3532.method_15374((float)(f / 10.0f)) + 1.0f) / 2.0f;
            float maxAlpha = 0.75f;
            this.uniformColorModulator.set(1.0f, 1.0f, 1.0f, alpha *= maxAlpha);
        } else {
            this.uniformColorModulator.set(1.0f, 1.0f, 1.0f, 1.0f);
        }
        this.fogShader.setup(parameters);
    }

    public void resetState() {
    }

    @Deprecated(forRemoval=true)
    private void bindTexture(ChunkShaderTextureSlot slot, GpuTextureView textureView) {
        class_10868 tex = (class_10868)textureView.texture();
        GlStateManager._activeTexture((int)(33984 + slot.ordinal()));
        GlStateManager._bindTexture((int)tex.method_68427());
        GlStateManager._texParameter((int)3553, (int)33084, (int)textureView.baseMipLevel());
        GlStateManager._texParameter((int)3553, (int)33085, (int)(textureView.baseMipLevel() + textureView.mipLevels() - 1));
        tex.method_68424(3553);
        GlUniformInt uniform = this.uniformTextures.get(slot);
        uniform.setInt(slot.ordinal());
    }

    public void setProjectionMatrix(Matrix4fc matrix) {
        this.uniformProjectionMatrix.set(matrix);
    }

    public void setModelViewMatrix(Matrix4fc matrix) {
        this.uniformModelViewMatrix.set(matrix);
    }

    public void setRegionOffset(float x, float y, float z) {
        this.uniformRegionOffset.set(x, y, z);
    }
}

