/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimeistdev.crystalline_sky.infrastructure;

import com.google.common.base.Preconditions;
import io.github.slimeistdev.crystalline_sky.infrastructure.WeepingStorage;
import io.github.slimeistdev.crystalline_sky.util.ArrayUtils;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.function.Consumer;

public class IntWeepingStorage
implements WeepingStorage {
    private final int[] sizes = new int[256];
    private final int[][] columns = new int[256][0];
    private final int[] tempRunSplitSizes = new int[512];
    private final int[][] tempRunSplits = new int[512][0];
    private final int minY;

    public IntWeepingStorage(int minY) {
        this.minY = minY;
    }

    private static int getIndex(int localX, int localZ) {
        return localX + localZ * 16;
    }

    private static int pack(short ySky, short yBottom) {
        return ySky << 16 | Short.toUnsignedInt(yBottom);
    }

    private static short unpackSky(int packed) {
        return (short)(packed >>> 16);
    }

    private static short unpackBottom(int packed) {
        return (short)(packed & 0xFFFF);
    }

    private static int calculateIncreasedLength(int currentLength) {
        if (currentLength == 0) {
            return 1;
        }
        return Integer.highestOneBit(currentLength) << 1;
    }

    private void maybeShrinkColumn(int index) {
        int[] column = this.columns[index];
        int size = this.sizes[index];
        int newLength = IntWeepingStorage.calculateIncreasedLength(size);
        if (column.length > newLength) {
            int[] newColumn = new int[newLength];
            System.arraycopy(column, 0, newColumn, 0, size);
            this.columns[index] = newColumn;
        }
    }

    private void insertValue(int columnIndex, int i, int packed) {
        int size = this.sizes[columnIndex];
        int[] column = this.columns[columnIndex];
        if (size + 1 > column.length) {
            int newLength = IntWeepingStorage.calculateIncreasedLength(column.length);
            int[] newColumn = new int[newLength];
            System.arraycopy(column, 0, newColumn, 0, i);
            newColumn[i] = packed;
            System.arraycopy(column, i, newColumn, i + 1, size - i);
            this.columns[columnIndex] = newColumn;
        } else {
            System.arraycopy(column, i, column, i + 1, size - i);
            column[i] = packed;
        }
        this.sizes[columnIndex] = ++size;
    }

    private void insertTempRunSplit(int columnIndex, int splitY, boolean isLit) {
        int index = columnIndex * 2 + (isLit ? 1 : 0);
        int size = this.tempRunSplitSizes[index];
        int[] splits = this.tempRunSplits[index];
        if (size == 0) {
            if (splits.length == 0) {
                this.tempRunSplits[index] = new int[]{splitY};
            } else {
                splits[0] = splitY;
            }
            this.tempRunSplitSizes[index] = ++size;
        } else {
            int insertIndex = ArrayUtils.binarySearchSortedInsertionPoint(splits, splitY, size);
            if (insertIndex != -1) {
                if (size + 1 > splits.length) {
                    int newLength = IntWeepingStorage.calculateIncreasedLength(splits.length);
                    int[] newSplits = new int[newLength];
                    System.arraycopy(splits, 0, newSplits, 0, insertIndex);
                    newSplits[insertIndex] = splitY;
                    System.arraycopy(splits, insertIndex, newSplits, insertIndex + 1, splits.length - insertIndex);
                    this.tempRunSplits[index] = newSplits;
                } else {
                    System.arraycopy(splits, insertIndex, splits, insertIndex + 1, size - insertIndex);
                    splits[insertIndex] = splitY;
                }
                this.tempRunSplitSizes[index] = ++size;
            }
        }
    }

    private void litTempSplit(int columnIndex, int bottomY) {
        this.insertTempRunSplit(columnIndex, bottomY, true);
    }

    private void unlitTempSplit(int columnIndex, int topY) {
        this.insertTempRunSplit(columnIndex, topY, false);
    }

    @Override
    public void insertSky(int localX, int y, int localZ, WeepingStorage.WeepingScanner scanner) {
        int index = IntWeepingStorage.getIndex(localX, localZ);
        int size = this.sizes[index];
        int[] column = this.columns[index];
        short yShort = (short)y;
        if (size == 0) {
            int solidY = scanner.scan(localX, y, localZ);
            short shortLowestLitY = (short)(solidY == -1 ? -1 : solidY + 1);
            int packed = IntWeepingStorage.pack(yShort, shortLowestLitY);
            if (column.length == 0) {
                this.columns[index] = new int[]{packed};
            } else {
                column[0] = packed;
            }
            this.sizes[index] = ++size;
            this.litTempSplit(index, shortLowestLitY);
        } else {
            for (int i = 0; i < size; ++i) {
                int packed = column[i];
                short sky = IntWeepingStorage.unpackSky(packed);
                short bottom = IntWeepingStorage.unpackBottom(packed);
                if (yShort == sky) {
                    return;
                }
                if (!(bottom == -1 || yShort >= sky || yShort != bottom && yShort != bottom - 1 || scanner.faceBlocksLight(localX, bottom, localZ))) {
                    int solidY = scanner.scan(localX, yShort, localZ);
                    short shortLowestLitY = (short)(solidY == -1 ? -1 : solidY + 1);
                    if (i + 1 < size) {
                        int packedBelow = column[i + 1];
                        short skyBelow = IntWeepingStorage.unpackSky(packedBelow);
                        short bottomBelow = IntWeepingStorage.unpackBottom(packedBelow);
                        if (solidY == -1 || solidY > skyBelow) {
                            this.litTempSplit(index, skyBelow + 1);
                            column[i] = IntWeepingStorage.pack(sky, bottomBelow);
                            System.arraycopy(column, i + 2, column, i + 1, size - (i + 2));
                            this.sizes[index] = --size;
                            this.maybeShrinkColumn(index);
                            return;
                        }
                    }
                    column[i] = IntWeepingStorage.pack(sky, shortLowestLitY);
                    this.litTempSplit(index, shortLowestLitY);
                    return;
                }
                if (yShort > sky) {
                    int solidY = scanner.scan(localX, y, localZ);
                    if (solidY == -1 || solidY < sky) {
                        column[i] = IntWeepingStorage.pack(yShort, bottom);
                        this.litTempSplit(index, sky + 1);
                    } else {
                        this.insertValue(index, i, IntWeepingStorage.pack(yShort, (short)(solidY + 1)));
                        this.litTempSplit(index, solidY + 1);
                    }
                    return;
                }
                if (bottom == -1 || yShort >= bottom) {
                    return;
                }
                if (i != size - 1) continue;
                int solidY = scanner.scan(localX, y, localZ);
                short shortLowestLitY = (short)(solidY == -1 ? -1 : solidY + 1);
                this.insertValue(index, size, IntWeepingStorage.pack(yShort, shortLowestLitY));
                this.litTempSplit(index, shortLowestLitY);
                return;
            }
        }
    }

    @Override
    public void insertSolid(int localX, int y, int localZ, WeepingStorage.WeepingScanner scanner) {
        int index = IntWeepingStorage.getIndex(localX, localZ);
        int size = this.sizes[index];
        int[] column = this.columns[index];
        short yShort = (short)y;
        int lastLitY = -1;
        boolean blockingCalculated = false;
        for (int i = 0; i < size; ++i) {
            int packed = column[i];
            short sky = IntWeepingStorage.unpackSky(packed);
            short s = IntWeepingStorage.unpackBottom(packed);
            if (yShort > sky) {
                return;
            }
            if (yShort == sky) {
                int nextSky = scanner.scanForWeepingSky(localX, y, localZ);
                if (nextSky == -1 || nextSky < s) {
                    System.arraycopy(column, i + 1, column, i, size - (i + 1));
                    this.sizes[index] = --size;
                    this.maybeShrinkColumn(index);
                } else {
                    column[i] = IntWeepingStorage.pack((short)nextSky, s);
                }
                this.unlitTempSplit(index, sky);
                return;
            }
            if (!blockingCalculated) {
                boolean lightBlockedHere = scanner.faceBlocksLight(localX, y, localZ);
                boolean lightBlockedAbove = scanner.faceBlocksLight(localX, y + 1, localZ);
                if (lightBlockedAbove) {
                    lastLitY = y + 1;
                } else if (lightBlockedHere) {
                    lastLitY = y;
                } else {
                    return;
                }
                blockingCalculated = true;
            }
            if (lastLitY <= s) continue;
            int nextSky = scanner.scanForWeepingSky(localX, y, localZ);
            column[i] = IntWeepingStorage.pack(sky, (short)lastLitY);
            this.unlitTempSplit(index, lastLitY - 1);
            if (nextSky != -1 && nextSky >= s) {
                this.insertValue(index, i + 1, IntWeepingStorage.pack((short)nextSky, s));
            }
            return;
        }
    }

    @Override
    public void insertAir(int localX, int y, int localZ, WeepingStorage.WeepingScanner scanner) {
        int index = IntWeepingStorage.getIndex(localX, localZ);
        int size = this.sizes[index];
        int[] column = this.columns[index];
        short yShort = (short)y;
        for (int i = 0; i < size; ++i) {
            int packed = column[i];
            short sky = IntWeepingStorage.unpackSky(packed);
            short bottom = IntWeepingStorage.unpackBottom(packed);
            if (yShort > sky) {
                return;
            }
            if (yShort == sky) {
                int nextSky = scanner.scanForWeepingSky(localX, y, localZ);
                if (nextSky == -1 || nextSky < bottom) {
                    System.arraycopy(column, i + 1, column, i, size - (i + 1));
                    this.sizes[index] = --size;
                    this.maybeShrinkColumn(index);
                    this.unlitTempSplit(index, sky);
                } else {
                    column[i] = IntWeepingStorage.pack((short)nextSky, bottom);
                    this.unlitTempSplit(index, sky);
                }
                return;
            }
            if (bottom == -1 || yShort != bottom && yShort != bottom - 1 || scanner.faceBlocksLight(localX, bottom, localZ)) continue;
            int solidY = scanner.scan(localX, yShort, localZ);
            short shortLowestLitY = (short)(solidY == -1 ? -1 : solidY + 1);
            if (i + 1 < size) {
                int packedBelow = column[i + 1];
                short skyBelow = IntWeepingStorage.unpackSky(packedBelow);
                short bottomBelow = IntWeepingStorage.unpackBottom(packedBelow);
                if (solidY == -1 || solidY < skyBelow) {
                    column[i] = IntWeepingStorage.pack(sky, bottomBelow);
                    System.arraycopy(column, i + 2, column, i + 1, size - (i + 2));
                    this.sizes[index] = --size;
                    this.litTempSplit(index, skyBelow + 1);
                    this.maybeShrinkColumn(index);
                    return;
                }
            }
            column[i] = IntWeepingStorage.pack(sky, shortLowestLitY);
            this.litTempSplit(index, shortLowestLitY);
            return;
        }
    }

    @Override
    public void clear() {
        int[] empty = new int[]{};
        for (int i = 0; i < 256; ++i) {
            this.sizes[i] = 0;
            this.columns[i] = empty;
            this.tempRunSplitSizes[i] = 0;
            this.tempRunSplits[i] = empty;
        }
    }

    public void set(int localX, int localZ, ShortList layers) {
        int size;
        Preconditions.checkArgument((layers.size() % 2 == 0 ? 1 : 0) != 0, (Object)"Expected even number of shorts in layers");
        int index = IntWeepingStorage.getIndex(localX, localZ);
        this.sizes[index] = size = layers.size() / 2;
        int[] column = this.columns[index];
        if (column.length < size) {
            column = new int[IntWeepingStorage.calculateIncreasedLength(size)];
            this.columns[index] = column;
        }
        for (int i = 0; i < size; ++i) {
            short sky = layers.getShort(i * 2);
            short bottom = layers.getShort(i * 2 + 1);
            column[i] = IntWeepingStorage.pack(sky, bottom);
        }
        this.maybeShrinkColumn(index);
    }

    @Override
    public boolean isLit(int localX, int y, int localZ) {
        int index = IntWeepingStorage.getIndex(localX, localZ);
        int size = this.sizes[index];
        int[] column = this.columns[index];
        if (size == 0) {
            return false;
        }
        short yShort = (short)(y - this.minY);
        int left = 0;
        int right = size - 1;
        while (left <= right) {
            int mid = (left + right) / 2;
            int packed = column[mid];
            short sky = IntWeepingStorage.unpackSky(packed);
            short bottom = IntWeepingStorage.unpackBottom(packed);
            if (yShort > sky) {
                right = mid - 1;
                continue;
            }
            if (yShort < sky) {
                if (bottom == -1 || yShort >= bottom) {
                    return true;
                }
                left = mid + 1;
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public Iterable<WeepingStorage.Run> iterateLitRuns(int localX, int localZ, int lowestSourceY) {
        int index = IntWeepingStorage.getIndex(localX, localZ);
        int size = this.sizes[index];
        int[] column = this.columns[index];
        int splitsColumnIndex = index * 2 + 1;
        int splitsSize = this.tempRunSplitSizes[splitsColumnIndex];
        int[] splits = this.tempRunSplits[splitsColumnIndex];
        ArrayList<WeepingStorage.Run> runs = new ArrayList<WeepingStorage.Run>(size);
        runs.add(new WeepingStorage.Run(lowestSourceY, Integer.MAX_VALUE));
        if (lowestSourceY == Integer.MIN_VALUE) {
            return this.wrapUnlitRuns(splitsSize, splits, runs);
        }
        for (int i = 0; i < size; ++i) {
            int globalBottom;
            int packed = column[i];
            short sky = IntWeepingStorage.unpackSky(packed);
            short bottom = IntWeepingStorage.unpackBottom(packed);
            int globalSky = sky + this.minY;
            int n = globalBottom = bottom == -1 ? Integer.MIN_VALUE : bottom + this.minY;
            if (globalBottom >= lowestSourceY) continue;
            if (globalSky >= lowestSourceY - 1) {
                runs.set(0, new WeepingStorage.Run(globalBottom, Integer.MAX_VALUE));
                continue;
            }
            runs.add(new WeepingStorage.Run(globalBottom, globalSky));
        }
        return this.wrapLitRuns(splitsSize, splits, runs);
    }

    @Override
    public Iterable<WeepingStorage.Run> iterateUnlitRuns(int localX, int localZ, int lowestSourceY) {
        int index = IntWeepingStorage.getIndex(localX, localZ);
        int size = this.sizes[index];
        int[] column = this.columns[index];
        int splitsColumnIndex = index * 2;
        int splitsSize = this.tempRunSplitSizes[splitsColumnIndex];
        int[] splits = this.tempRunSplits[splitsColumnIndex];
        ArrayList<WeepingStorage.Run> runs = new ArrayList<WeepingStorage.Run>(size);
        if (lowestSourceY == Integer.MIN_VALUE) {
            return this.wrapUnlitRuns(splitsSize, splits, runs);
        }
        if (size == 0) {
            runs.add(new WeepingStorage.Run(Integer.MIN_VALUE, lowestSourceY - 1));
        } else {
            int lastLowestLit = lowestSourceY;
            for (int i = 0; i < size && lastLowestLit > Integer.MIN_VALUE; ++i) {
                int globalBottom;
                int packed = column[i];
                short sky = IntWeepingStorage.unpackSky(packed);
                short bottom = IntWeepingStorage.unpackBottom(packed);
                int globalSky = sky + this.minY;
                int n = globalBottom = bottom == -1 ? Integer.MIN_VALUE : bottom + this.minY;
                if (globalBottom >= lowestSourceY) continue;
                if (globalSky < lastLowestLit - 1) {
                    runs.add(new WeepingStorage.Run(globalSky + 1, lastLowestLit - 1));
                }
                lastLowestLit = globalBottom;
            }
            if (lastLowestLit > Integer.MIN_VALUE && lastLowestLit != lowestSourceY) {
                runs.add(new WeepingStorage.Run(Integer.MIN_VALUE, lastLowestLit - 1));
            }
        }
        return this.wrapUnlitRuns(splitsSize, splits, runs);
    }

    @Override
    public void clearTempRunSplits(int localX, int localZ) {
        int[] empty = new int[]{};
        int baseIndex = IntWeepingStorage.getIndex(localX, localZ) * 2;
        for (int i = 0; i < 2; ++i) {
            int index = baseIndex + i;
            this.tempRunSplitSizes[index] = 0;
            this.tempRunSplits[index] = empty;
        }
    }

    @Override
    public boolean isColumnEmpty(int localX, int localZ) {
        return this.sizes[IntWeepingStorage.getIndex(localX, localZ)] <= 0;
    }

    @Override
    public boolean hasNoUnlitSplits(int localX, int localZ) {
        return this.tempRunSplitSizes[IntWeepingStorage.getIndex(localX, localZ) * 2] <= 0;
    }

    @Override
    public void debugState(int localX, int localZ, Consumer<String> stringConsumer) {
        int index = IntWeepingStorage.getIndex(localX, localZ);
        int size = this.sizes[index];
        int[] column = this.columns[index];
        if (size == 0) {
            stringConsumer.accept("  <empty>");
        } else {
            for (int i = 0; i < size; ++i) {
                int packed = column[i];
                short sky = IntWeepingStorage.unpackSky(packed);
                short bottom = IntWeepingStorage.unpackBottom(packed);
                stringConsumer.accept("  layer " + i + ": sky=" + (sky + this.minY) + ", bottom=" + String.valueOf(bottom == -1 ? "-1" : Integer.valueOf(bottom + this.minY)));
            }
        }
    }

    public Iterable<WeepingStorage.Run> wrapLitRuns(int splitsSize, int[] splits, Iterable<WeepingStorage.Run> iterable) {
        if (splitsSize <= 0) {
            return iterable;
        }
        return () -> new LitSplittingIterator(splitsSize, splits, iterable.iterator());
    }

    private Iterable<WeepingStorage.Run> wrapUnlitRuns(int splitsSize, int[] splits, Iterable<WeepingStorage.Run> iterable) {
        if (splitsSize <= 0) {
            return iterable;
        }
        return () -> new UnlitSplittingIterator(splitsSize, splits, iterable.iterator());
    }

    private class UnlitSplittingIterator
    implements Iterator<WeepingStorage.Run> {
        private final int[] splits;
        private final Iterator<WeepingStorage.Run> iterator;
        private final Deque<WeepingStorage.Run> remainingSplits = new ArrayDeque<WeepingStorage.Run>();
        private int currentSplitIndex;

        private UnlitSplittingIterator(int splitsSize, int[] splits, Iterator<WeepingStorage.Run> iterator) {
            this.splits = splits;
            this.iterator = iterator;
            this.currentSplitIndex = splitsSize - 1;
        }

        @Override
        public boolean hasNext() {
            return !this.remainingSplits.isEmpty() || this.iterator.hasNext();
        }

        @Override
        public WeepingStorage.Run next() {
            if (!this.remainingSplits.isEmpty()) {
                return this.remainingSplits.removeFirst();
            }
            WeepingStorage.Run run = this.iterator.next();
            while (this.currentSplitIndex >= 0) {
                int splitY = this.splits[this.currentSplitIndex] + IntWeepingStorage.this.minY;
                if (splitY < run.bottomY()) {
                    return run;
                }
                if (splitY > run.topY()) {
                    --this.currentSplitIndex;
                    return run;
                }
                if (splitY == run.topY()) {
                    --this.currentSplitIndex;
                    return run;
                }
                WeepingStorage.Run lower = new WeepingStorage.Run(run.bottomY(), splitY);
                run = new WeepingStorage.Run(splitY + 1, run.topY());
                this.remainingSplits.addFirst(lower);
                --this.currentSplitIndex;
            }
            return run;
        }
    }

    private class LitSplittingIterator
    implements Iterator<WeepingStorage.Run> {
        private final int[] splits;
        private final Iterator<WeepingStorage.Run> iterator;
        private final Deque<WeepingStorage.Run> remainingSplits = new ArrayDeque<WeepingStorage.Run>();
        private int currentSplitIndex;

        private LitSplittingIterator(int splitsSize, int[] splits, Iterator<WeepingStorage.Run> iterator) {
            this.splits = splits;
            this.iterator = iterator;
            this.currentSplitIndex = splitsSize - 1;
        }

        @Override
        public boolean hasNext() {
            return !this.remainingSplits.isEmpty() || this.iterator.hasNext();
        }

        @Override
        public WeepingStorage.Run next() {
            if (!this.remainingSplits.isEmpty()) {
                return this.remainingSplits.removeFirst();
            }
            WeepingStorage.Run run = this.iterator.next();
            while (this.currentSplitIndex >= 0) {
                int splitY = this.splits[this.currentSplitIndex] + IntWeepingStorage.this.minY;
                if (splitY < run.bottomY()) {
                    return run;
                }
                if (splitY > run.topY()) {
                    --this.currentSplitIndex;
                    continue;
                }
                if (splitY == run.bottomY()) {
                    --this.currentSplitIndex;
                    return run;
                }
                WeepingStorage.Run upper = new WeepingStorage.Run(splitY, run.topY());
                run = new WeepingStorage.Run(run.bottomY(), splitY - 1);
                this.remainingSplits.addFirst(upper);
                --this.currentSplitIndex;
            }
            return run;
        }
    }
}

