/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimeistdev.crystalline_sky.infrastructure;

import io.github.slimeistdev.crystalline_sky.infrastructure.WeepingStorage;
import io.github.slimeistdev.crystalline_sky.registry.CrystallineBlocks;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutableWeepingScanner
implements WeepingStorage.WeepingScanner {
    @Nullable
    private class_1922 blockView;
    private final int minY;
    private final class_2338.class_2339 reusablePos1 = new class_2338.class_2339();
    private final class_2338.class_2339 reusablePos2 = new class_2338.class_2339();

    public MutableWeepingScanner(int minY) {
        this.minY = minY;
    }

    public void setBlockView(@Nullable class_1922 blockView) {
        this.blockView = blockView;
    }

    private int transformInputY(int y) {
        return y + this.minY;
    }

    private int transformOutputY(int y) {
        return y == Integer.MIN_VALUE ? -1 : y - this.minY;
    }

    @NotNull
    private class_1922 checkBlockView() {
        if (this.blockView == null) {
            throw new IllegalStateException("blockView is not set");
        }
        return this.blockView;
    }

    @Override
    public int scan(int localX, int yMax, int localZ) {
        class_1922 blockView = this.checkBlockView();
        int actualYMax = this.transformInputY(yMax);
        class_2338.class_2339 topPos = this.reusablePos1.method_10103(localX, actualYMax, localZ);
        class_2338.class_2339 bottomPos = this.reusablePos2.method_10103(localX, actualYMax - 1, localZ);
        class_2680 topState = blockView.method_8320((class_2338)topPos);
        while (bottomPos.method_10264() >= this.minY) {
            class_2680 bottomState = blockView.method_8320((class_2338)bottomPos);
            if (MutableWeepingScanner.faceBlocksLight(topState, bottomState)) {
                return this.transformOutputY(bottomPos.method_10264());
            }
            topState = bottomState;
            topPos.method_10101((class_2382)bottomPos);
            bottomPos.method_10098(class_2350.field_11033);
        }
        return -1;
    }

    @Override
    public int scanForWeepingSky(int localX, int yMax, int localZ) {
        class_1922 blockView = this.checkBlockView();
        int actualYMax = this.transformInputY(yMax);
        class_2338.class_2339 topPos = this.reusablePos1.method_10103(localX, actualYMax, localZ);
        class_2338.class_2339 bottomPos = this.reusablePos2.method_10103(localX, actualYMax - 1, localZ);
        class_2680 topState = blockView.method_8320((class_2338)topPos);
        if (CrystallineBlocks.isWeepingSky(topState)) {
            return yMax;
        }
        while (bottomPos.method_10264() >= this.minY) {
            class_2680 bottomState = blockView.method_8320((class_2338)bottomPos);
            if (CrystallineBlocks.isWeepingSky(bottomState)) {
                return this.transformOutputY(bottomPos.method_10264());
            }
            if (MutableWeepingScanner.faceBlocksLight(topState, bottomState)) {
                return -1;
            }
            topState = bottomState;
            topPos.method_10101((class_2382)bottomPos);
            bottomPos.method_10098(class_2350.field_11033);
        }
        return -1;
    }

    @Override
    public boolean faceBlocksLight(int localX, int upperY, int localZ) {
        class_1922 blockView = this.checkBlockView();
        int actualY = this.transformInputY(upperY);
        this.reusablePos1.method_10103(localX, actualY, localZ);
        this.reusablePos2.method_10103(localX, actualY - 1, localZ);
        class_2680 upper = blockView.method_8320((class_2338)this.reusablePos1);
        class_2680 lower = blockView.method_8320((class_2338)this.reusablePos2);
        return MutableWeepingScanner.faceBlocksLight(upper, lower);
    }

    private static boolean faceBlocksLight(class_2680 upper, class_2680 lower) {
        if (lower.method_26193() != 0) {
            return true;
        }
        class_265 voxelShape = class_3558.method_51562((class_2680)upper, (class_2350)class_2350.field_11033);
        class_265 voxelShape2 = class_3558.method_51562((class_2680)lower, (class_2350)class_2350.field_11036);
        return class_259.method_20713((class_265)voxelShape, (class_265)voxelShape2);
    }
}

