/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimeistdev.crystalline_sky.infrastructure;

import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.NoSuchElementException;

public class PeekableIntIterator
implements IntIterator {
    private final IntIterator wrapped;
    private boolean hasPeeked = false;
    private int peekedValue;

    public PeekableIntIterator(IntIterator wrapped) {
        this.wrapped = wrapped;
    }

    public int peek() {
        if (!this.hasPeeked) {
            if (!this.wrapped.hasNext()) {
                throw new NoSuchElementException();
            }
            this.peekedValue = this.wrapped.nextInt();
            this.hasPeeked = true;
        }
        return this.peekedValue;
    }

    public int nextInt() {
        if (this.hasPeeked) {
            this.hasPeeked = false;
            return this.peekedValue;
        }
        return this.wrapped.nextInt();
    }

    public boolean hasNext() {
        return this.hasPeeked || this.wrapped.hasNext();
    }
}

