/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimeistdev.crystalline_sky.infrastructure.client;

import io.github.slimeistdev.crystalline_sky.infrastructure.WeepingStorage;
import io.github.slimeistdev.crystalline_sky.mixin_ducks.ChunkSkyLight_Duck;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_1923;
import net.minecraft.class_2265;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_8527;
import net.minecraft.class_8528;
import net.minecraft.class_863;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class WeepingSkyDebugRenderer
implements class_863.class_864 {
    private final class_310 client;
    @Nullable
    private class_2265 column = null;
    private boolean litMode = true;
    private static final int[] COLORS = new int[]{-65536, -33024, -256, -16711936, -16711681, -16744449, -16776961, -8453889, -65281, -65409};

    public WeepingSkyDebugRenderer(class_310 client) {
        this.client = client;
    }

    public void setColumn(@Nullable class_2265 column) {
        this.column = column;
    }

    public void setLitMode(boolean lit) {
        this.litMode = lit;
    }

    public void method_23109(class_4587 matrices, class_4597 vertexConsumers, double cameraX, double cameraY, double cameraZ) {
        if (this.column == null) {
            return;
        }
        if (this.client.field_1687 == null) {
            return;
        }
        class_1923 chunkPos = this.column.method_34873();
        class_8527 chunk = this.client.field_1687.method_2935().method_12246(chunkPos.field_9181, chunkPos.field_9180);
        if (chunk == null) {
            return;
        }
        class_8528 chunkSkyLight = chunk.method_12018();
        WeepingStorage weepingStorage = ((ChunkSkyLight_Duck)chunkSkyLight).crystalline_sky$getWeepingStorage();
        if (weepingStorage == null) {
            return;
        }
        int localX = this.column.comp_638() & 0xF;
        int localZ = this.column.comp_639() & 0xF;
        int lowestSourceY = chunkSkyLight.method_51535(localX, localZ);
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        float x1 = (float)((double)this.column.comp_638() - cameraX);
        float x2 = x1 + 1.0f;
        float z1 = (float)((double)this.column.comp_639() - cameraZ);
        float z2 = z1 + 1.0f;
        int colorIndex = 0;
        Iterable<WeepingStorage.Run> runs = this.litMode ? weepingStorage.iterateLitRuns(localX, localZ, lowestSourceY) : weepingStorage.iterateUnlitRuns(localX, localZ, lowestSourceY);
        for (WeepingStorage.Run run : runs) {
            int color = COLORS[colorIndex++ % COLORS.length];
            int bottomY = Math.max(-65535, run.bottomY());
            int topY = Math.min(run.topY(), 65535) + 1;
            float y1 = (float)((double)bottomY - cameraY);
            float y2 = (float)((double)topY - cameraY);
            WeepingSkyDebugRenderer.renderOutlinedBox(vertexConsumers, matrix4f, x1, x2, y1, y2, z1, z2, color);
        }
    }

    private static void renderOutlinedBox(class_4597 vertexConsumers, Matrix4f matrix, float x1, float x2, float y1, float y2, float z1, float z2, int color) {
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_49043((double)2.0));
        WeepingSkyDebugRenderer.renderHorizontalSquare(matrix, x1, x2, y1, z1, z2, color, vertexConsumer);
        WeepingSkyDebugRenderer.renderHorizontalSquare(matrix, x1, x2, y2, z1, z2, color, vertexConsumer);
        vertexConsumer.method_22918(matrix, x2, y2, z1).method_39415(color);
        vertexConsumer.method_22918(matrix, x2, y1, z1).method_39415(color);
        vertexConsumer.method_22918(matrix, x2, y1, z2).method_39415(color);
        vertexConsumer.method_22918(matrix, x2, y2, z2).method_39415(color);
        vertexConsumer.method_22918(matrix, x1, y2, z2).method_39415(color);
        vertexConsumer.method_22918(matrix, x1, y1, z2).method_39415(color);
    }

    private static void renderHorizontalSquare(Matrix4f matrix, float x1, float x2, float y, float z1, float z2, int color, class_4588 vertexConsumer) {
        vertexConsumer.method_22918(matrix, x1, y, z1).method_39415(color);
        vertexConsumer.method_22918(matrix, x2, y, z1).method_39415(color);
        vertexConsumer.method_22918(matrix, x2, y, z2).method_39415(color);
        vertexConsumer.method_22918(matrix, x1, y, z2).method_39415(color);
        vertexConsumer.method_22918(matrix, x1, y, z1).method_39415(color);
    }

    public void method_20414() {
        this.column = null;
    }
}

