/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimeistdev.crystalline_sky.mixin;

import io.github.slimeistdev.crystalline_sky.CrystallineSky;
import io.github.slimeistdev.crystalline_sky.infrastructure.IntWeepingStorage;
import io.github.slimeistdev.crystalline_sky.infrastructure.MutableWeepingScanner;
import io.github.slimeistdev.crystalline_sky.infrastructure.WeepingStorage;
import io.github.slimeistdev.crystalline_sky.mixin_ducks.ChunkSkyLight_Duck;
import io.github.slimeistdev.crystalline_sky.registry.CrystallineBlocks;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_4076;
import net.minecraft.class_5539;
import net.minecraft.class_8528;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_8528.class})
public abstract class ChunkSkyLightMixin
implements ChunkSkyLight_Duck {
    @Shadow
    @Final
    private int field_44712;
    @Shadow
    @Final
    private class_2338.class_2339 field_44714;
    @Shadow
    @Final
    private class_2338.class_2339 field_44715;
    @Unique
    @Final
    @Mutable
    private IntWeepingStorage crystalline_sky$weepingStorage;
    @Unique
    @Final
    @Mutable
    private MutableWeepingScanner crystalline_sky$weepingScanner;

    @Shadow
    private static boolean method_51539(class_2680 upper, class_2680 lower) {
        throw new RuntimeException("Mixin failed to apply");
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(class_5539 heightLimitView, CallbackInfo ci) {
        this.crystalline_sky$weepingStorage = new IntWeepingStorage(this.field_44712 + 1);
        this.crystalline_sky$weepingScanner = new MutableWeepingScanner(this.field_44712 + 1);
    }

    @Override
    public WeepingStorage crystalline_sky$getWeepingStorage() {
        return this.crystalline_sky$weepingStorage;
    }

    @Inject(method={"refreshSurfaceY"}, at={@At(value="HEAD")})
    private void refreshWeepingSurfaceY(class_2791 chunk, CallbackInfo ci) {
        int highestNonEmptySectionIndex = chunk.method_12040();
        if (highestNonEmptySectionIndex == -1) {
            this.crystalline_sky$weepingStorage.clear();
        } else {
            int topY = class_4076.method_18688((int)(chunk.method_31604(highestNonEmptySectionIndex) + 1));
            int weepingMinY = this.field_44712 + 1;
            ShortArrayList data = new ShortArrayList();
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    data.clear();
                    class_2338.class_2339 topPos = this.field_44714.method_10103(x, topY, z);
                    class_2338.class_2339 bottomPos = this.field_44715.method_10103(x, topY - 1, z);
                    class_2680 topState = class_2246.field_10124.method_9564();
                    int foundSky = -1;
                    for (int sectionIndex = highestNonEmptySectionIndex; sectionIndex >= 0; --sectionIndex) {
                        class_2826 section = chunk.method_38259(sectionIndex);
                        if (section.method_38292()) {
                            topState = class_2246.field_10124.method_9564();
                            topPos.method_33098(class_4076.method_18688((int)chunk.method_31604(sectionIndex)));
                            bottomPos.method_33098(topPos.method_10264() - 1);
                            continue;
                        }
                        for (int y = 15; y >= 0; --y) {
                            class_2680 bottomState = section.method_12254(x, y, z);
                            if (CrystallineBlocks.isWeepingSky(bottomState)) {
                                if (foundSky == -1) {
                                    foundSky = (short)(bottomPos.method_10264() - weepingMinY);
                                }
                            } else if (ChunkSkyLightMixin.method_51539(topState, bottomState) && foundSky != -1) {
                                short lastLitY = (short)(bottomPos.method_10264() - weepingMinY + 1);
                                data.add((short)foundSky);
                                data.add(lastLitY);
                                foundSky = -1;
                            }
                            topState = bottomState;
                            topPos.method_10101((class_2382)bottomPos);
                            bottomPos.method_10098(class_2350.field_11033);
                        }
                    }
                    if (foundSky != -1) {
                        data.add((short)foundSky);
                        data.add((short)-1);
                    }
                    this.crystalline_sky$weepingStorage.set(x, z, (ShortList)data);
                }
            }
        }
    }

    @Inject(method={"isSkyLightAccessible(Lnet/minecraft/world/BlockView;III)Z"}, at={@At(value="HEAD")})
    private void updateWeepingSkyState(class_1922 blockView, int localX, int y, int localZ, CallbackInfoReturnable<Boolean> cir) {
        class_2338.class_2339 pos = this.field_44714.method_10103(localX, y, localZ);
        class_2680 state = blockView.method_8320((class_2338)pos);
        this.crystalline_sky$weepingScanner.setBlockView(blockView);
        int weepingMinY = this.field_44712 + 1;
        if (state.method_26215()) {
            this.crystalline_sky$weepingStorage.insertAir(localX, y - weepingMinY, localZ, this.crystalline_sky$weepingScanner);
        } else if (CrystallineBlocks.isWeepingSky(state)) {
            this.crystalline_sky$weepingStorage.insertSky(localX, y - weepingMinY, localZ, this.crystalline_sky$weepingScanner);
        } else if (state.method_26225()) {
            this.crystalline_sky$weepingStorage.insertSolid(localX, y - weepingMinY, localZ, this.crystalline_sky$weepingScanner);
        }
        CrystallineSky.LOG.debug("Weeping sky ranges for local column [{}, {}] in {}:", new Object[]{localX, localZ, blockView});
        this.crystalline_sky$weepingStorage.debugState(localX, localZ, arg_0 -> ((Logger)CrystallineSky.LOG).debug(arg_0));
        this.crystalline_sky$weepingScanner.setBlockView(null);
    }
}

