/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimeistdev.crystalline_sky.mixin;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Definitions;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import io.github.slimeistdev.crystalline_sky.infrastructure.WeepingStorage;
import io.github.slimeistdev.crystalline_sky.mixin.LightStorageAccessor;
import io.github.slimeistdev.crystalline_sky.mixin.SkyLightStorageAccessor;
import io.github.slimeistdev.crystalline_sky.mixin_ducks.ChunkSkyLight_Duck;
import io.github.slimeistdev.crystalline_sky.registry.CrystallineBlocks;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2804;
import net.minecraft.class_2823;
import net.minecraft.class_3556;
import net.minecraft.class_3558;
import net.minecraft.class_3560;
import net.minecraft.class_3572;
import net.minecraft.class_4076;
import net.minecraft.class_8527;
import net.minecraft.class_8528;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3572.class})
public abstract class ChunkSkyLightProviderMixin<M extends class_3556<M>, S extends class_3560<M>>
extends class_3558<M, S> {
    @Shadow
    @Final
    private class_2338.class_2339 field_44746;
    @Shadow
    @Final
    private static long field_44743;
    @Shadow
    @Final
    private static long field_44744;
    @Shadow
    @Final
    private static long field_44745;

    @Shadow
    private static boolean method_51584(int lightLevel) {
        throw new RuntimeException("Mixin failed to apply");
    }

    protected ChunkSkyLightProviderMixin(class_2823 chunkProvider, S lightStorage) {
        super(chunkProvider, lightStorage);
    }

    @Inject(method={"checkNode"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/chunk/light/SkyLightStorage;get(J)I")})
    private void emitFromCrystallineSky(long blockPos, CallbackInfo ci) {
        int level;
        class_2680 state = this.method_50018((class_2338)this.field_44746.method_16363(blockPos));
        int n = level = CrystallineBlocks.isWeepingSky(state) ? 15 : CrystallineBlocks.getSkyLightLevel(state);
        if (level > 0 && ((LightStorageAccessor)this.field_15793).crystalline_sky$callIsSectionInEnabledColumn(class_4076.method_18691((long)blockPos))) {
            this.method_51566(blockPos, class_3558.class_8531.method_51573((int)level, (boolean)ChunkSkyLightProviderMixin.method_51563((class_2680)state)));
        }
    }

    @WrapOperation(method={"checkNode"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definitions(value={@Definition(id="y", local={@Local(type=int.class, name={"y"}, ordinal=1)}), @Definition(id="lowestSourceY", local={@Local(type=int.class, name={"lowestSourceY"}, ordinal=3)})})
    @Expression(value={"y >= lowestSourceY"})
    private boolean weepBelowTheLowest(int y, int lowestSourceY, Operation<Boolean> original, @Local(name={"x"}, ordinal=0) int x, @Local(name={"z"}, ordinal=2) int z) {
        if (((Boolean)original.call(new Object[]{y, lowestSourceY})).booleanValue()) {
            return true;
        }
        class_8527 chunk = this.field_15795.method_12246(class_4076.method_18675((int)x), class_4076.method_18675((int)z));
        if (chunk == null) {
            return false;
        }
        class_8528 chunkSkyLight = chunk.method_12018();
        if (chunkSkyLight == null) {
            return false;
        }
        int localX = class_4076.method_18684((int)x);
        int localZ = class_4076.method_18684((int)z);
        WeepingStorage weepingStorage = ((ChunkSkyLight_Duck)chunkSkyLight).crystalline_sky$getWeepingStorage();
        if (weepingStorage.isColumnEmpty(localX, localZ)) {
            return false;
        }
        return weepingStorage.isLit(localX, y, localZ);
    }

    @WrapOperation(method={"propagateDecrease"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/chunk/light/ChunkSkyLightProvider;enqueueDecrease(JJ)V")})
    private void decreaseTakesLightIntoAccount1(class_3572 instance, long blockPos, long flags, Operation<Void> original, @Local(name={"k"}, ordinal=2) int k) {
        class_2680 state = this.method_50018((class_2338)this.field_44746.method_16363(blockPos));
        int luminance = CrystallineBlocks.getSkyLightLevel(state);
        if (luminance < k) {
            original.call(new Object[]{instance, blockPos, flags});
        }
        if (luminance > 0) {
            this.method_51566(blockPos, class_3558.class_8531.method_51573((int)luminance, (boolean)ChunkSkyLightProviderMixin.method_51563((class_2680)state)));
        }
    }

    @WrapOperation(method={"propagateDecrease"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/chunk/light/ChunkSkyLightProvider;propagateFromEmptySections(JLnet/minecraft/util/math/Direction;IZI)V")})
    private void decreaseTakesLightIntoAccount2(class_3572 instance, long blockPos, class_2350 direction, int lightLevel, boolean shouldIncrease, int emptySections, Operation<Void> original, @Local(name={"k"}, ordinal=2) int k) {
        class_2680 state = this.method_50018((class_2338)this.field_44746.method_16363(blockPos));
        int luminance = CrystallineBlocks.getSkyLightLevel(state);
        if (luminance < k) {
            original.call(new Object[]{instance, blockPos, direction, lightLevel, shouldIncrease, emptySections});
        }
        if (luminance > 0) {
            original.call(new Object[]{instance, blockPos, direction, luminance, true, emptySections});
        }
    }

    @Inject(method={"propagateLight"}, at={@At(value="RETURN")})
    private void propagateCrystallineSkyLight(class_1923 chunkPos, CallbackInfo ci) {
        class_8527 lightSourceView = this.field_15795.method_12246(chunkPos.field_9181, chunkPos.field_9180);
        if (!(lightSourceView instanceof class_2791)) {
            return;
        }
        class_2791 chunk = (class_2791)lightSourceView;
        chunk.method_51525(CrystallineBlocks::isCrystallineSky, (pos, state) -> this.method_51566(pos.method_10063(), class_3558.class_8531.method_51573((int)CrystallineBlocks.getSkyLightLevel(state), (boolean)ChunkSkyLightProviderMixin.method_51563((class_2680)state))));
    }

    @Inject(method={"removeSourcesBelow"}, at={@At(value="HEAD")}, cancellable=true)
    private void removeWeepingSourcesBelow(int x, int z, int lowestSourceY, int minY, CallbackInfo ci) {
        class_8527 chunk = this.field_15795.method_12246(class_4076.method_18675((int)x), class_4076.method_18675((int)z));
        if (chunk == null) {
            return;
        }
        class_8528 chunkSkyLight = chunk.method_12018();
        if (chunkSkyLight == null) {
            return;
        }
        int localX = class_4076.method_18684((int)x);
        int localZ = class_4076.method_18684((int)z);
        WeepingStorage weepingStorage = ((ChunkSkyLight_Duck)chunkSkyLight).crystalline_sky$getWeepingStorage();
        if (weepingStorage.isColumnEmpty(localX, localZ) && weepingStorage.hasNoUnlitSplits(localX, localZ)) {
            return;
        }
        ci.cancel();
        int sectionX = class_4076.method_18675((int)x);
        int sectionZ = class_4076.method_18675((int)z);
        int effectiveLowestSourceY = lowestSourceY <= minY ? Integer.MIN_VALUE : lowestSourceY;
        SkyLightStorageAccessor lightStorageAccessor = (SkyLightStorageAccessor)this.field_15793;
        block0: for (WeepingStorage.Run run : weepingStorage.iterateUnlitRuns(localX, localZ, effectiveLowestSourceY)) {
            int topUnlit = run.topY();
            int bottomUnlit = run.bottomY();
            int sectionY = class_4076.method_18675((int)topUnlit);
            while (lightStorageAccessor.crystalline_sky$isAboveMinHeight(sectionY)) {
                if (lightStorageAccessor.crystalline_sky$hasSection(class_4076.method_18685((int)sectionX, (int)sectionY, (int)sectionZ))) {
                    int minYInSection = class_4076.method_18688((int)sectionY);
                    int maxYInSection = minYInSection + 15;
                    if (maxYInSection < bottomUnlit) continue block0;
                    for (int it_y = Math.min(maxYInSection, topUnlit); it_y >= Math.max(minYInSection, bottomUnlit); --it_y) {
                        long it_pos = class_2338.method_10064((int)x, (int)it_y, (int)z);
                        if (CrystallineBlocks.isCrystallineSky(chunk.method_8320((class_2338)this.field_44746.method_16363(it_pos)))) continue;
                        if (!ChunkSkyLightProviderMixin.method_51584(lightStorageAccessor.crystalline_sky$get(it_pos))) continue block0;
                        lightStorageAccessor.crystalline_sky$set(it_pos, 0);
                        this.method_51565(it_pos, it_y == topUnlit ? field_44743 : field_44744);
                    }
                }
                --sectionY;
            }
        }
    }

    @Inject(method={"addSourcesAbove"}, at={@At(value="RETURN")})
    private void addAdditionalWeepingSourcesAbove(int x, int z, int lowestSourceY, int minY, CallbackInfo ci, @Local(name={"maxAdjacentLowestSourceY"}, ordinal=6) int maxAdjacentLowestSourceY) {
        int effectiveLowestSourceY;
        class_8527 chunk = this.field_15795.method_12246(class_4076.method_18675((int)x), class_4076.method_18675((int)z));
        if (chunk == null) {
            return;
        }
        class_8528 chunkSkyLight = chunk.method_12018();
        if (chunkSkyLight == null) {
            return;
        }
        int localX = class_4076.method_18684((int)x);
        int localZ = class_4076.method_18684((int)z);
        WeepingStorage weepingStorage = ((ChunkSkyLight_Duck)chunkSkyLight).crystalline_sky$getWeepingStorage();
        if (weepingStorage.isColumnEmpty(localX, localZ)) {
            weepingStorage.clearTempRunSplits(localX, localZ);
            return;
        }
        int sectionX = class_4076.method_18675((int)x);
        int sectionZ = class_4076.method_18675((int)z);
        int n = effectiveLowestSourceY = lowestSourceY <= minY ? Integer.MIN_VALUE : lowestSourceY;
        if (effectiveLowestSourceY == Integer.MIN_VALUE) {
            weepingStorage.clearTempRunSplits(localX, localZ);
            return;
        }
        SkyLightStorageAccessor lightStorageAccessor = (SkyLightStorageAccessor)this.field_15793;
        block0: for (WeepingStorage.Run run : weepingStorage.iterateLitRuns(localX, localZ, effectiveLowestSourceY)) {
            if (run.topY() == Integer.MAX_VALUE) {
                if (run.bottomY() == effectiveLowestSourceY) continue;
                run = run.withTopY(effectiveLowestSourceY - 1);
            }
            int lowestRelevantY = Math.max(run.bottomY(), minY);
            long it_packedSection = class_4076.method_18685((int)sectionX, (int)class_4076.method_18675((int)lowestRelevantY), (int)sectionZ);
            while (!lightStorageAccessor.crystalline_sky$isAtOrAboveTopmostSection(it_packedSection)) {
                if (lightStorageAccessor.crystalline_sky$hasSection(it_packedSection)) {
                    int minYInSection = class_4076.method_18688((int)class_4076.method_18689((long)it_packedSection));
                    int maxYInSection = minYInSection + 15;
                    if (minYInSection > run.topY()) continue block0;
                    for (int it_y = Math.max(minYInSection, lowestRelevantY); it_y <= Math.min(maxYInSection, run.topY()); ++it_y) {
                        long it_pos = class_2338.method_10064((int)x, (int)it_y, (int)z);
                        if (CrystallineBlocks.isCrystallineSky(chunk.method_8320((class_2338)this.field_44746.method_16363(it_pos)))) continue;
                        if (ChunkSkyLightProviderMixin.method_51584(lightStorageAccessor.crystalline_sky$get(it_pos))) continue block0;
                        lightStorageAccessor.crystalline_sky$set(it_pos, 15);
                        if (it_y >= maxAdjacentLowestSourceY && it_y != lowestRelevantY) continue;
                        this.method_51566(it_pos, field_44745);
                    }
                }
                it_packedSection = class_4076.method_18679((long)it_packedSection, (class_2350)class_2350.field_11036);
            }
        }
        weepingStorage.clearTempRunSplits(localX, localZ);
    }

    @Inject(method={"propagateLight"}, at={@At(value="RETURN")})
    private void propagateWeepingLight(class_1923 chunkPos, CallbackInfo ci, @Local(name={"sourcesO"}, ordinal=0) class_8528 sourcesO, @Local(name={"sourcesZN"}, ordinal=1) class_8528 sourcesZN, @Local(name={"sourcesZP"}, ordinal=2) class_8528 sourcesZP, @Local(name={"sourcesXN"}, ordinal=3) class_8528 sourcesXN, @Local(name={"sourcesXP"}, ordinal=4) class_8528 sourcesXP) {
        WeepingStorage weepingStorage = ((ChunkSkyLight_Duck)sourcesO).crystalline_sky$getWeepingStorage();
        if (weepingStorage == null) {
            return;
        }
        boolean hasAny = false;
        block0: for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                if (weepingStorage.isColumnEmpty(localX, localZ)) continue;
                hasAny = true;
                break block0;
            }
        }
        if (!hasAny) {
            return;
        }
        long packedZeroPos = class_4076.method_51687((int)chunkPos.field_9181, (int)chunkPos.field_9180);
        SkyLightStorageAccessor lightStorageAccessor = (SkyLightStorageAccessor)this.field_15793;
        int topSectionY = lightStorageAccessor.crystalline_sky$getTopSectionForColumn(packedZeroPos);
        int bottomSectionY = lightStorageAccessor.crystalline_sky$getMinSectionY();
        int baseX = class_4076.method_18688((int)chunkPos.field_9181);
        int baseZ = class_4076.method_18688((int)chunkPos.field_9180);
        int minY = class_4076.method_18688((int)bottomSectionY);
        class_2804[] lightArrays = new class_2804[topSectionY - bottomSectionY];
        for (int sectionY = topSectionY - 1; sectionY >= bottomSectionY; --sectionY) {
            long packedSectionPos = class_4076.method_18685((int)chunkPos.field_9181, (int)sectionY, (int)chunkPos.field_9180);
            lightArrays[sectionY - bottomSectionY] = lightStorageAccessor.crystalline_sky$method_51547(packedSectionPos);
        }
        for (int localZ = 0; localZ < 16; ++localZ) {
            for (int localX = 0; localX < 16; ++localX) {
                int effectiveLowestSourceY;
                if (weepingStorage.isColumnEmpty(localX, localZ)) continue;
                int lowestSourceY = sourcesO.method_51535(localX, localZ);
                int n = effectiveLowestSourceY = lowestSourceY <= minY ? Integer.MIN_VALUE : lowestSourceY;
                if (effectiveLowestSourceY == Integer.MIN_VALUE) continue;
                int minSourceY_ZN = localZ == 0 ? sourcesZN.method_51535(localX, 15) : sourcesO.method_51535(localX, localZ - 1);
                int minSourceY_ZP = localZ == 15 ? sourcesZP.method_51535(localX, 0) : sourcesO.method_51535(localX, localZ + 1);
                int minSourceY_XN = localX == 0 ? sourcesXN.method_51535(15, localZ) : sourcesO.method_51535(localX - 1, localZ);
                int minSourceY_XP = localX == 15 ? sourcesXP.method_51535(0, localZ) : sourcesO.method_51535(localX + 1, localZ);
                int minSourceY_max = Math.max(Math.max(minSourceY_ZN, minSourceY_ZP), Math.max(minSourceY_XN, minSourceY_XP));
                block5: for (WeepingStorage.Run run : weepingStorage.iterateLitRuns(localX, localZ, effectiveLowestSourceY)) {
                    if (run.topY() == Integer.MAX_VALUE) {
                        if (run.bottomY() == effectiveLowestSourceY) continue;
                        run = run.withTopY(effectiveLowestSourceY - 1);
                    }
                    int lowestRelevantY = Math.max(run.bottomY(), minY);
                    for (int sectionY = class_4076.method_18675((int)lowestRelevantY); sectionY <= topSectionY - 1; ++sectionY) {
                        class_2804 lightArray = lightArrays[sectionY - bottomSectionY];
                        if (lightArray == null) continue;
                        int minYInSection = class_4076.method_18688((int)sectionY);
                        int maxYInSection = minYInSection + 15;
                        if (minYInSection > run.topY()) continue block5;
                        for (int it_y = Math.max(minYInSection, lowestRelevantY); it_y <= Math.min(maxYInSection, run.topY()); ++it_y) {
                            lightArray.method_12145(localX, class_4076.method_18684((int)it_y), localZ, 15);
                            if (it_y != lowestRelevantY && it_y >= minSourceY_max) continue;
                            long it_pos = class_2338.method_10064((int)(baseX + localX), (int)it_y, (int)(baseZ + localZ));
                            this.method_51566(it_pos, class_3558.class_8531.method_51578((it_y == lowestRelevantY ? 1 : 0) != 0, (it_y < minSourceY_ZN ? 1 : 0) != 0, (it_y < minSourceY_ZP ? 1 : 0) != 0, (it_y < minSourceY_XN ? 1 : 0) != 0, (it_y < minSourceY_XP ? 1 : 0) != 0));
                        }
                    }
                }
            }
        }
    }
}

