/*
 * Decompiled with CFR 0.152.
 */
package com.example.tpstab;

import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TPSTabPlugin
extends JavaPlugin
implements TabCompleter {
    private boolean showTps;
    private boolean showPing;
    private boolean showMspt;
    private Map<UUID, Boolean> playerHotbarStatus = new HashMap<UUID, Boolean>();
    private Map<String, String> messages = new HashMap<String, String>();
    private static final DecimalFormat df = new DecimalFormat("#.##");

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.loadMessages();
        this.getCommand("tpstab").setTabCompleter((TabCompleter)this);
        this.startUpdateTask();
    }

    private void loadConfig() {
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        this.showTps = config.getBoolean("settings.show-tps", true);
        this.showPing = config.getBoolean("settings.show-ping", true);
        this.showMspt = config.getBoolean("settings.show-mspt", true);
    }

    private void loadMessages() {
        String language = this.getConfig().getString("settings.language", "en");
        File messageFile = new File(this.getDataFolder(), "lang/messages_" + language + ".yml");
        if (!messageFile.exists()) {
            this.saveResource("lang/messages_" + language + ".yml", false);
        }
        YamlConfiguration messageConfig = YamlConfiguration.loadConfiguration((File)messageFile);
        for (String key : messageConfig.getConfigurationSection("messages").getKeys(false)) {
            this.messages.put(key, messageConfig.getString("messages." + key));
        }
    }

    private String getMessage(String key) {
        return this.messages.getOrDefault(key, key);
    }

    private void updateHotbar(Player player) {
        if (!this.playerHotbarStatus.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            return;
        }
        double tps = this.getTPS();
        double mspt = tps > 0.0 ? 1000.0 / tps : -1.0;
        String tpsFormatted = String.format("%.2f", tps);
        String msptFormatted = mspt >= 0.0 ? String.format("%.2f", mspt) : "N/A";
        StringBuilder messageBuilder = new StringBuilder();
        if (this.showPing) {
            int ping = player.getPing();
            ChatColor pingColor = this.getPingColor(ping);
            messageBuilder.append(ChatColor.WHITE).append("Ping: ").append(pingColor).append(ping).append(" ms ");
        }
        if (this.showTps) {
            ChatColor tpsColor = this.getTPSColor(tps);
            messageBuilder.append(ChatColor.WHITE).append("TPS: ").append(tpsColor).append(tpsFormatted).append(" ");
        }
        if (this.showMspt) {
            ChatColor msptColor = this.getMSPTColor(mspt);
            messageBuilder.append(ChatColor.WHITE).append("MSPT: ").append(msptColor).append(msptFormatted).append(" ms");
        }
        String message = messageBuilder.toString().trim();
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
    }

    private void startUpdateTask() {
        new BukkitRunnable(){

            public void run() {
                TPSTabPlugin.this.updateTabList();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    TPSTabPlugin.this.updateHotbar(player);
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }

    private void updateTabList() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            int ping = player.getPing();
            double tps = this.getTPS();
            double mspt = tps > 0.0 ? 1000.0 / tps : -1.0;
            String tpsFormatted = String.format("%.2f", tps);
            String msptFormatted = mspt >= 0.0 ? String.format("%.2f", mspt) : "N/A";
            StringBuilder footerBuilder = new StringBuilder();
            if (this.showPing) {
                ChatColor pingColor = this.getPingColor(ping);
                footerBuilder.append(ChatColor.WHITE).append("Ping: ").append(pingColor).append(ping).append(" ms ");
            }
            if (this.showTps) {
                ChatColor tpsColor = this.getTPSColor(tps);
                footerBuilder.append(ChatColor.WHITE).append("TPS: ").append(tpsColor).append(tpsFormatted).append(" ");
            }
            if (this.showMspt) {
                ChatColor msptColor = this.getMSPTColor(mspt);
                footerBuilder.append(ChatColor.WHITE).append("MSPT: ").append(msptColor).append(msptFormatted).append(" ms");
            }
            player.setPlayerListFooter(footerBuilder.toString().trim());
        }
    }

    private ChatColor getTPSColor(double tps) {
        if (tps >= 18.0) {
            return ChatColor.GREEN;
        }
        if (tps >= 10.0) {
            return ChatColor.YELLOW;
        }
        return ChatColor.RED;
    }

    private ChatColor getMSPTColor(double mspt) {
        if (mspt <= 50.0) {
            return ChatColor.GREEN;
        }
        if (mspt <= 100.0) {
            return ChatColor.YELLOW;
        }
        return ChatColor.RED;
    }

    private ChatColor getPingColor(int ping) {
        if (ping <= 50) {
            return ChatColor.GREEN;
        }
        if (ping <= 150) {
            return ChatColor.YELLOW;
        }
        return ChatColor.RED;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("tpstab")) {
            if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
                this.showHelp(sender);
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                if (sender.hasPermission("tpstab.reload")) {
                    this.loadConfig();
                    this.loadMessages();
                    sender.sendMessage(ChatColor.GREEN + this.getMessage("reload"));
                    return true;
                }
                sender.sendMessage(ChatColor.RED + this.getMessage("no_permission"));
                return true;
            }
            if (args[0].equalsIgnoreCase("hotbar")) {
                if (sender.hasPermission("tpstab.hotbar") && sender instanceof Player) {
                    UUID playerId;
                    Player player = (Player)sender;
                    boolean currentStatus = this.playerHotbarStatus.getOrDefault(playerId = player.getUniqueId(), false);
                    this.playerHotbarStatus.put(playerId, !currentStatus);
                    sender.sendMessage(ChatColor.GREEN + this.getMessage("hotbar_toggle").replace("{status}", !currentStatus ? this.getMessage("enabled") : this.getMessage("disabled")));
                    return true;
                }
                sender.sendMessage(ChatColor.RED + this.getMessage("no_permission"));
                return true;
            }
            if (args[0].equalsIgnoreCase("cpu")) {
                if (sender.hasPermission("tpstab.cpu")) {
                    this.showCpuUsage(sender);
                    return true;
                }
                sender.sendMessage(ChatColor.RED + this.getMessage("no_permission"));
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (command.getName().equalsIgnoreCase("tpstab") && args.length == 1) {
            if ("help".startsWith(args[0].toLowerCase())) {
                completions.add("help");
            }
            if ("reload".startsWith(args[0].toLowerCase())) {
                completions.add("reload");
            }
            if ("hotbar".startsWith(args[0].toLowerCase())) {
                completions.add("hotbar");
            }
            if ("cpu".startsWith(args[0].toLowerCase())) {
                completions.add("cpu");
            }
        }
        return completions;
    }

    private void showHelp(CommandSender sender) {
        sender.sendMessage(ChatColor.AQUA + "-----------TPSTab Plugin Commands-----------");
        sender.sendMessage(ChatColor.GOLD + "/tpstab help" + ChatColor.WHITE + " - " + this.getMessage("help_description"));
        sender.sendMessage(ChatColor.GOLD + "/tpstab reload" + ChatColor.WHITE + " - " + this.getMessage("reload_description"));
        sender.sendMessage(ChatColor.GOLD + "/tpstab hotbar" + ChatColor.WHITE + " - " + this.getMessage("hotbar_description"));
        sender.sendMessage(ChatColor.GOLD + "/tpstab cpu" + ChatColor.WHITE + " - " + this.getMessage("cpu_description"));
    }

    private void showCpuUsage(CommandSender sender) {
        OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        double systemLoad = osBean.getSystemCpuLoad() * 100.0;
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        sender.sendMessage(ChatColor.GOLD + "---------------TPSTab Plugin---------------");
        sender.sendMessage(ChatColor.GREEN + this.getMessage("cpu_usage").replace("{usage}", df.format(systemLoad)));
        sender.sendMessage(ChatColor.GREEN + this.getMessage("total_memory").replace("{memory}", this.formatBytes(totalMemory)));
        sender.sendMessage(ChatColor.GREEN + this.getMessage("used_memory").replace("{memory}", this.formatBytes(usedMemory)));
        sender.sendMessage(ChatColor.GREEN + this.getMessage("free_memory").replace("{memory}", this.formatBytes(freeMemory)));
    }

    private String formatBytes(long bytes) {
        double kb = (double)bytes / 1024.0;
        double mb = kb / 1024.0;
        double gb = mb / 1024.0;
        if (gb >= 1.0) {
            return df.format(gb) + " GB";
        }
        if (mb >= 1.0) {
            return df.format(mb) + " MB";
        }
        if (kb >= 1.0) {
            return df.format(kb) + " KB";
        }
        return bytes + " B";
    }

    private double getTPS() {
        try {
            Object minecraftServer = Bukkit.getServer().getClass().getMethod("getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
            Field recentTpsField = minecraftServer.getClass().getField("recentTps");
            double[] recentTps = (double[])recentTpsField.get(minecraftServer);
            return recentTps[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
    }
}

