/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.convenient_malum;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="convenient_malum", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue LOG_DIRT_BLOCK = BUILDER.comment("Whether to log the dirt block on common setup").define("logDirtBlock", true);
    private static final ForgeConfigSpec.IntValue MAGIC_NUMBER = BUILDER.comment("A magic number").defineInRange("magicNumber", 42, 0, Integer.MAX_VALUE);
    public static final ForgeConfigSpec.ConfigValue<String> MAGIC_NUMBER_INTRODUCTION = BUILDER.comment("What you want the introduction message to be for the magic number").define("magicNumberIntroduction", (Object)"The magic number is... ");
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> ITEM_STRINGS = BUILDER.comment("A list of items to log on common setup.").defineListAllowEmpty("items", List.of("minecraft:iron_ingot"), Config::validateItemName);
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static boolean logDirtBlock = true;
    public static int magicNumber = 42;
    public static String magicNumberIntroduction = "The magic number is... ";
    public static Set<Item> items = Set.of();

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && ForgeRegistries.ITEMS.containsKey(ResourceLocation.parse((String)(itemName = (String)obj)));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        try {
            logDirtBlock = (Boolean)LOG_DIRT_BLOCK.get();
            magicNumber = (Integer)MAGIC_NUMBER.get();
            magicNumberIntroduction = (String)MAGIC_NUMBER_INTRODUCTION.get();
            List itemStrings = (List)ITEM_STRINGS.get();
            if (itemStrings != null) {
                items = itemStrings.stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet());
            }
        }
        catch (Exception e) {
            logDirtBlock = true;
            magicNumber = 42;
            magicNumberIntroduction = "The magic number is... ";
            items = Set.of();
        }
    }
}

