/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.convenient_malum;

import com.bmt.convenient_malum.Config;
import com.bmt.convenient_malum.ConvenientMalumMenus;
import com.bmt.convenient_malum.client.gui.SoulGuiScreen;
import com.bmt.convenient_malum.item.MalumBagItem;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="convenient_malum")
public class ConvenientMalum {
    public static final String MOD_ID = "convenient_malum";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"convenient_malum");
    public static final RegistryObject<Item> MALUM_BAG = ITEMS.register("malum_bag", () -> new MalumBagItem());

    public ConvenientMalum() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(modEventBus);
        ConvenientMalumMenus.REGISTRY.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modEventBus.register(Config.class);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        if (Config.logDirtBlock) {
            LOGGER.info("DIRT BLOCK >> {}", (Object)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50493_));
        }
        if (Config.magicNumberIntroduction != null && Config.magicNumber != 0) {
            LOGGER.info(Config.magicNumberIntroduction + Config.magicNumber);
        } else {
            LOGGER.info("Magic number configuration not loaded yet");
        }
        if (Config.items != null) {
            Config.items.forEach(item -> LOGGER.info("ITEM >> {}", (Object)item.toString()));
        } else {
            LOGGER.info("Config items is null - configuration not loaded yet");
        }
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.m_246326_((ItemLike)MALUM_BAG.get());
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(modid="convenient_malum", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
            event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)ConvenientMalumMenus.SOUL_GUI.get()), SoulGuiScreen::new));
        }
    }
}

