/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.convenient_malum.item;

import com.bmt.convenient_malum.world.inventory.SoulGuiMenu;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class MalumBagItem
extends Item {
    private final Map<Integer, Integer> conversionTimers = new HashMap<Integer, Integer>();

    public MalumBagItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.m_5776_()) {
            player.m_5893_((MenuProvider)new SimpleMenuProvider((containerId, playerInventory, playerEntity) -> new SoulGuiMenu(containerId, playerInventory, player), stack.m_41786_()));
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    public void onUpdate(ItemStack stack, Level level, Player player, int slot, boolean isSelected) {
        if (level.m_5776_()) {
            return;
        }
        LazyOptional capability = stack.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (!capability.isPresent()) {
            return;
        }
        ItemStackHandler itemHandler = (ItemStackHandler)capability.resolve().get();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack soulItem = itemHandler.getStackInSlot(i);
            if (!soulItem.m_41619_() && this.isSpiritItem(soulItem)) {
                int currentTimer = this.conversionTimers.getOrDefault(i, 0);
                if (++currentTimer >= 200) {
                    this.convertSoulToExperience(level, player, soulItem, i, itemHandler);
                    this.conversionTimers.remove(i);
                    continue;
                }
                this.conversionTimers.put(i, currentTimer);
                continue;
            }
            this.conversionTimers.remove(i);
        }
    }

    private boolean isSpiritItem(ItemStack stack) {
        String itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString();
        return itemId.contains("malum:") && itemId.contains("_spirit");
    }

    private void convertSoulToExperience(Level level, Player player, ItemStack soulItem, int slot, ItemStackHandler itemHandler) {
        int experienceAmount = this.getExperienceForSoul(soulItem);
        if (experienceAmount > 0) {
            ExperienceOrb expOrb = new ExperienceOrb(level, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), experienceAmount);
            level.m_7967_((Entity)expOrb);
            itemHandler.extractItem(slot, 1, false);
        }
    }

    private int getExperienceForSoul(ItemStack soulItem) {
        String itemId;
        return switch (itemId = ForgeRegistries.ITEMS.getKey((Object)soulItem.m_41720_()).toString()) {
            case "malum:sacred_spirit" -> 4;
            case "malum:wicked_spirit" -> 5;
            case "malum:arcane_spirit" -> 5;
            case "malum:eldritch_spirit" -> 6;
            case "malum:earthen_spirit" -> 6;
            case "malum:infernal_spirit" -> 6;
            case "malum:aerial_spirit" -> 5;
            case "malum:aqueous_spirit" -> 8;
            case "malum:umbral_spirit" -> 22;
            default -> 5;
        };
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){
            private final ItemStackHandler itemHandler = new ItemStackHandler(9){

                protected void onContentsChanged(int slot) {
                    if (stack.m_41783_() == null) {
                        stack.m_41751_(new CompoundTag());
                    }
                    stack.m_41783_().m_128365_("Inventory", (Tag)this.serializeNBT());
                    MalumBagItem.this.conversionTimers.remove(slot);
                }
            };
            {
                if (stack.m_41783_() != null && stack.m_41783_().m_128441_("Inventory")) {
                    this.itemHandler.deserializeNBT(stack.m_41783_().m_128469_("Inventory"));
                }
            }

            public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
                if (cap == ForgeCapabilities.ITEM_HANDLER) {
                    return LazyOptional.of(() -> this.itemHandler);
                }
                return LazyOptional.empty();
            }
        };
    }
}

