/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.convenient_malum.world.inventory;

import com.bmt.convenient_malum.ConvenientMalumMenus;
import com.bmt.convenient_malum.item.MalumBagItem;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class SoulGuiMenu
extends AbstractContainerMenu
implements Supplier<Map<Integer, Slot>> {
    public static final HashMap<String, Object> guistate = new HashMap();
    public final Level world;
    public final Player entity;
    public int x;
    public int y;
    public int z;
    private IItemHandler internal;
    private final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    private boolean bound = false;

    public SoulGuiMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        this(id, inv, inv.f_35978_);
    }

    public SoulGuiMenu(int id, Inventory inv, Player player) {
        super((MenuType)ConvenientMalumMenus.SOUL_GUI.get(), id);
        int si;
        LazyOptional capability;
        this.entity = player;
        this.world = player.m_9236_();
        this.internal = new ItemStackHandler(9);
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof MalumBagItem && (capability = heldItem.getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
            this.internal = (IItemHandler)capability.resolve().get();
            this.bound = true;
        }
        this.customSlots.put(0, this.m_38897_((Slot)new SlotItemHandler(this.internal, 0, 7, 35){

            public boolean m_5857_(ItemStack stack) {
                return SoulGuiMenu.this.isSpiritItem(stack, "malum:sacred_spirit");
            }
        }));
        this.customSlots.put(1, this.m_38897_((Slot)new SlotItemHandler(this.internal, 1, 25, 35){

            public boolean m_5857_(ItemStack stack) {
                return SoulGuiMenu.this.isSpiritItem(stack, "malum:wicked_spirit");
            }
        }));
        this.customSlots.put(2, this.m_38897_((Slot)new SlotItemHandler(this.internal, 2, 43, 35){

            public boolean m_5857_(ItemStack stack) {
                return SoulGuiMenu.this.isSpiritItem(stack, "malum:arcane_spirit");
            }
        }));
        this.customSlots.put(3, this.m_38897_((Slot)new SlotItemHandler(this.internal, 3, 61, 35){

            public boolean m_5857_(ItemStack stack) {
                return SoulGuiMenu.this.isSpiritItem(stack, "malum:eldritch_spirit");
            }
        }));
        this.customSlots.put(4, this.m_38897_((Slot)new SlotItemHandler(this.internal, 4, 79, 35){

            public boolean m_5857_(ItemStack stack) {
                return SoulGuiMenu.this.isSpiritItem(stack, "malum:earthen_spirit");
            }
        }));
        this.customSlots.put(5, this.m_38897_((Slot)new SlotItemHandler(this.internal, 5, 97, 35){

            public boolean m_5857_(ItemStack stack) {
                return SoulGuiMenu.this.isSpiritItem(stack, "malum:infernal_spirit");
            }
        }));
        this.customSlots.put(6, this.m_38897_((Slot)new SlotItemHandler(this.internal, 6, 115, 35){

            public boolean m_5857_(ItemStack stack) {
                return SoulGuiMenu.this.isSpiritItem(stack, "malum:aerial_spirit");
            }
        }));
        this.customSlots.put(7, this.m_38897_((Slot)new SlotItemHandler(this.internal, 7, 133, 35){

            public boolean m_5857_(ItemStack stack) {
                return SoulGuiMenu.this.isSpiritItem(stack, "malum:aqueous_spirit");
            }
        }));
        this.customSlots.put(8, this.m_38897_((Slot)new SlotItemHandler(this.internal, 8, 151, 35){

            public boolean m_5857_(ItemStack stack) {
                return SoulGuiMenu.this.isSpiritItem(stack, "malum:umbral_spirit");
            }
        }));
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.m_38897_(new Slot((Container)inv, sj + (si + 1) * 9, 8 + sj * 18, 84 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.m_38897_(new Slot((Container)inv, si, 8 + si * 18, 142));
        }
    }

    private boolean isSpiritItem(ItemStack stack, String expectedItemId) {
        ResourceLocation expectedLocation = ResourceLocation.m_135820_((String)expectedItemId);
        ResourceLocation actualLocation = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        return expectedLocation.equals((Object)actualLocation);
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < 9) {
                if (!this.m_38903_(itemstack1, 9, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (!this.m_38903_(itemstack1, 0, 9, false)) {
                if (index < 36 ? !this.m_38903_(itemstack1, 36, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 9, 36, false)) {
                    return ItemStack.f_41583_;
                }
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.m_41753_()) {
            while (!stack.m_41619_() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                ItemStack itemstack;
                Slot slot = (Slot)this.f_38839_.get(i);
                if (slot.m_5857_(itemstack = slot.m_7993_()) && !itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.m_41613_() + stack.m_41613_();
                    if (j <= (maxSize = Math.min(slot.m_6641_(), stack.m_41741_()))) {
                        stack.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_5852_(itemstack);
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        stack.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        slot.m_5852_(itemstack);
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.m_41619_()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot1.m_7993_();
                if (itemstack1.m_41619_() && slot1.m_5857_(stack)) {
                    if (stack.m_41613_() > slot1.m_6641_()) {
                        slot1.m_269060_(stack.m_41620_(slot1.m_6641_()));
                    } else {
                        slot1.m_269060_(stack.m_41620_(stack.m_41613_()));
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void m_6877_(Player playerIn) {
        block4: {
            super.m_6877_(playerIn);
            if (this.bound || !(playerIn instanceof ServerPlayer)) break block4;
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            if (!serverPlayer.m_6084_() || serverPlayer.m_9232_()) {
                for (int j = 0; j < this.internal.getSlots(); ++j) {
                    IItemHandler iItemHandler = this.internal;
                    if (!(iItemHandler instanceof ItemStackHandler)) continue;
                    ItemStackHandler handler = (ItemStackHandler)iItemHandler;
                    playerIn.m_36176_(handler.extractItem(j, handler.getStackInSlot(j).m_41613_(), false), false);
                }
            } else {
                for (int i = 0; i < this.internal.getSlots(); ++i) {
                    IItemHandler iItemHandler = this.internal;
                    if (!(iItemHandler instanceof ItemStackHandler)) continue;
                    ItemStackHandler handler = (ItemStackHandler)iItemHandler;
                    playerIn.m_150109_().m_150079_(handler.extractItem(i, handler.getStackInSlot(i).m_41613_(), false));
                }
            }
        }
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player entity = event.player;
        if (event.phase != TickEvent.Phase.END || entity.f_36096_ instanceof SoulGuiMenu) {
            // empty if block
        }
    }
}

