/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.loot;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.li64.tide.data.loot.DepthLayer;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3518;
import net.minecraft.class_7376;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record TideFishingPredicate(Optional<Boolean> isLavaFishing, Optional<Boolean> usingMagneticBait, Optional<String> depthLayer) implements class_7376
{
    public static TideFishingPredicate isLavaFishing(boolean lavaFishing) {
        return new TideFishingPredicate(Optional.of(lavaFishing), Optional.empty(), Optional.empty());
    }

    public static TideFishingPredicate usingMagneticBait(boolean magneticBait) {
        return new TideFishingPredicate(Optional.empty(), Optional.of(magneticBait), Optional.empty());
    }

    public static TideFishingPredicate depthLayer(DepthLayer layer) {
        return new TideFishingPredicate(Optional.empty(), Optional.empty(), Optional.of(layer.key));
    }

    public boolean method_22497(@NotNull class_1297 entity, @NotNull class_3218 level, @Nullable class_243 position) {
        if (entity instanceof TideFishingHook) {
            Optional<DepthLayer> layer;
            TideFishingHook hook = (TideFishingHook)entity;
            if (this.isLavaFishing.isPresent()) {
                return this.isLavaFishing.get().booleanValue() == hook.isLavaFishing();
            }
            if (this.usingMagneticBait.isPresent()) {
                return this.usingMagneticBait.get().booleanValue() == hook.usingMagneticBait();
            }
            if (this.depthLayer.isPresent() && (layer = DepthLayer.fromKey(this.depthLayer.get())).isPresent()) {
                return layer.get() == DepthLayer.getLayerAt(hook.method_23318());
            }
        }
        return false;
    }

    public static TideFishingPredicate fromJson(JsonObject object) {
        return new TideFishingPredicate(Optional.ofNullable(object.get("is_lava_fishing")).map(element -> class_3518.method_15268((JsonElement)element, (String)"is_lava_fishing")), Optional.ofNullable(object.get("using_magnetic_bait")).map(element -> class_3518.method_15268((JsonElement)element, (String)"using_magnetic_bait")), Optional.ofNullable(object.get("depth_layer")).map(element -> class_3518.method_15287((JsonElement)element, (String)"depth_layer")));
    }

    @NotNull
    public JsonObject method_22494() {
        JsonObject object = new JsonObject();
        if (this.isLavaFishing().isPresent()) {
            object.add("is_lava_fishing", (JsonElement)new JsonPrimitive(this.isLavaFishing().get()));
        }
        if (this.usingMagneticBait().isPresent()) {
            object.add("using_magnetic_bait", (JsonElement)new JsonPrimitive(this.usingMagneticBait().get()));
        }
        if (this.depthLayer().isPresent()) {
            object.add("depth_layer", (JsonElement)new JsonPrimitive(this.depthLayer().get()));
        }
        return object;
    }

    @NotNull
    public JsonElement method_43098() {
        if (this.method_43099() == class_7376.class_7378.field_38724) {
            return JsonNull.INSTANCE;
        }
        JsonObject customData = this.method_22494();
        customData.addProperty("type", "tide_fishing");
        return customData;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_7376.class_7377 method_43099() {
        return TideFishingPredicate::fromJson;
    }
}

