/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.items;

import com.google.common.collect.ImmutableList;
import com.li64.tide.Tide;
import com.li64.tide.client.gui.overlays.CastBarOverlay;
import com.li64.tide.client.gui.overlays.CatchMinigameOverlay;
import com.li64.tide.data.minigame.FishCatchMinigame;
import com.li64.tide.data.rods.AccessoryData;
import com.li64.tide.data.rods.BaitContents;
import com.li64.tide.data.rods.CustomRodManager;
import com.li64.tide.data.rods.FishingRodTooltip;
import com.li64.tide.registries.TideEntityTypes;
import com.li64.tide.registries.TideItems;
import com.li64.tide.registries.entities.misc.fishing.HookAccessor;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import com.li64.tide.util.BaitUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5250;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;

public class TideFishingRodItem
extends class_1787 {
    public static final class_2960 CAST_PROPERTY = Tide.resource("cast");

    public TideFishingRodItem(double baseDurability, class_1792.class_1793 properties) {
        super(properties.method_7895((int)(baseDurability * (Tide.CONFIG == null ? 1.0 : Tide.CONFIG.general.rodDurabilityMultiplier))));
    }

    public boolean isLavaproof(class_1799 stack) {
        return CustomRodManager.getHook(stack).method_31574(TideItems.LAVAPROOF_FISHING_HOOK) || stack.method_31574(TideItems.NETHERITE_FISHING_ROD);
    }

    public static List<class_2561> getDescriptionLines(class_1799 stack) {
        ArrayList<class_5250> builder = new ArrayList<class_5250>();
        class_1799 bobber = CustomRodManager.getBobber(stack);
        class_1799 hook = CustomRodManager.getHook(stack);
        class_1799 line = CustomRodManager.getLine(stack);
        if (CustomRodManager.hasBobber(stack)) {
            class_5250 bobberComponent = AccessoryData.getTranslation(bobber);
            builder.add(bobberComponent.method_27692(class_124.field_1078));
        }
        if (CustomRodManager.hasHook(stack)) {
            class_5250 hookComponent = AccessoryData.getTranslation(hook);
            builder.add(hookComponent.method_27692(class_124.field_1078));
        }
        if (CustomRodManager.hasLine(stack)) {
            class_5250 lineComponent = AccessoryData.getTranslation(line);
            builder.add(lineComponent.method_27692(class_124.field_1078));
        }
        if (!builder.isEmpty()) {
            builder.add(0, class_2561.method_43471((String)"text.tide.rod_tooltip.accessories_prefix").method_27692(class_124.field_1080));
            builder.add(0, class_2561.method_43473());
            builder.add(class_2561.method_43473());
        }
        if (stack.method_31574(TideItems.CRYSTAL_FISHING_ROD)) {
            builder.add(class_2561.method_43471((String)"text.tide.rod_tooltip.crystal_bonus").method_27692(class_124.field_1065));
        }
        if (stack.method_31574(TideItems.GOLDEN_FISHING_ROD)) {
            builder.add(class_2561.method_43471((String)"text.tide.rod_tooltip.gold_bonus").method_27692(class_124.field_1065));
        }
        if (stack.method_31574(TideItems.DIAMOND_FISHING_ROD)) {
            builder.add(class_2561.method_43471((String)"text.tide.rod_tooltip.diamond_bonus").method_27692(class_124.field_1065));
        }
        if (stack.method_31574(TideItems.NETHERITE_FISHING_ROD)) {
            builder.add(class_2561.method_43471((String)"text.tide.rod_tooltip.netherite_bonus").method_27692(class_124.field_1065));
        }
        return ImmutableList.copyOf(builder);
    }

    @NotNull
    public Optional<class_5632> method_32346(@NotNull class_1799 stack) {
        return Optional.of(new FishingRodTooltip(TideFishingRodItem.getContents(stack)));
    }

    public static BaitContents getContents(class_1799 stack) {
        if (!stack.method_7948().method_10545("bait-contents")) {
            TideFishingRodItem.setContents(stack, new BaitContents());
        }
        return BaitContents.fromNbt(stack.method_7948().method_10562("bait-contents"));
    }

    public static void setContents(class_1799 stack, BaitContents contents) {
        stack.method_7948().method_10566("bait-contents", (class_2520)contents.toNbt());
    }

    public boolean method_31565(@NotNull class_1799 stack, @NotNull class_1735 slot, @NotNull class_5536 action, @NotNull class_1657 player) {
        if (action != class_5536.field_27014) {
            return false;
        }
        BaitContents.Mutable contents = new BaitContents.Mutable(TideFishingRodItem.getContents(stack));
        class_1799 slotStack = slot.method_7677();
        if (slotStack.method_7960() && !contents.isEmpty()) {
            class_1799 removedStack = contents.removeStack();
            if (removedStack != null) {
                slot.method_32756(removedStack);
            }
        } else if (slotStack.method_7909().method_31568() && BaitUtils.isBait(slotStack)) {
            contents.tryTransfer(slot, player);
        }
        TideFishingRodItem.setContents(stack, contents.toImmutable());
        return true;
    }

    public boolean method_31566(@NotNull class_1799 stack, @NotNull class_1799 other, @NotNull class_1735 slot, @NotNull class_5536 action, @NotNull class_1657 player, @NotNull class_5630 access) {
        if (action == class_5536.field_27014 && slot.method_32754(player)) {
            BaitContents.Mutable contents = new BaitContents.Mutable(TideFishingRodItem.getContents(stack));
            if (other.method_7960()) {
                class_1799 itemstack = contents.removeStack();
                if (itemstack != null) {
                    access.method_32332(itemstack);
                }
            } else if (other.method_7909().method_31568() && BaitUtils.isBait(other)) {
                contents.tryInsert(other);
            }
            TideFishingRodItem.setContents(stack, contents.toImmutable());
            return true;
        }
        return false;
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, @NotNull class_1657 player, @NotNull class_1268 hand) {
        if (this.isHookActive(player)) {
            TideFishingHook hook = this.getHook(player);
            if (this.isMinigameStopped(player, level.method_8608()) && Tide.CONFIG.minigame.doMinigame) {
                if (Tide.PLATFORM.isModLoaded("stardew_fishing")) {
                    if (hook.getCatchType() == TideFishingHook.CatchType.FISH || hook.getCatchType() == TideFishingHook.CatchType.ITEM) {
                        if (!level.method_8608()) {
                            Tide.LOG.info("Starting stardew fishing minigame");
                            level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15093, class_3419.field_15254, 1.2f, 0.4f / (level.method_8409().method_43057() * 0.4f + 0.8f));
                            if (!Tide.PLATFORM.stardewStart((class_3222)player, (HookAccessor)player.field_7513, player.method_5998(hand), hook.getHookedItems())) {
                                this.retrieveHook(player.method_5998(hand), player, level);
                            }
                        }
                    } else {
                        this.retrieveHook(player.method_5998(hand), player, level);
                    }
                } else if (hook.getCatchType() == TideFishingHook.CatchType.FISH) {
                    if (!level.method_8608() && this.isMinigameStopped(player, level.method_8608())) {
                        Tide.LOG.info("Starting tide fishing minigame");
                        FishCatchMinigame.create(player);
                    }
                } else {
                    if (!level.method_8608() && FishCatchMinigame.delayActive((class_3222)player)) {
                        return class_1271.method_22428((Object)player.method_5998(hand));
                    }
                    this.retrieveHook(player.method_5998(hand), player, level);
                }
            } else if (!Tide.CONFIG.minigame.doMinigame) {
                if (!level.method_8608()) {
                    hook.retrieve();
                }
            } else if (level.method_8608()) {
                CatchMinigameOverlay.interact();
            }
            return class_1271.method_29237((Object)player.method_5998(hand), (boolean)level.method_8608());
        }
        if (!level.method_8608() && FishCatchMinigame.delayActive((class_3222)player)) {
            return class_1271.method_22428((Object)player.method_5998(hand));
        }
        if (Tide.CONFIG.general.holdToCast) {
            level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15093, class_3419.field_15254, 1.5f, 0.3f / (level.method_8409().method_43057() * 0.4f + 0.7f));
            player.method_6019(hand);
            return class_1271.method_22428((Object)player.method_5998(hand));
        }
        this.castHook(player.method_5998(hand), player, level, 1.0f);
        return class_1271.method_29237((Object)player.method_5998(hand), (boolean)level.method_8608());
    }

    private boolean isMinigameStopped(class_1657 player, boolean clientSide) {
        return clientSide ? !CatchMinigameOverlay.isActive() : !FishCatchMinigame.minigameActive(player);
    }

    public void method_7840(@NotNull class_1799 rod, @NotNull class_1937 level, @NotNull class_1309 user, int charge) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            int chargeDifference = this.method_7881(rod) - charge;
            if (chargeDifference > this.getChargeDuration(rod)) {
                chargeDifference = this.getChargeDuration(rod);
            }
            float chargeMultiplier = (float)chargeDifference / (float)this.getChargeDuration(rod) + 0.5f;
            this.castHook(rod, player, level, chargeMultiplier);
        }
    }

    public boolean isHookActive(class_1657 player) {
        TideFishingHook hook = HookAccessor.getHook(player);
        return hook != null;
    }

    public TideFishingHook getHook(class_1657 player) {
        return HookAccessor.getHook(player);
    }

    public void castHook(class_1799 rod, class_1657 player, class_1937 level, float charge) {
        TideFishingHook activeHook = HookAccessor.getHook(player);
        if (activeHook == null) {
            level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14596, class_3419.field_15254, 0.5f, 0.4f / (level.method_8409().method_43057() * 0.4f + 0.8f));
            if (!level.field_9236) {
                int speed = class_1890.method_8215((class_1799)rod);
                int luck = class_1890.method_8223((class_1799)rod);
                if (BaitUtils.isHoldingBait(rod)) {
                    speed += BaitUtils.getBaitSpeed(BaitUtils.getPrimaryBait(rod));
                    luck += BaitUtils.getBaitLuck(BaitUtils.getPrimaryBait(rod));
                }
                if (rod.method_31574(TideItems.GOLDEN_FISHING_ROD)) {
                    ++luck;
                }
                if (Tide.PLATFORM.isModLoaded("hybrid-aquatic")) {
                    if (CustomRodManager.getHook(rod).method_7909().toString().matches("barbed_hook") && level.method_8530()) {
                        ++speed;
                    }
                    if (CustomRodManager.getHook(rod).method_7909().toString().matches("glowing_hook") && level.method_23886()) {
                        ++speed;
                    }
                    if (CustomRodManager.getHook(rod).method_7909().toString().matches("magnetic_hook")) {
                        ++luck;
                    }
                }
                level.method_8649((class_1297)new TideFishingHook(TideEntityTypes.FISHING_BOBBER, player, level, luck, speed, charge, rod));
            }
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
            player.method_32876(class_5712.field_28145);
        }
    }

    public void retrieveHook(class_1799 rod, class_1657 player, class_1937 level) {
        TideFishingHook activeHook = HookAccessor.getHook(player);
        if (activeHook != null) {
            if (!level.field_9236) {
                int durabilityLoss = activeHook.retrieve(rod, (class_3218)level, player);
                rod.method_7956(durabilityLoss, (class_1309)player, playerTemp -> playerTemp.method_20236(player.method_6058()));
            }
            level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15093, class_3419.field_15254, 1.2f, 0.4f / (level.method_8409().method_43057() * 0.4f + 0.8f));
            player.method_32876(class_5712.field_28146);
        }
    }

    public void method_7852(@NotNull class_1937 level, @NotNull class_1309 user, @NotNull class_1799 rod, int charge) {
        super.method_7852(level, user, rod, charge);
        if (level.method_8608() && user == class_310.method_1551().field_1724) {
            int chargeDifference = this.method_7881(rod) - charge;
            if (chargeDifference > this.getChargeDuration(rod)) {
                chargeDifference = this.getChargeDuration(rod);
            }
            CastBarOverlay.rodChargeTick((float)chargeDifference / (float)this.getChargeDuration(rod));
        }
    }

    public int method_7881(@NotNull class_1799 stack) {
        return 60000;
    }

    public int getChargeDuration(class_1799 rod) {
        return CustomRodManager.getLine(rod).method_31574(TideItems.BRAIDED_LINE) ? 15 : 25;
    }

    @NotNull
    public class_1839 method_7853(@NotNull class_1799 stack) {
        return class_1839.field_8953;
    }
}

