/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide;

import com.li64.tide.Tide;
import com.li64.tide.TideForgeNetworking;
import com.li64.tide.client.gui.TideMenuTypes;
import com.li64.tide.compat.jei.TideRecipeSerializers;
import com.li64.tide.config.TideConfig;
import com.li64.tide.data.TideCriteriaTriggers;
import com.li64.tide.loot.TideLootModifiers;
import com.li64.tide.registries.TideBlockEntities;
import com.li64.tide.registries.TideBlocks;
import com.li64.tide.registries.TideEntityTypes;
import com.li64.tide.registries.TideFeatures;
import com.li64.tide.registries.TideItems;
import com.li64.tide.registries.TideLootConditions;
import com.li64.tide.registries.TideSoundEvents;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="tide")
public class TideForge {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"tide");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"tide");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"tide");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"tide");
    public static final DeferredRegister<LootItemConditionType> LOOT_CONDITION_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256976_, (String)"tide");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"tide");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"tide");
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"tide");

    public TideForge() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::onRegister);
        TideForgeNetworking.init();
        Tide.init();
        BLOCKS.register(eventBus);
        BLOCK_ENTITIES.register(eventBus);
        ITEMS.register(eventBus);
        ENTITY_TYPES.register(eventBus);
        LOOT_CONDITION_TYPES.register(eventBus);
        MENU_TYPES.register(eventBus);
        SOUND_EVENTS.register(eventBus);
        FEATURES.register(eventBus);
        TideLootModifiers.register(eventBus);
        TideRecipeSerializers.register(eventBus);
        TideCriteriaTriggers.init();
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> (Screen)AutoConfig.getConfigScreen(TideConfig.class, (Screen)screen).get()));
    }

    @SubscribeEvent
    public void onRegister(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.ITEMS, helper -> TideItems.init());
        event.register(ForgeRegistries.Keys.BLOCKS, helper -> TideBlocks.init());
        event.register(ForgeRegistries.Keys.BLOCK_ENTITY_TYPES, helper -> TideBlockEntities.init());
        event.register(ForgeRegistries.Keys.ENTITY_TYPES, helper -> TideEntityTypes.init());
        event.register(ForgeRegistries.Keys.MENU_TYPES, helper -> TideMenuTypes.init());
        event.register(ForgeRegistries.Keys.SOUND_EVENTS, helper -> TideSoundEvents.init());
        event.register(Registries.f_256976_, helper -> TideLootConditions.init());
        event.register(ForgeRegistries.Keys.FEATURES, helper -> TideFeatures.init());
        event.register(Registries.f_279569_, helper -> Registry.m_122961_((Registry)BuiltInRegistries.f_279662_, (String)"tide", (Object)Tide.getCreativeTab(CreativeModeTab.builder()).m_257652_()));
    }
}

