/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.rods;

import com.google.common.collect.ImmutableList;
import com.li64.tide.data.rods.ModifierType;
import com.li64.tide.registries.TideItems;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class CustomRodManager {
    private static final ItemStack DEFAULT_BOBBER = TideItems.RED_FISHING_BOBBER.m_7968_();
    private static final ItemStack DEFAULT_HOOK = TideItems.FISHING_HOOK.m_7968_();
    private static final ItemStack DEFAULT_LINE = TideItems.FISHING_LINE.m_7968_();

    private static void createModifierTag(ItemStack stack) {
        CompoundTag modifierTag = new CompoundTag();
        modifierTag.m_128365_("bobber", (Tag)new CompoundTag());
        modifierTag.m_128365_("hook", (Tag)new CompoundTag());
        modifierTag.m_128365_("line", (Tag)new CompoundTag());
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41784_().m_128365_("modifier", (Tag)modifierTag);
    }

    private static void updateModifiers(ItemStack stack) {
        if (!CustomRodManager.hasModifierTag(stack)) {
            CustomRodManager.createModifierTag(stack);
        }
    }

    public static void setBobber(ItemStack stack, ItemStack bobber) {
        CustomRodManager.setModifier(stack, ModifierType.BOBBER, bobber);
    }

    public static void setHook(ItemStack stack, ItemStack hook) {
        CustomRodManager.setModifier(stack, ModifierType.HOOK, hook);
    }

    public static void setLine(ItemStack stack, ItemStack line) {
        CustomRodManager.setModifier(stack, ModifierType.LINE, line);
    }

    public static void setModifier(ItemStack stack, ModifierType modifier, ItemStack accessory) {
        CustomRodManager.updateModifiers(stack);
        if (accessory == null) {
            CustomRodManager.getModifierTag(stack).m_128365_(modifier.getID(), (Tag)new CompoundTag());
            return;
        }
        CompoundTag tag = accessory.m_41739_(new CompoundTag());
        CustomRodManager.getModifierTag(stack).m_128365_(modifier.getID(), (Tag)tag);
    }

    public static boolean hasModifierTag(ItemStack stack) {
        return stack.m_41782_() && stack.m_41784_().m_128441_("modifier");
    }

    public static CompoundTag getModifierTag(ItemStack stack) {
        CustomRodManager.updateModifiers(stack);
        return (CompoundTag)stack.m_41784_().m_128423_("modifier");
    }

    public static ItemStack getBobber(ItemStack rod) {
        return CustomRodManager.getAccessory(rod, ModifierType.BOBBER, DEFAULT_BOBBER);
    }

    public static ItemStack getHook(ItemStack rod) {
        return CustomRodManager.getAccessory(rod, ModifierType.HOOK, DEFAULT_HOOK);
    }

    public static ItemStack getLine(ItemStack rod) {
        return CustomRodManager.getAccessory(rod, ModifierType.LINE, DEFAULT_LINE);
    }

    public static boolean hasBobber(ItemStack rod) {
        return CustomRodManager.getAccessory(rod, ModifierType.BOBBER) != null;
    }

    public static boolean hasHook(ItemStack rod) {
        return CustomRodManager.getAccessory(rod, ModifierType.HOOK) != null;
    }

    public static boolean hasLine(ItemStack rod) {
        return CustomRodManager.getAccessory(rod, ModifierType.LINE) != null;
    }

    private static ItemStack getAccessory(ItemStack rod, ModifierType type) {
        return CustomRodManager.getAccessory(rod, type, null);
    }

    private static ItemStack getAccessory(ItemStack rod, ModifierType type, ItemStack defaultInstance) {
        CustomRodManager.updateModifiers(rod);
        CompoundTag accessoryTag = CustomRodManager.getModifierTag(rod).m_128469_(type.getID());
        if (accessoryTag.m_128456_()) {
            return defaultInstance;
        }
        ItemStack accessory = ItemStack.m_41712_((CompoundTag)accessoryTag);
        return accessory.m_41619_() ? defaultInstance : accessory;
    }

    public static List<ItemStack> getAccessoryList(ItemStack stack) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (CustomRodManager.hasBobber(stack)) {
            builder.add((Object)CustomRodManager.getBobber(stack));
        }
        if (CustomRodManager.hasHook(stack)) {
            builder.add((Object)CustomRodManager.getHook(stack));
        }
        if (CustomRodManager.hasLine(stack)) {
            builder.add((Object)CustomRodManager.getLine(stack));
        }
        return builder.build();
    }
}

