/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.network.messages;

import com.li64.tide.Tide;
import com.li64.tide.data.player.TidePlayerData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SyncDataMsg {
    public static final ResourceLocation ID = Tide.resource("sync_data");
    public final int[] pagesUnlocked;
    public final int[] fishUnlocked;
    public final int[] unreadProfiles;
    public final int[] pagesCompleted;
    public final boolean gotJournal;
    public final boolean finishedJournal;

    public SyncDataMsg(TidePlayerData data) {
        this.pagesUnlocked = data.pagesIntArray();
        this.fishUnlocked = data.fishIntArray();
        this.unreadProfiles = data.unreadIntArray();
        this.pagesCompleted = data.pagesCompletedIntArray();
        this.gotJournal = data.gotJournal;
        this.finishedJournal = data.finishedJournal;
    }

    public SyncDataMsg(FriendlyByteBuf buf) {
        this.pagesUnlocked = buf.m_130100_();
        this.fishUnlocked = buf.m_130100_();
        this.unreadProfiles = buf.m_130100_();
        this.pagesCompleted = buf.m_130100_();
        this.gotJournal = buf.readBoolean();
        this.finishedJournal = buf.readBoolean();
    }

    public static void encode(SyncDataMsg message, FriendlyByteBuf buf) {
        buf.m_130089_(message.pagesUnlocked);
        buf.m_130089_(message.fishUnlocked);
        buf.m_130089_(message.unreadProfiles);
        buf.m_130089_(message.pagesCompleted);
        buf.writeBoolean(message.gotJournal);
        buf.writeBoolean(message.finishedJournal);
    }

    public static void handle(SyncDataMsg message, Player player) {
        TidePlayerData.CLIENT_DATA.pagesUnlocked = TidePlayerData.fromIntArray(message.pagesUnlocked);
        TidePlayerData.CLIENT_DATA.fishUnlocked = TidePlayerData.fromIntArray(message.fishUnlocked);
        TidePlayerData.CLIENT_DATA.unreadProfiles = TidePlayerData.fromIntArray(message.unreadProfiles);
        TidePlayerData.CLIENT_DATA.pagesCompleted = TidePlayerData.fromIntArray(message.pagesCompleted);
        TidePlayerData.CLIENT_DATA.gotJournal = message.gotJournal;
        TidePlayerData.CLIENT_DATA.finishedJournal = message.finishedJournal;
    }
}

