/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries;

import com.li64.tide.registries.entities.misc.fishing.TideFishingBobberLayer;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHookModel;
import com.li64.tide.registries.entities.models.AngelfishModel;
import com.li64.tide.registries.entities.models.BarracudaModel;
import com.li64.tide.registries.entities.models.CatfishModel;
import com.li64.tide.registries.entities.models.GuppyModel;
import com.li64.tide.registries.entities.models.SailfishModel;
import com.li64.tide.registries.entities.models.SimpleFishModel;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;

public class TideLayerDefinitions {
    public static final ArrayList<Registration> REGISTRY = new ArrayList();

    public static void init() {
        TideLayerDefinitions.registerLayerDefinition(TideFishingHookModel.LAYER_LOCATION, TideFishingHookModel::createBodyLayer);
        TideLayerDefinitions.registerLayerDefinition(TideFishingBobberLayer.LAYER_LOCATION, TideFishingHookModel::createBodyLayer);
        TideLayerDefinitions.registerSimpleFishVariant(SimpleFishModel.Variant.NOSE_NORMAL);
        TideLayerDefinitions.registerSimpleFishVariant(SimpleFishModel.Variant.NOSE_UPPER);
        TideLayerDefinitions.registerSimpleFishVariant(SimpleFishModel.Variant.NOSE_LOWER);
        TideLayerDefinitions.registerSimpleFishVariant(SimpleFishModel.Variant.NOSE_FULL);
        TideLayerDefinitions.registerLayerDefinition(GuppyModel.LAYER_LOCATION, GuppyModel::createBodyLayer);
        TideLayerDefinitions.registerLayerDefinition(CatfishModel.LAYER_LOCATION, CatfishModel::createBodyLayer);
        TideLayerDefinitions.registerLayerDefinition(AngelfishModel.LAYER_LOCATION, AngelfishModel::createBodyLayer);
        TideLayerDefinitions.registerLayerDefinition(BarracudaModel.LAYER_LOCATION, BarracudaModel::createBodyLayer);
        TideLayerDefinitions.registerLayerDefinition(SailfishModel.LAYER_LOCATION, SailfishModel::createBodyLayer);
    }

    private static void registerSimpleFishVariant(SimpleFishModel.Variant variant) {
        TideLayerDefinitions.registerLayerDefinition(variant.modelLocation(), () -> SimpleFishModel.createBodyLayer(variant));
    }

    public static void registerLayerDefinition(ModelLayerLocation location, Supplier<LayerDefinition> layerDefinition) {
        REGISTRY.add(new Registration(location, layerDefinition));
    }

    public record Registration(ModelLayerLocation location, Supplier<LayerDefinition> layerDefinition) {
    }
}

