/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.misc.fishing;

import com.li64.tide.Tide;
import com.li64.tide.data.TideCriteriaTriggers;
import com.li64.tide.data.TideLootTables;
import com.li64.tide.data.TideTags;
import com.li64.tide.data.rods.BaitContents;
import com.li64.tide.data.rods.CustomRodManager;
import com.li64.tide.registries.TideBlocks;
import com.li64.tide.registries.TideItems;
import com.li64.tide.registries.entities.misc.LootCrateEntity;
import com.li64.tide.registries.entities.misc.fishing.HookAccessor;
import com.li64.tide.registries.items.TideFishingRodItem;
import com.li64.tide.util.BaitUtils;
import com.li64.tide.util.TideUtils;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class TideFishingHook
extends Projectile {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final RandomSource synchronizedRandom = RandomSource.m_216327_();
    private boolean biting;
    private int outOfWaterTime;
    private static final EntityDataAccessor<Integer> DATA_HOOKED_ENTITY = SynchedEntityData.m_135353_(TideFishingHook.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_BITING = SynchedEntityData.m_135353_(TideFishingHook.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ItemStack> DATA_ROD_ITEM = SynchedEntityData.m_135353_(TideFishingHook.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Integer> DATA_CATCH_TYPE = SynchedEntityData.m_135353_(TideFishingHook.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_MINIGAME_ACTIVE = SynchedEntityData.m_135353_(TideFishingHook.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DATA_INITIAL_YAW = SynchedEntityData.m_135353_(TideFishingHook.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int life;
    private int nibble;
    private int timeUntilLured;
    private int timeUntilHooked;
    private float fishAngle;
    private boolean openWater = true;
    private Entity hookedIn;
    private FishHookState currentState = FishHookState.FLYING;
    private FluidState fluid;
    private FluidState lastTouchedFluid;
    private final int luck;
    private final int lureSpeed;
    private boolean minigameActive = false;
    protected ItemStack rod;
    protected List<ItemStack> hookedItems;
    protected CatchType catchType = CatchType.NOTHING;
    private int particleTimer = 0;

    private TideFishingHook(EntityType<? extends TideFishingHook> entityType, Level level, int luck, int lureSpeed, ItemStack rod) {
        super(entityType, level);
        this.f_19811_ = true;
        this.rod = rod;
        this.f_19804_.m_135381_(DATA_ROD_ITEM, (Object)rod);
        this.luck = Math.max(0, luck + (this.getLine().m_150930_(TideItems.FORTUNE_LINE) ? 1 : 0));
        this.lureSpeed = Math.max(0, lureSpeed);
    }

    public TideFishingHook(EntityType<? extends TideFishingHook> entityType, Level level) {
        this(entityType, level, 0, 0, Items.f_42523_.m_7968_());
    }

    public TideFishingHook(EntityType<? extends TideFishingHook> hookType, Player player, Level level, int luck, int lureSpeed, float charge, ItemStack rod) {
        this(hookType, level, luck, lureSpeed, rod);
        this.m_5602_((Entity)player);
        float f = player.m_146909_();
        float f1 = player.m_146908_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        double d0 = player.m_20185_() - (double)f3 * 0.3;
        double d1 = player.m_20188_();
        double d2 = player.m_20189_() - (double)f2 * 0.3;
        this.m_7678_(d0, d1, d2, f1, f);
        Vec3 vec3 = new Vec3((double)(-f3), (double)Mth.m_14036_((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = vec3.m_82553_();
        vec3 = vec3.m_82542_((double)charge, (double)charge, (double)charge);
        vec3 = vec3.m_82542_(0.6 / d3 + this.f_19796_.m_216328_(0.5, 0.0103365), 0.6 / d3 + this.f_19796_.m_216328_(0.5, 0.0103365), 0.6 / d3 + this.f_19796_.m_216328_(0.5, 0.0103365));
        this.m_20256_(vec3);
        this.m_146922_(f1);
        this.m_146926_(0.0f);
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        this.f_19804_.m_135381_(DATA_INITIAL_YAW, (Object)Float.valueOf(f1));
        this.f_19804_.m_135381_(DATA_ROD_ITEM, (Object)rod);
    }

    public void invalidateCatch() {
        this.hookedItems = null;
        this.catchType = CatchType.NOTHING;
        this.m_20088_().m_135381_(DATA_CATCH_TYPE, (Object)this.catchType.ordinal());
    }

    public int getLureSpeed() {
        return this.lureSpeed;
    }

    public int getLuck() {
        return this.luck;
    }

    public float getInitialYaw() {
        return ((Float)this.f_19804_.m_135370_(DATA_INITIAL_YAW)).floatValue();
    }

    public Holder<Biome> getBiome() {
        return this.m_9236_().m_204166_(this.m_20183_());
    }

    public boolean isOpenWaterFishing() {
        return this.openWater;
    }

    public boolean usingMagneticBait() {
        return BaitUtils.getPrimaryBait(this.rod).m_150930_(TideItems.MAGNETIC_BAIT);
    }

    public void clearHookItem() {
        ItemStack mainHandItem = this.getPlayerOwner().m_21205_();
        ItemStack offhandItem = this.getPlayerOwner().m_21206_();
        if (mainHandItem.m_41720_() instanceof TideFishingRodItem) {
            CustomRodManager.setHook(mainHandItem, null);
            this.getPlayerOwner().m_21008_(InteractionHand.MAIN_HAND, mainHandItem);
        } else if (offhandItem.m_41720_() instanceof TideFishingRodItem) {
            CustomRodManager.setHook(offhandItem, null);
            this.getPlayerOwner().m_21008_(InteractionHand.OFF_HAND, offhandItem);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_HOOKED_ENTITY, (Object)0);
        this.f_19804_.m_135372_(DATA_BITING, (Object)false);
        this.f_19804_.m_135372_(DATA_ROD_ITEM, (Object)Items.f_42523_.m_7968_());
        this.f_19804_.m_135372_(DATA_CATCH_TYPE, (Object)CatchType.NOTHING.ordinal());
        this.f_19804_.m_135372_(DATA_MINIGAME_ACTIVE, (Object)false);
        this.f_19804_.m_135372_(DATA_INITIAL_YAW, (Object)Float.valueOf(0.0f));
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> data) {
        if (DATA_HOOKED_ENTITY.equals(data)) {
            int i = (Integer)this.m_20088_().m_135370_(DATA_HOOKED_ENTITY);
            Entity entity = this.hookedIn = i > 0 ? this.m_9236_().m_6815_(i - 1) : null;
        }
        if (DATA_BITING.equals(data)) {
            this.biting = (Boolean)this.m_20088_().m_135370_(DATA_BITING);
            if (this.biting) {
                this.m_20334_(this.m_20184_().f_82479_, -0.4f * Mth.m_216267_((RandomSource)this.synchronizedRandom, (float)0.6f, (float)1.0f), this.m_20184_().f_82481_);
            }
        }
        if (DATA_ROD_ITEM.equals(data)) {
            this.rod = (ItemStack)this.m_20088_().m_135370_(DATA_ROD_ITEM);
        }
        if (DATA_CATCH_TYPE.equals(data) && this.m_9236_().m_5776_()) {
            this.catchType = CatchType.values()[(Integer)this.m_20088_().m_135370_(DATA_CATCH_TYPE)];
        }
        if (DATA_MINIGAME_ACTIVE.equals(data)) {
            this.minigameActive = (Boolean)this.m_20088_().m_135370_(DATA_MINIGAME_ACTIVE);
            if (!this.m_9236_().m_5776_() && !this.minigameActive) {
                this.restartFishingSequence();
            }
        }
        super.m_7350_(data);
    }

    public boolean m_6783_(double dst) {
        return dst < 4096.0;
    }

    public void m_8119_() {
        Player player;
        if (this.getRodItem() == null) {
            this.m_146870_();
        }
        this.synchronizedRandom.m_188584_(this.m_20148_().getLeastSignificantBits() ^ this.m_9236_().m_46467_());
        super.m_8119_();
        if (BaitUtils.getPrimaryBait(this.rod).m_150930_(TideItems.LUCKY_BAIT) && this.currentState == FishHookState.BOBBING) {
            ++this.particleTimer;
            if (this.particleTimer >= 5) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175828_, this.m_20208_(0.8), this.m_20227_((2.0 * this.f_19796_.m_188500_() - 1.0) * 0.4) + 0.2, this.m_20262_(0.8), 0.0, 0.0, 0.0);
                this.particleTimer = 0;
            }
        }
        if ((player = this.getPlayerOwner()) == null) {
            this.m_146870_();
        } else if (this.m_9236_().f_46443_ || this.shouldKeepFishing(player)) {
            boolean flag;
            FluidState fluidstate;
            if (this.m_20096_()) {
                ++this.life;
                if (this.life >= 1200) {
                    this.m_146870_();
                    return;
                }
            } else {
                this.life = 0;
            }
            float f = 0.0f;
            BlockPos blockpos = this.m_20183_();
            this.fluid = fluidstate = this.m_9236_().m_6425_(blockpos);
            if (this.canFishIn(fluidstate)) {
                f = fluidstate.m_76155_((BlockGetter)this.m_9236_(), blockpos);
            }
            boolean bl = flag = f > 0.0f;
            if (this.currentState == FishHookState.FLYING) {
                if (this.hookedIn != null) {
                    this.m_20256_(Vec3.f_82478_);
                    this.currentState = FishHookState.HOOKED_IN_ENTITY;
                    return;
                }
                if (flag) {
                    this.m_20256_(this.m_20184_().m_82542_(0.3, 0.2, 0.3));
                    this.currentState = FishHookState.BOBBING;
                    return;
                }
                this.checkCollision();
            } else {
                if (this.currentState == FishHookState.HOOKED_IN_ENTITY) {
                    if (this.hookedIn != null) {
                        if (!this.hookedIn.m_213877_() && this.hookedIn.m_9236_().m_46472_() == this.m_9236_().m_46472_()) {
                            this.m_6034_(this.hookedIn.m_20185_(), this.hookedIn.m_20227_(0.8), this.hookedIn.m_20189_());
                        } else {
                            this.setHookedEntity(null);
                            this.currentState = FishHookState.FLYING;
                        }
                    }
                    return;
                }
                if (this.currentState == FishHookState.BOBBING) {
                    Vec3 vec3 = this.m_20184_();
                    double d0 = this.m_20186_() + vec3.f_82480_ - (double)blockpos.m_123342_() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.m_20334_(vec3.f_82479_ * 0.9, vec3.f_82480_ - d0 * (double)this.f_19796_.m_188501_() * 0.2, vec3.f_82481_ * 0.9);
                    if (this.nibble <= 0 && this.timeUntilHooked <= 0) {
                        this.openWater = true;
                    } else {
                        boolean bl2 = this.openWater = this.openWater && this.outOfWaterTime < 10 && this.calculateOpenWater(blockpos);
                    }
                    if (flag) {
                        this.outOfWaterTime = Math.max(0, this.outOfWaterTime - 1);
                        if (this.biting) {
                            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.1 * (double)this.synchronizedRandom.m_188501_() * (double)this.synchronizedRandom.m_188501_(), 0.0));
                        }
                        if (!this.m_9236_().f_46443_) {
                            this.catchingFish(blockpos);
                        }
                    } else {
                        this.outOfWaterTime = Math.min(10, this.outOfWaterTime + 1);
                    }
                }
            }
            if (!this.canFishIn(fluidstate)) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (this.currentState == FishHookState.FLYING && (this.m_20096_() || this.f_19862_)) {
                this.m_20256_(Vec3.f_82478_);
            }
            double d1 = 0.92;
            this.m_20256_(this.m_20184_().m_82490_(d1));
            this.m_20090_();
        }
        if (this.fluid != null && !this.fluid.m_76178_()) {
            this.lastTouchedFluid = this.fluid;
        }
    }

    private boolean shouldKeepFishing(Player player) {
        boolean flag = player.m_21205_().equals(this.rod);
        boolean flag1 = player.m_21206_().equals(this.rod);
        if (!player.m_213877_() && player.m_6084_() && (flag || flag1) && !(this.m_20280_((Entity)player) > 1224.0)) {
            return true;
        }
        this.m_146870_();
        return false;
    }

    private void checkCollision() {
        HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
        this.m_6532_(hitresult);
    }

    protected boolean m_5603_(@NotNull Entity entity) {
        return super.m_5603_(entity) || entity.m_6084_() && entity instanceof ItemEntity;
    }

    protected void m_5790_(@NotNull EntityHitResult result) {
        super.m_5790_(result);
        if (!this.m_9236_().f_46443_) {
            if (result.m_82443_() == this.m_19749_()) {
                this.m_146870_();
            }
            this.setHookedEntity(result.m_82443_());
        }
    }

    protected void m_8060_(@NotNull BlockHitResult result) {
        super.m_8060_(result);
        this.m_20256_(this.m_20184_().m_82541_().m_82490_(result.m_82448_((Entity)this)));
    }

    private void setHookedEntity(Entity p_150158_) {
        this.hookedIn = p_150158_;
        this.m_20088_().m_135381_(DATA_HOOKED_ENTITY, (Object)(p_150158_ == null ? 0 : p_150158_.m_19879_() + 1));
    }

    private void catchingFish(BlockPos pos) {
        Optional<ArrayList<ItemStack>> rewards;
        if (Tide.PLATFORM.isModLoaded("stardew_fishing") && (rewards = Tide.PLATFORM.stardewGetRewards((HookAccessor)this.getPlayerOwner().f_36083_)).isPresent() && !rewards.get().isEmpty()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.m_9236_();
        int i = 1;
        BlockPos abovePos = pos.m_7494_();
        if (this.f_19796_.m_188501_() < 0.25f && this.m_9236_().m_46758_(abovePos)) {
            ++i;
        }
        if (this.f_19796_.m_188501_() < 0.5f && !this.m_9236_().m_45527_(abovePos)) {
            --i;
        }
        if (this.nibble > 0) {
            if (!this.minigameActive) {
                --this.nibble;
            }
            if (this.nibble <= 0) {
                this.restartFishingSequence();
            }
        } else if (this.timeUntilHooked > 0) {
            this.timeUntilHooked -= i;
            if (this.timeUntilHooked > 0) {
                double d2;
                double d1;
                this.fishAngle += (float)this.f_19796_.m_216328_(0.0, 9.188);
                float f = this.fishAngle * ((float)Math.PI / 180);
                float f1 = Mth.m_14031_((float)f);
                float f2 = Mth.m_14089_((float)f);
                double d0 = this.m_20185_() + (double)(f1 * (float)this.timeUntilHooked * 0.1f);
                BlockState blockstate = level.m_8055_(BlockPos.m_274561_((double)d0, (double)((d1 = (double)((float)Mth.m_14107_((double)this.m_20186_()) + 1.0f)) - 1.0), (double)(d2 = this.m_20189_() + (double)(f2 * (float)this.timeUntilHooked * 0.1f))));
                if (blockstate.m_60713_(Blocks.f_49990_)) {
                    this.lastTouchedFluid = this.fluid = Fluids.f_76193_.m_76145_();
                    if (this.f_19796_.m_188501_() < 0.15f) {
                        level.m_8767_((ParticleOptions)ParticleTypes.f_123795_, d0, d1 - 0.1, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123816_, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123816_, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                } else if (blockstate.m_60713_(Blocks.f_49991_)) {
                    this.lastTouchedFluid = this.fluid = Fluids.f_76195_.m_76145_();
                    if (this.f_19796_.m_188501_() < 0.15f) {
                        level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123756_, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0, 0.0, 0.01, 0.0, 1.0);
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123756_, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                if (this.rod.m_150930_(TideItems.CRYSTAL_FISHING_ROD)) {
                    this.m_9236_().m_5594_(null, this.getPlayerOwner().m_20183_(), SoundEvents.f_276532_, SoundSource.MASTER, 1.5f, 1.0f - (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f);
                }
                if (this.isLavaFishing()) {
                    this.m_5496_(SoundEvents.f_11780_, 0.25f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
                    if (Tide.PLATFORM.isModLoaded("stardew_fishing")) {
                        this.m_5496_(SoundEvents.f_11940_, 0.25f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
                    }
                    double d3 = this.m_20186_() + 0.5;
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_(), d3, this.m_20189_(), (int)(1.0f + this.m_20205_() * 20.0f), (double)this.m_20205_(), 0.0, (double)this.m_20205_(), 0.2);
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), d3, this.m_20189_(), (int)(1.0f + this.m_20205_() * 20.0f), (double)this.m_20205_(), 0.0, (double)this.m_20205_(), 0.2);
                } else {
                    this.m_5496_(SoundEvents.f_11940_, 0.25f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
                    double d3 = this.m_20186_() + 0.5;
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_(), d3, this.m_20189_(), (int)(1.0f + this.m_20205_() * 20.0f), (double)this.m_20205_(), 0.0, (double)this.m_20205_(), 0.2);
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123816_, this.m_20185_(), d3, this.m_20189_(), (int)(1.0f + this.m_20205_() * 20.0f), (double)this.m_20205_(), 0.0, (double)this.m_20205_(), 0.2);
                }
                this.nibble = Mth.m_216271_((RandomSource)this.f_19796_, (int)20, (int)40);
                this.m_20088_().m_135381_(DATA_BITING, (Object)true);
                if (this.getPlayerOwner() != null) {
                    this.selectCatch(this.getPlayerOwner(), this.rod);
                } else {
                    this.catchType = CatchType.NOTHING;
                    this.m_20088_().m_135381_(DATA_CATCH_TYPE, (Object)this.catchType.ordinal());
                }
            }
        } else if (this.timeUntilLured > 0) {
            this.timeUntilLured -= i;
            float f5 = 0.15f;
            if (this.timeUntilLured < 20) {
                f5 += (float)(20 - this.timeUntilLured) * 0.05f;
            } else if (this.timeUntilLured < 40) {
                f5 += (float)(40 - this.timeUntilLured) * 0.02f;
            } else if (this.timeUntilLured < 60) {
                f5 += (float)(60 - this.timeUntilLured) * 0.01f;
            }
            if (this.f_19796_.m_188501_() < f5) {
                double d6;
                double d5;
                float f6 = Mth.m_216267_((RandomSource)this.f_19796_, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = Mth.m_216267_((RandomSource)this.f_19796_, (float)25.0f, (float)60.0f);
                double d4 = this.m_20185_() + (double)(Mth.m_14031_((float)f6) * f7) * 0.1;
                BlockState blockstate1 = level.m_8055_(BlockPos.m_274561_((double)d4, (double)((d5 = (double)((float)Mth.m_14107_((double)this.m_20186_()) + 1.0f)) - 1.0), (double)(d6 = this.m_20189_() + (double)(Mth.m_14089_((float)f6) * f7) * 0.1)));
                if (blockstate1.m_60713_(Blocks.f_49990_)) {
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123769_, d4, d5, d6, 2 + this.f_19796_.m_188503_(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                } else if (blockstate1.m_60713_(Blocks.f_49991_)) {
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123756_, d4, d5, d6, 2 + this.f_19796_.m_188503_(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.timeUntilLured <= 0) {
                this.fishAngle = Mth.m_216267_((RandomSource)this.f_19796_, (float)0.0f, (float)360.0f);
                this.timeUntilHooked = Mth.m_216271_((RandomSource)this.f_19796_, (int)20, (int)80);
            }
        } else {
            this.timeUntilLured = Mth.m_216271_((RandomSource)this.f_19796_, (int)200, (int)600);
            this.timeUntilLured -= (int)(1200.0 / (1.0 + Math.exp(-0.3 * (double)this.lureSpeed)) - 600.0);
            if (this.getHook().m_41720_().toString().matches("barbed_hook") && this.m_9236_().m_46461_()) {
                this.timeUntilLured -= 75;
            } else if (this.getHook().m_41720_().toString().matches("glowing_hook") && this.m_9236_().m_46462_()) {
                this.timeUntilLured -= 75;
            }
            this.timeUntilLured = Math.max((int)((double)this.timeUntilLured * Tide.PLATFORM.getBiteTimeMultiplier()), 10);
        }
    }

    public void restartFishingSequence() {
        this.catchType = CatchType.NOTHING;
        this.m_20088_().m_135381_(DATA_CATCH_TYPE, (Object)this.catchType.ordinal());
        this.timeUntilLured = 0;
        this.timeUntilHooked = 0;
        this.m_20088_().m_135381_(DATA_BITING, (Object)false);
    }

    private boolean calculateOpenWater(BlockPos p_37159_) {
        OpenFluidType openWaterType = OpenFluidType.INVALID;
        for (int i = -1; i <= 2; ++i) {
            OpenFluidType openWaterType1 = this.getOpenWaterTypeForArea(p_37159_.m_7918_(-2, i, -2), p_37159_.m_7918_(2, i, 2));
            switch (openWaterType1) {
                case INVALID: {
                    return false;
                }
                case ABOVE_WATER: {
                    if (openWaterType != OpenFluidType.INVALID) break;
                    return false;
                }
                case INSIDE_WATER: {
                    if (openWaterType != OpenFluidType.ABOVE_WATER) break;
                    return false;
                }
            }
            openWaterType = openWaterType1;
        }
        return true;
    }

    private OpenFluidType getOpenWaterTypeForArea(BlockPos p_37148_, BlockPos p_37149_) {
        return BlockPos.m_121990_((BlockPos)p_37148_, (BlockPos)p_37149_).map(this::getOpenWaterTypeForBlock).reduce((p_37139_, p_37140_) -> p_37139_ == p_37140_ ? p_37139_ : OpenFluidType.INVALID).orElse(OpenFluidType.INVALID);
    }

    private OpenFluidType getOpenWaterTypeForBlock(BlockPos p_37164_) {
        BlockState blockstate = this.m_9236_().m_8055_(p_37164_);
        if (!blockstate.m_60795_() && !blockstate.m_60713_(Blocks.f_50196_)) {
            FluidState fluidstate = blockstate.m_60819_();
            return this.canFishIn(fluidstate) && fluidstate.m_76170_() && blockstate.m_60812_((BlockGetter)this.m_9236_(), p_37164_).m_83281_() ? OpenFluidType.INSIDE_WATER : OpenFluidType.INVALID;
        }
        return OpenFluidType.ABOVE_WATER;
    }

    public void m_7380_(@NotNull CompoundTag tag) {
    }

    public void m_7378_(@NotNull CompoundTag tag) {
    }

    public void retrieve() {
        if (this.getRodItem() == null) {
            this.m_146870_();
        }
        this.getRodItem().retrieveHook(this.rod, this.getPlayerOwner(), this.m_9236_());
    }

    public int retrieve(ItemStack stack, ServerLevel level, Player player) {
        if (!this.m_9236_().f_46443_ && player != null && this.shouldKeepFishing(player)) {
            int i = 0;
            if (this.getHookedIn() != null) {
                this.pullEntity(this.getHookedIn());
                CriteriaTriggers.f_10553_.m_40416_((ServerPlayer)player, stack, player.f_36083_, Collections.emptyList());
                this.m_9236_().m_7605_((Entity)this, (byte)31);
                i = this.getHookedIn() instanceof ItemEntity ? 3 : 5;
            } else if (this.nibble > 0) {
                if (!this.hasHookedItem()) {
                    this.catchType = CatchType.NOTHING;
                }
                switch (this.catchType) {
                    case FISH: 
                    case ITEM: {
                        if (this.fluid.m_205070_(TideTags.Fluids.LAVA_FISHING)) {
                            TideCriteriaTriggers.FISHED_IN_LAVA.trigger((ServerPlayer)player);
                        }
                        for (ItemStack hookedItem : this.hookedItems) {
                            Entity converted;
                            if (hookedItem.m_41619_()) continue;
                            ItemEntity pulledEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), hookedItem);
                            double d0 = player.m_20185_() - this.m_20185_();
                            double d1 = player.m_20186_() - this.m_20186_();
                            double d2 = player.m_20189_() - this.m_20189_();
                            pulledEntity.m_20334_(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                            if (Tide.PLATFORM.isModLoaded("fishingreal") && (converted = Tide.PLATFORM.fishingRealConvertItemStack(hookedItem, player, this.m_20182_())) != null) {
                                this.m_9236_().m_7967_(converted);
                                continue;
                            }
                            if (Tide.PLATFORM.isModLoaded("hybrid_aquatic") && pulledEntity instanceof ItemEntity) {
                                ItemEntity itemEntity = pulledEntity;
                                pulledEntity = Tide.PLATFORM.hybridAquaticConvertEntity(itemEntity, player, this);
                            }
                            this.m_9236_().m_7967_((Entity)pulledEntity);
                            player.m_9236_().m_7967_((Entity)new ExperienceOrb(player.m_9236_(), player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_() + 0.5, this.f_19796_.m_188503_(6) + 1));
                            if (this.rod.m_150930_(TideItems.DIAMOND_FISHING_ROD)) {
                                player.m_9236_().m_7967_((Entity)new ExperienceOrb(player.m_9236_(), player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_() + 0.5, this.f_19796_.m_188503_(4) + 1));
                            }
                            if (hookedItem.m_204117_(ItemTags.f_13156_)) {
                                player.m_36222_(Stats.f_12939_, 1);
                            }
                            CriteriaTriggers.f_10553_.m_40416_((ServerPlayer)player, stack, player.f_36083_, this.hookedItems);
                        }
                        Tide.PLATFORM.jobsAddonDropXp(player, this.hookedItems);
                        break;
                    }
                    case CRATE: {
                        BlockState lootCrate = this.getCrateBlock(this.hookedItems.get(0));
                        LootParams.Builder lootParamsBuilder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81463_, (Object)stack).m_287286_(LootContextParams.f_81461_, (Object)lootCrate).m_287286_(LootContextParams.f_81455_, (Object)this);
                        if (!Tide.PLATFORM.isFabric()) {
                            lootParamsBuilder = lootParamsBuilder.m_287286_(LootContextParams.f_81458_, (Object)Objects.requireNonNull(this.m_19749_()));
                        }
                        LootParams params = lootParamsBuilder.m_287239_((float)this.luck + player.m_36336_()).m_287235_(LootContextParamSets.f_81414_);
                        level.m_46597_(this.m_20183_(), lootCrate);
                        double dx = player.m_20185_() - (double)this.m_20183_().m_123341_();
                        double dy = player.m_20186_() - (double)this.m_20183_().m_123342_();
                        double dz = player.m_20189_() - (double)this.m_20183_().m_123343_();
                        LootCrateEntity.fall((Level)level, this.m_20183_(), lootCrate, TideLootTables.Fishing.CRATES, params, dx * 0.0666, dy * 0.0666 + Math.sqrt(Math.sqrt(dx * dx + dy * dy + dz * dz)) * 0.082 + 0.27, dz * 0.0666);
                        if (this.fluid.m_205070_(TideTags.Fluids.LAVA_FISHING) && this.fluid.m_192917_((Fluid)Fluids.f_76195_)) {
                            level.m_46597_(this.m_20183_(), Blocks.f_49991_.m_49966_());
                        }
                        if (this.fluid.m_205070_(TideTags.Fluids.WATER_FISHING) && this.fluid.m_192917_((Fluid)Fluids.f_76193_)) {
                            level.m_46597_(this.m_20183_(), Blocks.f_49990_.m_49966_());
                        }
                        TideCriteriaTriggers.FISHED_CRATE.trigger((ServerPlayer)player);
                        break;
                    }
                }
                i = 1;
            }
            if (this.m_20096_()) {
                i = 2;
            }
            this.startRetrieving();
            if (this.getLine().m_150930_(TideItems.REINFORCED_LINE) && (i -= new Random().nextFloat() > 0.7f ? 1 : 0) < 0) {
                i = 0;
            }
            return i;
        }
        return 0;
    }

    public void selectCatch(Player player, ItemStack rod) {
        this.catchType = CatchType.NOTHING;
        this.hookedItems = null;
        LootParams.Builder lootParamsBuilder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81463_, (Object)rod).m_287286_(LootContextParams.f_81455_, (Object)this);
        if (!Tide.PLATFORM.isFabric()) {
            lootParamsBuilder = lootParamsBuilder.m_287286_(LootContextParams.f_81458_, (Object)Objects.requireNonNull(this.m_19749_()));
        }
        ResourceLocation lootKey = BuiltInLootTables.f_78720_;
        LootParams params = lootParamsBuilder.m_287239_((float)this.luck + player.m_36336_()).m_287235_(LootContextParamSets.f_81414_);
        List<Object> selectionList = this.select(lootKey, params).orElse(List.of(Items.f_42527_.m_7968_()));
        if (Tide.PLATFORM.isModLoaded("unusualend") && this.getBiome().m_203373_(new ResourceLocation("unusualend:warped_reef")) && this.f_19796_.m_188501_() > 0.5f) {
            selectionList = List.of(((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("unusualend:raw_bluk"))).m_7968_());
        }
        if (this.usingMagneticBait() && this.f_19796_.m_216339_(0, 4) == 0) {
            lootKey = TideLootTables.Fishing.Crates.BLOCK;
            selectionList = this.select(lootKey, params).orElse(List.of(TideItems.SURFACE_LOOT_CRATE.m_7968_()));
        } else if (TideUtils.shouldGrabTideLootTable(selectionList, this.fluid) && ((selectionList = this.select(lootKey = TideLootTables.Fishing.SPECIAL, params).orElse(List.of())).isEmpty() || selectionList.stream().allMatch(ItemStack::m_41619_))) {
            lootKey = TideUtils.getTideLootTable(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.fluid, this.m_9236_());
            selectionList = this.select(lootKey, params).orElse(List.of(Items.f_42527_.m_7968_()));
        }
        Tide.LOG.info("Loot table used: {}", (Object)lootKey);
        this.hookedItems = selectionList;
        CatchType catchType = this.catchType = this.hookedItems.stream().anyMatch(item -> item.m_204117_(ItemTags.f_13156_) || TideUtils.isJournalFish(item)) ? CatchType.FISH : CatchType.ITEM;
        if (this.hookedItems.stream().anyMatch(item -> item.m_204117_(TideTags.Items.CRATES))) {
            this.catchType = CatchType.CRATE;
        }
        if (BaitUtils.isHoldingBait(rod) && !player.m_7500_()) {
            BaitContents.Mutable contents = new BaitContents.Mutable(TideFishingRodItem.getContents(rod));
            contents.shrinkStack(BaitUtils.getPrimaryBait(rod));
            TideFishingRodItem.setContents(rod, contents.toImmutable());
        }
        this.m_20088_().m_135381_(DATA_CATCH_TYPE, (Object)this.catchType.ordinal());
    }

    private Optional<List<ItemStack>> select(ResourceLocation lootKey, LootParams params) {
        MinecraftServer server = this.m_9236_().m_7654_();
        if (server == null) {
            return Optional.empty();
        }
        LootTable table = server.m_278653_().m_278676_(lootKey);
        ObjectArrayList items = table.m_287195_(params);
        return items.isEmpty() ? Optional.empty() : Optional.of(items);
    }

    public BlockState getCrateBlock(ItemStack crate) {
        Item item = crate.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.m_40614_().m_49966_();
        }
        return TideBlocks.SURFACE_LOOT_CRATE.m_49966_();
    }

    public void m_7822_(byte event) {
        if (event == 31 && this.m_9236_().f_46443_ && this.hookedIn instanceof Player && ((Player)this.hookedIn).m_7578_()) {
            this.pullEntity(this.hookedIn);
        }
        super.m_7822_(event);
    }

    protected void pullEntity(Entity entity) {
        Entity owner = this.m_19749_();
        if (owner != null) {
            Vec3 vec3 = new Vec3(owner.m_20185_() - this.m_20185_(), owner.m_20186_() - this.m_20186_(), owner.m_20189_() - this.m_20189_()).m_82490_(0.1);
            entity.m_20256_(entity.m_20184_().m_82549_(vec3));
        }
    }

    protected void startRetrieving() {
        this.catchType = CatchType.NOTHING;
        this.m_146870_();
    }

    @NotNull
    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        this.updateOwnerInfo(null);
        super.m_142687_(reason);
    }

    public void m_142036_() {
        this.updateOwnerInfo(null);
    }

    public void m_5602_(Entity entity) {
        super.m_5602_(entity);
        this.updateOwnerInfo(this);
    }

    private void updateOwnerInfo(TideFishingHook hook) {
        Player player = this.getPlayerOwner();
        if (player != null) {
            if (hook == null && player.f_36083_ != null) {
                ((HookAccessor)player.f_36083_).clearHook(player);
            }
            if (player.f_36083_ == null && hook != null) {
                player.f_36083_ = new HookAccessor(hook, this.m_9236_());
            }
        }
    }

    public Player getPlayerOwner() {
        Entity entity = this.m_19749_();
        return entity instanceof Player ? (Player)entity : null;
    }

    public Entity getHookedIn() {
        return this.hookedIn;
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        if (this.getPlayerOwner() == null) {
            int i = packet.m_131509_();
            LOGGER.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.m_9236_().m_6815_(i), (Object)i);
            this.m_6074_();
        }
    }

    public boolean m_5825_() {
        if (this.canFishInLava()) {
            return true;
        }
        return super.m_5825_();
    }

    public boolean m_6060_() {
        if (this.canFishInLava()) {
            return false;
        }
        return super.m_6060_();
    }

    public boolean canFishIn(FluidState fluidState) {
        if (fluidState.m_205070_(TideTags.Fluids.LAVA_FISHING)) {
            return this.canFishInLava();
        }
        return fluidState.m_205070_(TideTags.Fluids.CAN_FISH_IN);
    }

    public boolean canFishInLava() {
        if (this.getRodItem() == null) {
            return false;
        }
        return this.getRodItem().isLavaproof(this.rod);
    }

    public boolean isLavaFishing() {
        return this.fluid != null && this.fluid.m_205070_(FluidTags.f_13132_) || this.m_20077_() || this.lastTouchedFluid.m_205070_(TideTags.Fluids.LAVA_FISHING);
    }

    public TideFishingRodItem getRodItem() {
        Item item = this.rod.m_41720_();
        if (item instanceof TideFishingRodItem) {
            TideFishingRodItem rodItem = (TideFishingRodItem)item;
            return rodItem;
        }
        return null;
    }

    public ItemStack getRod() {
        return this.rod;
    }

    public ItemStack getBobber() {
        return CustomRodManager.getBobber(this.rod);
    }

    public ItemStack getHook() {
        return CustomRodManager.getHook(this.rod);
    }

    public ItemStack getLine() {
        return CustomRodManager.getLine(this.rod);
    }

    public boolean hasHookedItem() {
        return this.hookedItems != null && !this.hookedItems.isEmpty();
    }

    public List<ItemStack> getHookedItems() {
        return this.hookedItems;
    }

    public void setMinigameActive(boolean state) {
        this.minigameActive = state;
        if (!this.minigameActive) {
            this.nibble = 0;
        }
        this.f_19804_.m_135381_(DATA_MINIGAME_ACTIVE, (Object)state);
    }

    public CatchType getCatchType() {
        return CatchType.values()[(Integer)this.m_20088_().m_135370_(DATA_CATCH_TYPE)];
    }

    static enum FishHookState {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }

    public static enum CatchType {
        FISH,
        CRATE,
        ITEM,
        NOTHING;

    }

    static enum OpenFluidType {
        ABOVE_WATER,
        INSIDE_WATER,
        INVALID;

    }
}

