/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.misc.fishing;

import com.li64.tide.Tide;
import com.li64.tide.registries.TideItems;
import com.li64.tide.registries.entities.misc.fishing.TideFishingBobberLayer;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHookModel;
import com.li64.tide.registries.items.FishingHookItem;
import com.li64.tide.registries.items.FishingLineItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TideFishingHookRenderer
extends EntityRenderer<TideFishingHook>
implements RenderLayerParent<TideFishingHook, TideFishingHookModel<TideFishingHook>> {
    private final TideFishingHookModel<TideFishingHook> model;
    private final TideFishingBobberLayer bobberLayer;
    private static final ResourceLocation HOOK_TEX_LOCATION = Tide.resource("textures/entity/fishing_hook/fishing_hook.png");

    public TideFishingHookRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new TideFishingHookModel(context.m_174023_(TideFishingHookModel.LAYER_LOCATION));
        this.bobberLayer = new TideFishingBobberLayer(this, context.m_174027_(), context.m_174025_());
        this.f_114477_ = 0.1f;
    }

    public void render(TideFishingHook hookEntity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        Player player = hookEntity.getPlayerOwner();
        if (player == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.03125f, 0.0f, 0.03125f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - hookEntity.getInitialYaw()));
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.model.setupAnim(hookEntity, partialTick, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(hookEntity)));
        this.model.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        this.bobberLayer.render(poseStack, buffer, packedLight, hookEntity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        poseStack.m_85849_();
        this.renderConnectingString(hookEntity, partialTick, poseStack, buffer, player);
        poseStack.m_85849_();
        super.m_7392_((Entity)hookEntity, entityYaw, partialTick, poseStack, buffer, packedLight);
    }

    private void renderConnectingString(TideFishingHook hookEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, Player player) {
        float f = player.m_21324_(partialTick);
        float f1 = Mth.m_14031_((float)(Mth.m_14116_((float)f) * (float)Math.PI));
        Vec3 vec3 = this.getPlayerHandPos(player, f1, partialTick);
        Vec3 vec31 = hookEntity.m_20318_(partialTick).m_82520_(0.0, 0.25, 0.0);
        float f2 = (float)(vec3.f_82479_ - vec31.f_82479_);
        float f3 = (float)(vec3.f_82480_ - vec31.f_82480_);
        float f4 = (float)(vec3.f_82481_ - vec31.f_82481_);
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_173247_());
        PoseStack.Pose pose = poseStack.m_85850_();
        for (int k = 0; k <= 16; ++k) {
            TideFishingHookRenderer.stringVertex(f2, f3, f4, vertexConsumer, pose, TideFishingHookRenderer.fraction(k), TideFishingHookRenderer.fraction(k + 1), player, FishingLineItem.getColor(hookEntity.getLine()), partialTick);
        }
        if (Tide.PLATFORM.isModLoaded("iris")) {
            vertexConsumer.m_5483_(0.0, 0.0, 0.0).m_6122_(0, 0, 0, 255).m_5601_(0.0f, 0.0f, 0.0f);
        }
    }

    private Vec3 getPlayerHandPos(Player player, float anim, float partialTick) {
        Vec2 stringOffset;
        int i = player.m_5737_() == HumanoidArm.RIGHT ? 1 : -1;
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof FishingRodItem)) {
            i = -i;
        }
        Vec2 vec2 = stack.m_41720_() == TideItems.STONE_FISHING_ROD ? new Vec2(0.05f, -0.1f) : (stringOffset = stack.m_41720_() == TideItems.IRON_FISHING_ROD ? new Vec2(0.05f, -0.02f) : new Vec2(0.0f, 0.0f));
        if (!Tide.PLATFORM.isModLoaded("firstperson") && this.f_114476_.f_114360_.m_92176_().m_90612_() && player == Minecraft.m_91087_().f_91074_) {
            double fovOption = ((Integer)this.f_114476_.f_114360_.m_231837_().m_231551_()).doubleValue();
            double d4 = 960.0 / fovOption;
            double fovScalar = (Minecraft.m_91087_().f_91063_.m_109141_(this.f_114476_.f_114358_, partialTick, true) / fovOption - 1.0) * 2.5 + 1.0;
            Vec3 vec3 = this.f_114476_.f_114358_.m_167684_().m_167695_((float)i * (0.525f + stringOffset.f_82470_) * (float)fovScalar, (-0.1f + stringOffset.f_82471_) * (float)fovScalar).m_82490_(d4).m_82524_(anim * 0.5f).m_82496_(-anim * 0.7f);
            return player.m_20299_(partialTick).m_82549_(vec3);
        }
        float f = Mth.m_14179_((float)partialTick, (float)player.f_20884_, (float)player.f_20883_) * ((float)Math.PI / 180);
        double d0 = Mth.m_14031_((float)f);
        double d1 = Mth.m_14089_((float)f);
        float f1 = player.m_6134_();
        double d2 = (double)i * 0.35 * (double)f1;
        double d3 = 0.8 * (double)f1;
        float f2 = player.m_6047_() ? -0.1875f : 0.0f;
        return player.m_20299_(partialTick).m_82520_(-d1 * d2 - d0 * d3, (double)f2 - 0.45 * (double)f1, -d0 * d2 + d1 * d3);
    }

    private static float fraction(int pNumerator) {
        return (float)pNumerator / 16.0f;
    }

    private static void stringVertex(float x, float y, float z, VertexConsumer vertexConsumer, PoseStack.Pose pose, float frac1, float frac2, Player player, String colorHex, float partialTick) {
        float f = x * frac1;
        float f1 = y * (frac1 * frac1 + frac1) * 0.5f + 0.25f;
        float f2 = z * frac1;
        float f3 = x * frac2 - f;
        float f4 = y * (frac2 * frac2 + frac2) * 0.5f + 0.25f - f1;
        float f5 = z * frac2 - f2;
        float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
        f3 /= f6;
        f4 /= f6;
        f5 /= f6;
        Color color = Color.decode(colorHex);
        BlockPos samplePos = player.m_20183_().m_7494_();
        float skyDarken = (1.0f - ((ClientLevel)player.m_9236_()).m_104805_(partialTick)) * 15.0f;
        float blockBrightness = player.m_9236_().m_45517_(LightLayer.BLOCK, samplePos);
        float skyBrightness = (float)player.m_9236_().m_45517_(LightLayer.SKY, samplePos) - skyDarken + 1.0f;
        float colorBrightness = Tide.CONFIG.general.defaultLineColor ? 0.0f : Mth.m_14036_((float)(Math.max(blockBrightness, skyBrightness) / 15.0f), (float)player.m_9236_().m_6042_().f_63838_(), (float)1.0f);
        int r = (int)((float)color.getRed() * colorBrightness);
        int g = (int)((float)color.getGreen() * colorBrightness);
        int b = (int)((float)color.getBlue() * colorBrightness);
        vertexConsumer.m_252986_(pose.m_252922_(), f, f1, f2).m_6122_(r, g, b, 255).m_252939_(pose.m_252943_(), f3, f4, f5).m_5752_();
    }

    @NotNull
    public TideFishingHookModel<TideFishingHook> getModel() {
        return this.model;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull TideFishingHook hookEntity) {
        if (!this.allowModifiers()) {
            return HOOK_TEX_LOCATION;
        }
        return FishingHookItem.getTexture(hookEntity.getHook());
    }

    protected boolean allowModifiers() {
        return true;
    }
}

