/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class TideLakeFeature
extends Feature<Configuration> {
    private static final BlockState AIR = Blocks.f_50627_.m_49966_();

    public TideLakeFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Configuration> context) {
        BlockPos origin = context.m_159777_();
        WorldGenLevel worldgenlevel = context.m_159774_();
        RandomSource randomsource = context.m_225041_();
        Configuration configuration = (Configuration)context.m_159778_();
        if (origin.m_123342_() <= worldgenlevel.m_141937_() + 4) {
            return false;
        }
        origin = origin.m_6625_(4);
        boolean[] booleans = new boolean[2048];
        int i = randomsource.m_188503_(4) + 4;
        for (int j = 0; j < i; ++j) {
            double d0 = randomsource.m_188500_() * 6.0 + 3.0;
            double d1 = randomsource.m_188500_() * 4.0 + 2.0;
            double d2 = randomsource.m_188500_() * 6.0 + 3.0;
            double d3 = randomsource.m_188500_() * (16.0 - d0 - 2.0) + 1.0 + d0 / 2.0;
            double d4 = randomsource.m_188500_() * (8.0 - d1 - 4.0) + 2.0 + d1 / 2.0;
            double d5 = randomsource.m_188500_() * (16.0 - d2 - 2.0) + 1.0 + d2 / 2.0;
            for (int l = 1; l < 15; ++l) {
                for (int i1 = 1; i1 < 15; ++i1) {
                    for (int j1 = 1; j1 < 7; ++j1) {
                        double d6 = ((double)l - d3) / (d0 / 2.0);
                        double d7 = ((double)j1 - d4) / (d1 / 2.0);
                        double d8 = ((double)i1 - d5) / (d2 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(d9 < 1.0)) continue;
                        booleans[(l * 16 + i1) * 8 + j1] = true;
                    }
                }
            }
        }
        BlockState fluid = configuration.fluid().m_213972_(randomsource, origin);
        for (int k1 = 0; k1 < 16; ++k1) {
            for (int k = 0; k < 16; ++k) {
                for (int l2 = 0; l2 < 8; ++l2) {
                    boolean flag;
                    boolean bl = flag = !booleans[(k1 * 16 + k) * 8 + l2] && (k1 < 15 && booleans[((k1 + 1) * 16 + k) * 8 + l2] || k1 > 0 && booleans[((k1 - 1) * 16 + k) * 8 + l2] || k < 15 && booleans[(k1 * 16 + k + 1) * 8 + l2] || k > 0 && booleans[(k1 * 16 + (k - 1)) * 8 + l2] || l2 < 7 && booleans[(k1 * 16 + k) * 8 + l2 + 1] || l2 > 0 && booleans[(k1 * 16 + k) * 8 + (l2 - 1)]);
                    if (!flag) continue;
                    BlockState state = worldgenlevel.m_8055_(origin.m_7918_(k1, l2, k));
                    if (l2 >= 4 && state.m_278721_()) {
                        return false;
                    }
                    if (l2 >= 4 || state.m_280296_() || worldgenlevel.m_8055_(origin.m_7918_(k1, l2, k)) == fluid) continue;
                    return false;
                }
            }
        }
        for (int l1 = 0; l1 < 16; ++l1) {
            for (int i2 = 0; i2 < 16; ++i2) {
                for (int i3 = 0; i3 < 8; ++i3) {
                    BlockPos pos;
                    if (!booleans[(l1 * 16 + i2) * 8 + i3] || !this.canReplaceBlock(worldgenlevel.m_8055_(pos = origin.m_7918_(l1, i3, i2)))) continue;
                    boolean flag1 = i3 >= 4;
                    worldgenlevel.m_7731_(pos, flag1 ? AIR : fluid, 2);
                    if (!flag1) continue;
                    worldgenlevel.m_186460_(pos, AIR.m_60734_(), 0);
                    this.m_159739_(worldgenlevel, pos);
                }
            }
        }
        BlockState state = configuration.barrier().m_213972_(randomsource, origin);
        if (!state.m_60795_()) {
            for (int j2 = 0; j2 < 16; ++j2) {
                for (int j3 = 0; j3 < 16; ++j3) {
                    for (int l3 = 0; l3 < 8; ++l3) {
                        BlockState blockstate;
                        boolean flag2;
                        boolean bl = flag2 = !booleans[(j2 * 16 + j3) * 8 + l3] && (j2 < 15 && booleans[((j2 + 1) * 16 + j3) * 8 + l3] || j2 > 0 && booleans[((j2 - 1) * 16 + j3) * 8 + l3] || j3 < 15 && booleans[(j2 * 16 + j3 + 1) * 8 + l3] || j3 > 0 && booleans[(j2 * 16 + (j3 - 1)) * 8 + l3] || l3 < 7 && booleans[(j2 * 16 + j3) * 8 + l3 + 1] || l3 > 0 && booleans[(j2 * 16 + j3) * 8 + (l3 - 1)]);
                        if (!flag2 || l3 >= 4 && randomsource.m_188503_(2) == 0 || !(blockstate = worldgenlevel.m_8055_(origin.m_7918_(j2, l3, j3))).m_280296_() || blockstate.m_204336_(BlockTags.f_144288_)) continue;
                        BlockPos pos = origin.m_7918_(j2, l3, j3);
                        worldgenlevel.m_7731_(pos, state, 2);
                        this.m_159739_(worldgenlevel, pos);
                    }
                }
            }
        }
        return true;
    }

    private boolean canReplaceBlock(BlockState state) {
        return !state.m_204336_(BlockTags.f_144287_);
    }

    public record Configuration(BlockStateProvider fluid, BlockStateProvider barrier) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.f_68747_.fieldOf("fluid").forGetter(Configuration::fluid), (App)BlockStateProvider.f_68747_.fieldOf("barrier").forGetter(Configuration::barrier)).apply((Applicative)instance, Configuration::new));
    }
}

