/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;

public class EntityDespawnHandler {
    public static int NO_PLAYER_DESPAWN_TICKS = 600;
    public static double FAR_DESPAWN_CHANCE = 0.01;
    public static double NEAR_DESPAWN_CHANCE = 0.0033;
    public static int FAR_DESPAWN_RADIUS = 64;
    public static int NEAR_DESPAWN_RADIUS = 32;
    public static int PLAYER_SEARCH_RADIUS = 128;

    public static void handleDespawn(Mob mob) {
        TamableAnimal tamable;
        if (mob instanceof TamableAnimal && (tamable = (TamableAnimal)mob).m_21824_()) {
            return;
        }
        if (mob.m_8077_()) {
            return;
        }
        Player nearestPlayer = mob.m_9236_().m_45930_((Entity)mob, (double)PLAYER_SEARCH_RADIUS);
        if (nearestPlayer == null) {
            if (mob.f_19797_ > NO_PLAYER_DESPAWN_TICKS) {
                mob.m_146870_();
            }
            return;
        }
        double distanceSqr = mob.m_20280_((Entity)nearestPlayer);
        if (distanceSqr > (double)(FAR_DESPAWN_RADIUS * FAR_DESPAWN_RADIUS)) {
            if ((double)mob.m_217043_().m_188501_() < FAR_DESPAWN_CHANCE / 20.0) {
                mob.m_146870_();
            }
        } else if (distanceSqr > (double)(NEAR_DESPAWN_RADIUS * NEAR_DESPAWN_RADIUS) && (double)mob.m_217043_().m_188501_() < NEAR_DESPAWN_CHANCE / 20.0) {
            mob.m_146870_();
        }
    }
}

