/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra;

import falconnex.legendsofslugterra.SlugStorage;
import falconnex.legendsofslugterra.entity.HoverbugEntity;
import falconnex.legendsofslugterra.init.SlugterraModMobEffects;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class HoverSlugWanderGoal
extends Goal {
    private final TamableAnimal mob;
    private final double speed;
    private Vec3 targetPos;
    private boolean isFlying = false;

    public HoverSlugWanderGoal(TamableAnimal mob, double speed) {
        this.mob = mob;
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.mob.m_21023_((MobEffect)SlugterraModMobEffects.SLUGGY.get())) {
            return false;
        }
        if (!this.mob.m_21824_()) {
            if (this.mob.m_217043_().m_188503_(HoverSlugWanderGoal.m_186073_((int)30)) != 0) {
                return false;
            }
            if (this.isFlying) {
                this.isFlying = (double)this.mob.m_217043_().m_188501_() > 0.1;
            } else {
                boolean bl = this.isFlying = (double)this.mob.m_217043_().m_188501_() < 0.3;
            }
            if (this.isFlying) {
                ((HoverbugEntity)this.mob).SetFlying(true);
                this.targetPos = this.GetRandomFlyingPosition();
            } else {
                ((HoverbugEntity)this.mob).SetFlying(false);
                this.targetPos = DefaultRandomPos.m_148403_((PathfinderMob)this.mob, (int)10, (int)7);
            }
            return this.targetPos != null;
        }
        CompoundTag slugData = this.mob.getPersistentData();
        CompoundTag protoData = SlugStorage.GetEntityProto(slugData);
        String currentState = protoData.m_128461_("currentState");
        if (currentState == "walking") {
            this.isFlying = false;
            ((HoverbugEntity)this.mob).SetFlying(false);
        } else if (currentState == "flying") {
            this.isFlying = true;
            ((HoverbugEntity)this.mob).SetFlying(true);
        } else if (currentState == "random") {
            if (this.mob.m_217043_().m_188503_(HoverSlugWanderGoal.m_186073_((int)40)) == 0) {
                this.isFlying = this.isFlying ? (double)this.mob.m_217043_().m_188501_() > 0.1 : (double)this.mob.m_217043_().m_188501_() < 0.1;
                ((HoverbugEntity)this.mob).SetFlying(this.isFlying);
            }
        } else {
            this.isFlying = false;
            ((HoverbugEntity)this.mob).SetFlying(false);
        }
        if (slugData.m_128441_("linkedBlockPos")) {
            if (this.mob.m_217043_().m_188503_(HoverSlugWanderGoal.m_186073_((int)30)) != 0) {
                return false;
            }
            BlockPos linkedBlockPos = BlockPos.m_122022_((long)slugData.m_128454_("linkedBlockPos"));
            Vec3 linkedPos = Vec3.m_82512_((Vec3i)linkedBlockPos);
            Vec3 newPos = this.isFlying ? this.GetRandomFlyingTargetPosition(linkedPos) : DefaultRandomPos.m_148412_((PathfinderMob)this.mob, (int)7, (int)7, (Vec3)linkedPos, (double)1.0);
            if (newPos != null) {
                this.targetPos = newPos;
                System.out.println(this.targetPos);
                return true;
            }
            System.out.println("no target");
            return false;
        }
        if (this.mob.m_269323_() != null) {
            double distToOwner = this.mob.m_20270_((Entity)this.mob.m_269323_());
            return distToOwner > 4.0;
        }
        return false;
    }

    public void m_8056_() {
        if (this.targetPos != null) {
            this.mob.m_21573_().m_26519_(this.targetPos.f_82479_, this.targetPos.f_82480_, this.targetPos.f_82481_, this.speed);
        } else if (this.mob.m_269323_() != null) {
            BlockPos ownerPos;
            LivingEntity owner = this.mob.m_269323_();
            double distToOwner = this.mob.m_20280_((Entity)owner);
            if (distToOwner > 144.0 && owner.m_20096_()) {
                ownerPos = owner.m_20183_();
                this.mob.m_6021_((double)ownerPos.m_123341_() + 0.5, (double)ownerPos.m_123342_(), (double)ownerPos.m_123343_() + 0.5);
            }
            if (this.isFlying) {
                ownerPos = this.GetOwnerFlyingPosition(this.mob.m_269323_());
                this.mob.m_21573_().m_26519_(ownerPos.f_82479_, ownerPos.f_82480_, ownerPos.f_82481_, this.speed);
            } else {
                this.mob.m_21573_().m_5624_((Entity)this.mob.m_269323_(), this.speed);
            }
        }
    }

    public boolean m_8045_() {
        CompoundTag slugData = this.mob.getPersistentData();
        if (!slugData.m_128441_("linkedBlockPos")) {
            return false;
        }
        return !this.mob.m_21573_().m_26571_();
    }

    private Vec3 GetRandomFlyingPosition() {
        BlockPos base = this.mob.m_20183_();
        while (base.m_123342_() > this.mob.m_9236_().m_141937_()) {
            BlockPos below = base.m_7495_();
            if (!this.mob.m_9236_().m_8055_(below).m_60795_()) break;
            base = below;
        }
        double x = base.m_123341_() + this.mob.m_217043_().m_188503_(16) - 8;
        double y = base.m_123342_() + this.mob.m_217043_().m_188503_(4) + 6;
        double z = base.m_123343_() + this.mob.m_217043_().m_188503_(16) - 8;
        return new Vec3(x, y, z);
    }

    private Vec3 GetRandomFlyingTargetPosition(Vec3 centerPos) {
        double x = centerPos.f_82479_ + (double)this.mob.m_217043_().m_188503_(14) - 7.0;
        double y = centerPos.f_82480_ + (double)this.mob.m_217043_().m_188503_(4) + 3.0;
        double z = centerPos.f_82481_ + (double)this.mob.m_217043_().m_188503_(14) - 7.0;
        return new Vec3(x, y, z);
    }

    private Vec3 GetOwnerFlyingPosition(LivingEntity player) {
        double x = player.m_20185_() + (double)this.mob.m_217043_().m_188503_(4) - 2.0;
        double y = player.m_20186_() + (double)this.mob.m_217043_().m_188503_(3) + 2.0;
        double z = player.m_20189_() + (double)this.mob.m_217043_().m_188503_(4) - 2.0;
        return new Vec3(x, y, z);
    }
}

