/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra;

import falconnex.legendsofslugterra.SlugItemMapper;
import falconnex.legendsofslugterra.entity.TexturableEntity;
import falconnex.legendsofslugterra.init.SlugterraModItems;
import java.lang.reflect.Field;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;

public class SlugStorage {
    public static void StoreEntity(Player player, Entity entity, ItemStack stack) {
        TamableAnimal tamableEntity;
        if (entity instanceof TamableAnimal && (tamableEntity = (TamableAnimal)entity).m_21824_() && tamableEntity.m_269323_() != null && tamableEntity.m_269323_().equals((Object)player)) {
            ItemStack heldStack = player.m_21205_();
            RegistryObject<Item> entityCapsuleObject = !entity.getPersistentData().m_128441_("customTexture") ? SlugItemMapper.GetCapsuleFromEntity(entity) : SlugItemMapper.GetCapsuleFromTexture(entity.getPersistentData().m_128461_("customTexture"));
            if (entityCapsuleObject == null) {
                player.m_213846_((Component)Component.m_237113_((String)"That is not a valid entity!"));
                return;
            }
            ItemStack filledCapsule = new ItemStack((ItemLike)entityCapsuleObject.get());
            CompoundTag existingData = new CompoundTag();
            entity.m_20223_(existingData);
            CompoundTag entityData = new CompoundTag();
            CompoundTag forgeData = new CompoundTag();
            entityData.m_128359_("id", existingData.m_128461_("id"));
            entityData.m_128405_("DataDamage", existingData.m_128451_("DataDamage"));
            entityData.m_128405_("DataKnockback", existingData.m_128451_("DataKnockback"));
            entityData.m_128405_("DataSpeed", existingData.m_128451_("DataSpeed"));
            if (entity.m_8077_()) {
                entityData.m_128365_("CustomName", (Tag)StringTag.m_129297_((String)("{\"text\":\"" + entity.m_7770_().getString() + "\"}")));
            }
            entityData.m_128350_("Health", ((LivingEntity)entity).m_21223_());
            CompoundTag persistentData = entity.getPersistentData();
            if (persistentData.m_128441_("variables")) {
                entityData.m_128365_("variables", entity.getPersistentData().m_128423_("variables"));
                forgeData.m_128365_("variables", entity.getPersistentData().m_128423_("variables"));
            }
            if (persistentData.m_128441_("proto")) {
                entityData.m_128365_("proto", entity.getPersistentData().m_128423_("proto"));
                forgeData.m_128365_("proto", entity.getPersistentData().m_128423_("proto"));
            }
            if (persistentData.m_128441_("customTexture")) {
                entityData.m_128365_("customTexture", entity.getPersistentData().m_128423_("customTexture"));
                forgeData.m_128365_("customTexture", entity.getPersistentData().m_128423_("customTexture"));
            }
            entityData.m_128365_("ForgeData", (Tag)forgeData);
            filledCapsule.m_41784_().m_128365_("entityData", (Tag)entityData);
            if (entity.m_8077_()) {
                filledCapsule.m_41714_((Component)Component.m_237113_((String)entity.m_7755_().getString()));
            }
            CompoundTag variablesTag = SlugStorage.GetEntityVariables(entityData);
            CompoundTag displayTag = filledCapsule.m_41698_("display");
            ListTag lore = new ListTag();
            for (String key : variablesTag.m_128431_()) {
                String loreText;
                Tag tag = variablesTag.m_128423_(key);
                if (tag == null) continue;
                String tagText = tag.m_7916_();
                if (key == "Thugglet") {
                    loreText = "{\"text\":\"" + key + "\",\"color\":\"red\"}";
                    lore.add((Object)StringTag.m_129297_((String)loreText));
                    continue;
                }
                if (tag instanceof DoubleTag) {
                    double value = ((DoubleTag)tag).m_7061_();
                    tagText = String.format("%.0f", value);
                }
                loreText = "{\"text\":\"" + key + ": " + tagText + "\",\"color\":\"green\"}";
                lore.add((Object)StringTag.m_129297_((String)loreText));
            }
            displayTag.m_128365_("Lore", (Tag)lore);
            if (!player.m_150109_().m_36054_(filledCapsule)) {
                player.m_36176_(filledCapsule, false);
            }
            heldStack.m_41774_(1);
            entity.m_146870_();
            ServerLevel serverLevel = (ServerLevel)player.m_9236_();
            ResourceLocation soundLocation = new ResourceLocation("slugterra", "catching_slug_in_tube");
            SoundEvent soundEvent = SoundEvent.m_262824_((ResourceLocation)soundLocation);
            serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void SpawnEntity(Player player, ItemStack stack, Vec3 spawnPos) {
        EntityType<?> entityType = SlugItemMapper.GetEntityFromCapsule(stack.m_41720_());
        if (entityType == null) {
            return;
        }
        Entity entity = entityType.m_20615_(player.m_9236_());
        if (stack.m_41782_() && stack.m_41783_().m_128441_("entityData")) {
            CompoundTag entityData = stack.m_41783_().m_128469_("entityData");
            entity.m_20258_(entityData);
        }
        Item item = stack.m_41720_();
        try {
            Field field = item.getClass().getDeclaredField("customTexture");
            Object texture = field.get(item);
            if (texture instanceof String) {
                String textureString = (String)texture;
                if (entity instanceof TexturableEntity) {
                    TexturableEntity texturableEntity = (TexturableEntity)entity;
                    texturableEntity.setTexture(textureString + "_texture");
                    entity.getPersistentData().m_128359_("customTexture", textureString);
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException field) {
            // empty catch block
        }
        if (entity instanceof TamableAnimal) {
            TamableAnimal tamableEntity = (TamableAnimal)entity;
            tamableEntity.m_21828_(player);
        }
        entity.m_6027_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
        player.m_9236_().m_7967_(entity);
        player.m_150109_().m_36057_(stack);
        ItemStack emptyCapsule = new ItemStack((ItemLike)SlugterraModItems.EMPTY_CAPSULE.get());
        if (!player.m_150109_().m_36054_(emptyCapsule)) {
            player.m_36176_(emptyCapsule, false);
        }
    }

    public static CompoundTag GetEntityVariables(CompoundTag entityData) {
        CompoundTag variablesTag = entityData.m_128425_("variables", 10) ? entityData.m_128469_("variables") : new CompoundTag();
        return variablesTag;
    }

    public static CompoundTag GetEntityProto(CompoundTag entityData) {
        CompoundTag protoTag = entityData.m_128425_("proto", 10) ? entityData.m_128469_("proto") : new CompoundTag();
        return protoTag;
    }

    public static String GetEntityName(CompoundTag entityData) {
        if (entityData.m_128425_("CustomName", 8)) {
            return Component.Serializer.m_130701_((String)entityData.m_128461_("CustomName")).getString();
        }
        if (entityData.m_128425_("id", 8)) {
            String entityId = entityData.m_128461_("id");
            EntityType entityType = EntityType.m_20632_((String)entityId).orElse(null);
            return entityType.m_20676_().getString();
        }
        return "Unknown Entity";
    }
}

