/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra;

import falconnex.legendsofslugterra.SlugStorage;
import falconnex.legendsofslugterra.init.SlugterraModMobEffects;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SlugWanderGoal
extends Goal {
    private final TamableAnimal mob;
    private final double speed;
    private Vec3 targetPos;

    public SlugWanderGoal(TamableAnimal mob, double speed) {
        this.mob = mob;
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.mob.m_21023_((MobEffect)SlugterraModMobEffects.SLUGGY.get())) {
            return false;
        }
        if (!this.mob.m_21824_()) {
            if (this.mob.m_217043_().m_188503_(SlugWanderGoal.m_186073_((int)30)) != 0) {
                return false;
            }
            this.targetPos = DefaultRandomPos.m_148403_((PathfinderMob)this.mob, (int)10, (int)7);
            return this.targetPos != null;
        }
        CompoundTag slugData = this.mob.getPersistentData();
        CompoundTag protoData = SlugStorage.GetEntityProto(slugData);
        if (slugData.m_128441_("linkedBlockPos")) {
            if (this.mob.m_217043_().m_188503_(SlugWanderGoal.m_186073_((int)30)) != 0) {
                return false;
            }
            BlockPos linkedBlockPos = BlockPos.m_122022_((long)slugData.m_128454_("linkedBlockPos"));
            Vec3 linkedPos = Vec3.m_82512_((Vec3i)linkedBlockPos);
            Vec3 newPos = DefaultRandomPos.m_148412_((PathfinderMob)this.mob, (int)7, (int)7, (Vec3)linkedPos, (double)1.0);
            if (newPos != null) {
                this.targetPos = newPos;
                return true;
            }
            return false;
        }
        if (this.mob.m_269323_() != null) {
            double distToOwner = this.mob.m_20270_((Entity)this.mob.m_269323_());
            BlockPos playerBlockPos = this.mob.m_269323_().m_20183_();
            Vec3 playerPos = Vec3.m_82512_((Vec3i)playerBlockPos);
            if (distToOwner < 7.0) {
                if (this.mob.m_217043_().m_188503_(SlugWanderGoal.m_186073_((int)30)) != 0) {
                    return false;
                }
                Vec3 newPos = DefaultRandomPos.m_148412_((PathfinderMob)this.mob, (int)7, (int)7, (Vec3)playerPos, (double)1.0);
                if (newPos != null) {
                    this.targetPos = newPos;
                    return true;
                }
                return false;
            }
            this.targetPos = playerPos;
            return distToOwner > 4.0;
        }
        return false;
    }

    public void m_8056_() {
        if (this.targetPos != null) {
            this.mob.m_21573_().m_26519_(this.targetPos.f_82479_, this.targetPos.f_82480_, this.targetPos.f_82481_, this.speed);
            CompoundTag slugData = this.mob.getPersistentData();
            if (this.mob.m_269323_() != null && !slugData.m_128441_("linkedBlockPos")) {
                LivingEntity owner = this.mob.m_269323_();
                double distToOwner = this.mob.m_20280_((Entity)owner);
                BlockPos ownerPos = owner.m_20183_();
                AABB entityBox = this.mob.m_20191_().m_82386_((double)ownerPos.m_123341_() - this.mob.m_20185_(), (double)ownerPos.m_123342_() - this.mob.m_20186_(), (double)ownerPos.m_123343_() - this.mob.m_20189_());
                boolean isGroundSolid = this.mob.m_9236_().m_8055_(ownerPos).m_60804_((BlockGetter)this.mob.m_9236_(), ownerPos);
                boolean isSafe = this.mob.m_9236_().m_45756_((Entity)this.mob, entityBox);
                if (distToOwner > 200.0 && owner.m_20096_() && !owner.m_20077_() && isSafe) {
                    this.mob.m_6021_((double)ownerPos.m_123341_() + 0.5, (double)ownerPos.m_123342_(), (double)ownerPos.m_123343_() + 0.5);
                    this.targetPos = null;
                }
            }
        } else if (this.mob.m_269323_() != null) {
            this.mob.m_21573_().m_5624_((Entity)this.mob.m_269323_(), this.speed);
        }
    }

    public boolean m_8045_() {
        CompoundTag slugData = this.mob.getPersistentData();
        if (!slugData.m_128441_("linkedBlockPos")) {
            return false;
        }
        return !this.mob.m_21573_().m_26571_();
    }
}

