/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class AvoidStrangersGoal
extends Goal {
    private final PathfinderMob mob;
    private final float avoidDistance;
    private final double speedModifier;
    private Player avoidTarget;
    private Vec3 fleePos;
    private int rePathCooldown = 0;
    private static final int REPATH_INTERVAL = 10;

    public AvoidStrangersGoal(PathfinderMob mob, float avoidDistance, double speedModifier) {
        this.mob = mob;
        this.avoidDistance = avoidDistance;
        this.speedModifier = speedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.rePathCooldown > 0) {
            --this.rePathCooldown;
            return false;
        }
        if (this.mob instanceof TamableAnimal && ((TamableAnimal)this.mob).m_21824_()) {
            LivingEntity owner = ((TamableAnimal)this.mob).m_269323_();
            List players = this.mob.m_9236_().m_6443_(Player.class, this.mob.m_20191_().m_82400_((double)this.avoidDistance), player -> player != owner && player.m_6084_() && this.mob.m_142582_((Entity)player));
            if (!players.isEmpty()) {
                this.avoidTarget = this.findMostThreateningPlayer(players);
                return this.findFleePosition();
            }
        } else {
            this.avoidTarget = this.mob.m_9236_().m_45930_((Entity)this.mob, (double)this.avoidDistance);
            if (this.avoidTarget != null && this.mob.m_142582_((Entity)this.avoidTarget)) {
                return this.findFleePosition();
            }
        }
        return false;
    }

    private Player findMostThreateningPlayer(List<Player> players) {
        Player mostThreatening = null;
        double closestDistance = Double.MAX_VALUE;
        for (Player player : players) {
            double distance = this.mob.m_20280_((Entity)player);
            if (!(distance < closestDistance) || !player.m_142582_((Entity)this.mob)) continue;
            closestDistance = distance;
            mostThreatening = player;
        }
        return mostThreatening != null ? mostThreatening : players.get(0);
    }

    public boolean m_8045_() {
        if (this.avoidTarget == null || !this.avoidTarget.m_6084_()) {
            return false;
        }
        if (!this.mob.m_21573_().m_26571_()) {
            return true;
        }
        if (this.mob.m_20280_((Entity)this.avoidTarget) < (double)(this.avoidDistance * this.avoidDistance) * 1.1 && this.rePathCooldown <= 0) {
            return this.findFleePosition();
        }
        return false;
    }

    public void m_8056_() {
        this.rePathCooldown = 10;
        this.mob.m_21573_().m_26519_(this.fleePos.f_82479_, this.fleePos.f_82480_, this.fleePos.f_82481_, this.speedModifier);
    }

    public void m_8041_() {
        this.avoidTarget = null;
        this.mob.m_21573_().m_26573_();
    }

    private boolean findFleePosition() {
        if (this.avoidTarget == null) {
            return false;
        }
        Vec3 fleeDirection = this.mob.m_20182_().m_82546_(this.avoidTarget.m_20182_()).m_82541_();
        Vec3 targetFleePos = this.mob.m_20182_().m_82549_(fleeDirection.m_82490_((double)(this.avoidDistance * 1.8f)));
        this.fleePos = LandRandomPos.m_148521_((PathfinderMob)this.mob, (int)((int)this.avoidDistance), (int)9, (Vec3)this.avoidTarget.m_20182_());
        if (this.fleePos == null) {
            this.fleePos = targetFleePos;
        }
        this.rePathCooldown = 10;
        return this.fleePos != null;
    }

    public void m_8037_() {
        if (this.rePathCooldown <= 0 && this.avoidTarget != null && this.mob.m_20280_((Entity)this.avoidTarget) < (double)(this.avoidDistance * this.avoidDistance) * 1.1) {
            this.findFleePosition();
            this.mob.m_21573_().m_26519_(this.fleePos.f_82479_, this.fleePos.f_82480_, this.fleePos.f_82481_, this.speedModifier);
        } else if (this.rePathCooldown > 0) {
            --this.rePathCooldown;
        }
    }
}

