/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.ai;

import falconnex.legendsofslugterra.entity.SlyrenEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class FollowOrFleeIceOgreGoal
extends Goal {
    private final SlyrenEntity slyren;
    private Mob targetOgre;
    private final double speedModifier;
    private final float followDistance;
    private final float fleeDistance;
    private int timeToRecalcPath;
    private static final int OGRE_CHECK_INTERVAL = 20;
    private static final ResourceLocation ICE_OGRE_ID = new ResourceLocation("slugterra", "ice_ogre");

    public FollowOrFleeIceOgreGoal(SlyrenEntity slyren, double speedModifier, float followDistance, float fleeDistance) {
        this.slyren = slyren;
        this.speedModifier = speedModifier;
        this.followDistance = followDistance;
        this.fleeDistance = fleeDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.slyren.f_19797_ % 20 != 0) {
            return this.targetOgre != null && this.targetOgre.m_6084_() && ForgeRegistries.ENTITY_TYPES.getKey((Object)this.targetOgre.m_6095_()).equals((Object)ICE_OGRE_ID);
        }
        if (this.slyren.m_21824_()) {
            return false;
        }
        List ogres = this.slyren.m_9236_().m_6249_((Entity)this.slyren, this.slyren.m_20191_().m_82400_((double)(this.followDistance * 2.0f)), e -> ForgeRegistries.ENTITY_TYPES.getKey((Object)e.m_6095_()).equals((Object)ICE_OGRE_ID) && e.m_6084_());
        if (ogres.isEmpty() || !(ogres.get(0) instanceof Mob)) {
            this.targetOgre = null;
            return false;
        }
        this.targetOgre = (Mob)ogres.get(0);
        return true;
    }

    public boolean m_8045_() {
        if (this.targetOgre == null || !this.targetOgre.m_6084_()) {
            return false;
        }
        double distance = this.slyren.m_20280_((Entity)this.targetOgre);
        return distance <= (double)(this.followDistance * 2.0f * (this.followDistance * 2.0f));
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
    }

    public void m_8041_() {
        this.targetOgre = null;
        this.slyren.m_21573_().m_26573_();
    }

    public void m_8037_() {
        boolean isOgreAggressive;
        if (this.targetOgre == null || !this.targetOgre.m_6084_()) {
            return;
        }
        this.slyren.m_21563_().m_24960_((Entity)this.targetOgre, 10.0f, (float)this.slyren.m_8132_());
        double distance = this.slyren.m_20280_((Entity)this.targetOgre);
        boolean bl = isOgreAggressive = this.targetOgre.m_5448_() != null;
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (isOgreAggressive) {
                Vec3 fleePos;
                if (distance < (double)(this.fleeDistance * this.fleeDistance) && (fleePos = DefaultRandomPos.m_148407_((PathfinderMob)this.slyren, (int)((int)this.fleeDistance * 2), (int)7, (Vec3)this.targetOgre.m_20182_())) != null) {
                    this.slyren.m_21573_().m_26519_(fleePos.f_82479_, fleePos.f_82480_, fleePos.f_82481_, this.speedModifier * 1.5);
                }
            } else if (distance > (double)(this.followDistance * this.followDistance)) {
                this.slyren.m_21573_().m_5624_((Entity)this.targetOgre, this.speedModifier);
            }
        }
    }
}

