/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class FriendlyApproachGoal
extends Goal {
    private final PathfinderMob slug;
    private final double speedModifier;
    private final float approachDistance;
    private final Random random = new Random();
    private LivingEntity approachTarget;
    private int cooldown;
    private static final TagKey<EntityType<?>> SLUG_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("slugterra", "slug"));
    private static final SoundEvent SLUG_TAMED_SOUND = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("slugterra", "slug_tamed"));

    public FriendlyApproachGoal(PathfinderMob slug, double speedModifier, float approachDistance) {
        this.slug = slug;
        this.speedModifier = speedModifier;
        this.approachDistance = approachDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.cooldown = this.random.nextInt(100) + 100;
    }

    public boolean m_8036_() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        if (this.random.nextFloat() > 0.05f) {
            return false;
        }
        List potentialTargets = this.slug.m_9236_().m_6443_(LivingEntity.class, this.slug.m_20191_().m_82400_((double)this.approachDistance), this::isValidApproachTarget);
        if (!potentialTargets.isEmpty()) {
            this.approachTarget = (LivingEntity)potentialTargets.get(this.random.nextInt(potentialTargets.size()));
            return true;
        }
        return false;
    }

    private boolean isValidApproachTarget(LivingEntity entity) {
        if (entity instanceof Player) {
            return true;
        }
        if (entity.m_6095_().m_204039_(SLUG_TAG)) {
            return this.random.nextFloat() < 0.3f;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.approachTarget != null && this.approachTarget.m_6084_() && this.slug.m_20280_((Entity)this.approachTarget) > 2.25 && this.cooldown <= 0;
    }

    public void m_8056_() {
        this.slug.m_21573_().m_5624_((Entity)this.approachTarget, this.speedModifier);
    }

    public void m_8041_() {
        if (this.approachTarget != null && this.slug.m_20280_((Entity)this.approachTarget) <= 4.0) {
            this.slug.m_9236_().m_6263_(null, this.slug.m_20185_(), this.slug.m_20186_(), this.slug.m_20189_(), SLUG_TAMED_SOUND, SoundSource.NEUTRAL, 0.5f, 0.8f + this.random.nextFloat() * 0.4f);
        }
        this.approachTarget = null;
        this.cooldown = this.random.nextInt(200) + 100;
    }

    public void m_8037_() {
        if (this.approachTarget != null) {
            this.slug.m_21563_().m_24960_((Entity)this.approachTarget, 10.0f, 10.0f);
            if (this.slug.m_21573_().m_26571_() && this.slug.m_20280_((Entity)this.approachTarget) > 2.25) {
                this.slug.m_21573_().m_5624_((Entity)this.approachTarget, this.speedModifier);
            }
            if (this.slug.m_20280_((Entity)this.approachTarget) <= 9.0 && this.random.nextFloat() < 0.05f) {
                this.slug.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.slug.m_20208_(0.5), this.slug.m_20187_(), this.slug.m_20262_(0.5), 0.0, 0.1, 0.0);
            }
        }
    }
}

