/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.ai;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class SlugAmphibiousMoveGoal
extends RandomStrollGoal {
    private final int waterSearchRange;
    private final int landSearchRange;
    private int cooldown = 0;

    public SlugAmphibiousMoveGoal(PathfinderMob slug, double speed, int interval) {
        this(slug, speed, interval, 12, 15);
    }

    public SlugAmphibiousMoveGoal(PathfinderMob slug, double speed, int interval, int waterRange, int landRange) {
        super(slug, speed, interval, false);
        this.waterSearchRange = waterRange;
        this.landSearchRange = landRange;
    }

    public boolean m_8036_() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        if (this.f_25725_.m_21523_() || this.f_25725_.m_20202_() != null) {
            return false;
        }
        if (this.f_25725_.m_21573_().m_26571_()) {
            this.cooldown = 5;
            return true;
        }
        return false;
    }

    @Nullable
    protected Vec3 m_7037_() {
        Vec3 landPos;
        if (this.f_25725_.m_20072_()) {
            Vec3 surfacePos;
            if (this.f_25725_.m_217043_().m_188501_() < 0.3f && !this.isNearBottom(this.f_25725_) && (surfacePos = this.findSurfaceTarget()) != null) {
                return surfacePos;
            }
            Vec3 waterPos = this.findValidWaterPosition();
            if (waterPos != null) {
                return waterPos;
            }
        }
        if ((landPos = LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)this.landSearchRange, (int)7)) != null && this.isNearWater(BlockPos.m_274446_((Position)landPos))) {
            return landPos;
        }
        return landPos != null ? landPos : this.f_25725_.m_20182_();
    }

    @Nullable
    private Vec3 findValidWaterPosition() {
        for (int i = 0; i < 10; ++i) {
            Vec3 waterPos = DefaultRandomPos.m_148403_((PathfinderMob)this.f_25725_, (int)this.waterSearchRange, (int)7);
            if (waterPos == null || !this.f_25725_.m_9236_().m_6425_(BlockPos.m_274446_((Position)waterPos)).m_205070_(FluidTags.f_13131_)) continue;
            return waterPos;
        }
        return null;
    }

    @Nullable
    private Vec3 findSurfaceTarget() {
        BlockPos surfacePos = this.f_25725_.m_20183_();
        int attempts = 0;
        while (this.f_25725_.m_9236_().m_6425_(surfacePos).m_205070_(FluidTags.f_13131_) && attempts++ < 10) {
            surfacePos = surfacePos.m_7494_();
        }
        return attempts < 10 ? Vec3.m_82539_((Vec3i)surfacePos) : null;
    }

    private boolean isNearBottom(PathfinderMob mob) {
        for (int i = 1; i <= 3; ++i) {
            if (!mob.m_9236_().m_8055_(mob.m_20183_().m_6625_(i)).m_280296_()) continue;
            return true;
        }
        return false;
    }

    private boolean isNearWater(BlockPos pos) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (!this.f_25725_.m_9236_().m_6425_(pos.m_7918_(x, 0, z)).m_205070_(FluidTags.f_13131_)) continue;
                return true;
            }
        }
        return false;
    }
}

