/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class SlugFoodTheftGoal
extends Goal {
    private final PathfinderMob slug;
    private final double speed;
    private final float searchRange;
    private Player targetPlayer;
    private Vec3 fleePos;
    private boolean hasStolen;
    private final Random random = new Random();
    private static final TagKey<Item> SLUG_FOOD_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("slugterra", "slug_food"));

    public SlugFoodTheftGoal(PathfinderMob slug, double speed, float searchRange) {
        this.slug = slug;
        this.speed = speed;
        this.searchRange = searchRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.slug.m_20069_() || !this.slug.m_20096_()) {
            return false;
        }
        if (this.random.nextFloat() > 0.03f) {
            return false;
        }
        List players = this.slug.m_9236_().m_6443_(Player.class, this.slug.m_20191_().m_82400_((double)this.searchRange), this::hasSlugFoodInHand);
        if (!players.isEmpty()) {
            this.targetPlayer = (Player)players.get(0);
            return true;
        }
        return false;
    }

    private boolean hasSlugFoodInHand(Player player) {
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        return mainHand.m_204117_(SLUG_FOOD_TAG) || offHand.m_204117_(SLUG_FOOD_TAG);
    }

    public boolean m_8045_() {
        return this.targetPlayer != null && this.targetPlayer.m_6084_() && !this.hasStolen && this.slug.m_20280_((Entity)this.targetPlayer) < (double)(this.searchRange * this.searchRange);
    }

    public void m_8056_() {
        this.hasStolen = false;
        this.fleePos = null;
        this.slug.m_21573_().m_5624_((Entity)this.targetPlayer, this.speed * 0.8);
    }

    public void m_8037_() {
        if (this.targetPlayer == null) {
            return;
        }
        this.slug.m_21563_().m_24950_(this.targetPlayer.m_20185_(), this.targetPlayer.m_20186_() + (double)this.targetPlayer.m_20192_(), this.targetPlayer.m_20189_(), 10.0f, (float)this.slug.m_8132_());
        if (this.slug.m_20280_((Entity)this.targetPlayer) < 4.0 && !this.hasStolen) {
            this.attemptStealFood();
        }
    }

    private void attemptStealFood() {
        ItemStack mainHand = this.targetPlayer.m_21205_();
        ItemStack offHand = this.targetPlayer.m_21206_();
        if (mainHand.m_204117_(SLUG_FOOD_TAG)) {
            this.stealItem(mainHand);
        } else if (offHand.m_204117_(SLUG_FOOD_TAG)) {
            this.stealItem(offHand);
        }
        this.fleePos = LandRandomPos.m_148521_((PathfinderMob)this.slug, (int)10, (int)7, (Vec3)this.targetPlayer.m_20182_());
        if (this.fleePos != null) {
            this.slug.m_21573_().m_26519_(this.fleePos.f_82479_, this.fleePos.f_82480_, this.fleePos.f_82481_, this.speed * 1.0);
            this.hasStolen = true;
        }
    }

    private void stealItem(ItemStack stack) {
        stack.m_41774_(1);
        this.slug.m_5496_(SoundEvents.f_11912_, 0.5f + this.random.nextFloat() * 0.2f, 0.8f + this.random.nextFloat() * 0.4f);
        for (int i = 0; i < 5; ++i) {
            this.slug.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123754_, this.slug.m_20208_(0.5), this.slug.m_20187_() + 0.5, this.slug.m_20262_(0.5), 0.0, 0.1, 0.0);
        }
    }

    public void m_8041_() {
        this.targetPlayer = null;
        this.hasStolen = false;
        this.fleePos = null;
    }

    public boolean m_183429_() {
        return true;
    }
}

