/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.ai;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SlugHerdPanicGoal
extends Goal {
    protected final PathfinderMob slug;
    protected final double speed;
    protected double randPosX;
    protected double randPosY;
    protected double randPosZ;
    protected boolean isRunning;
    private long lastHurtTimestamp;

    public SlugHerdPanicGoal(PathfinderMob slug, double speed) {
        this.slug = slug;
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    private static TagKey<EntityType<?>> getSlugTag() {
        return TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("slugterra", "slug"));
    }

    public boolean m_8036_() {
        boolean wasHurt;
        if (this.isTamed(this.slug)) {
            return false;
        }
        boolean bl = wasHurt = this.slug.f_20916_ > 0;
        if (wasHurt && this.slug.m_21188_() != null && this.slug.m_21188_().m_6084_()) {
            BlockPos waterPos;
            this.lastHurtTimestamp = this.slug.m_9236_().m_46467_();
            if (this.slug.m_20069_() && !this.slug.m_20096_() && (waterPos = this.findNearbyWater((BlockGetter)this.slug.m_9236_(), (Entity)this.slug, 5, 4)) != null) {
                this.randPosX = waterPos.m_123341_();
                this.randPosY = waterPos.m_123342_();
                this.randPosZ = waterPos.m_123343_();
                return true;
            }
            List herd = this.slug.m_9236_().m_6443_(PathfinderMob.class, this.getHerdArea(), entity -> entity.m_6095_().m_204039_(SlugHerdPanicGoal.getSlugTag()) && !this.isTamed((PathfinderMob)entity));
            for (PathfinderMob otherSlug : herd) {
                if (otherSlug == this.slug || !otherSlug.m_142582_((Entity)this.slug)) continue;
                otherSlug.m_6703_(this.slug.m_21188_());
                if (!(otherSlug instanceof LivingEntity)) continue;
                otherSlug.f_20916_ = 10;
                otherSlug.f_21345_.m_25386_().filter(g -> g.m_26015_() instanceof SlugHerdPanicGoal).findFirst().ifPresent(g -> {
                    ((SlugHerdPanicGoal)g.m_26015_()).lastHurtTimestamp = otherSlug.m_9236_().m_46467_();
                });
            }
            return this.findFleePosition(this.slug.m_21188_());
        }
        return this.slug.m_9236_().m_46467_() - this.lastHurtTimestamp < 40L;
    }

    protected AABB getHerdArea() {
        double radius = 15.0;
        return new AABB(this.slug.m_20185_() - radius, this.slug.m_20186_() - radius, this.slug.m_20189_() - radius, this.slug.m_20185_() + radius, this.slug.m_20186_() + radius, this.slug.m_20189_() + radius);
    }

    private boolean findFleePosition(LivingEntity threat) {
        Vec3 fleePos = this.slug.m_20069_() ? DefaultRandomPos.m_148407_((PathfinderMob)this.slug, (int)16, (int)7, (Vec3)threat.m_20182_()) : LandRandomPos.m_148521_((PathfinderMob)this.slug, (int)16, (int)7, (Vec3)threat.m_20182_());
        if (fleePos != null) {
            this.randPosX = fleePos.f_82479_;
            this.randPosY = fleePos.f_82480_;
            this.randPosZ = fleePos.f_82481_;
            return true;
        }
        return false;
    }

    private boolean findRandomPosition() {
        Vec3 randomPos = LandRandomPos.m_148488_((PathfinderMob)this.slug, (int)5, (int)4);
        if (randomPos != null) {
            this.randPosX = randomPos.f_82479_;
            this.randPosY = randomPos.f_82480_;
            this.randPosZ = randomPos.f_82481_;
            return true;
        }
        return false;
    }

    public void m_8056_() {
        this.lastHurtTimestamp = this.slug.m_9236_().m_46467_();
        this.slug.m_21573_().m_26519_(this.randPosX, this.randPosY, this.randPosZ, this.speed);
        this.isRunning = true;
    }

    public void m_8041_() {
        this.isRunning = false;
    }

    public boolean m_8045_() {
        if (this.isTamed(this.slug)) {
            return false;
        }
        return !this.slug.m_21573_().m_26571_();
    }

    @Nullable
    protected BlockPos findNearbyWater(BlockGetter world, Entity entity, int horizontalRange, int verticalRange) {
        BlockPos center = entity.m_20183_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        BlockPos closestWater = null;
        float closestDistance = Float.MAX_VALUE;
        for (int x = -horizontalRange; x <= horizontalRange; ++x) {
            for (int y = -verticalRange; y <= verticalRange; ++y) {
                for (int z = -horizontalRange; z <= horizontalRange; ++z) {
                    float distance;
                    mutablePos.m_122178_(center.m_123341_() + x, center.m_123342_() + y, center.m_123343_() + z);
                    if (!world.m_6425_((BlockPos)mutablePos).m_205070_(FluidTags.f_13131_) || !((distance = (float)center.m_123331_((Vec3i)mutablePos)) < closestDistance)) continue;
                    closestDistance = distance;
                    closestWater = mutablePos.m_7949_();
                }
            }
        }
        return closestWater;
    }

    private boolean isTamed(PathfinderMob slug) {
        return slug instanceof TamableAnimal && ((TamableAnimal)slug).m_21824_();
    }
}

