/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class SlugMockingGoal
extends Goal {
    private final PathfinderMob slug;
    private final double speed;
    private final float mockRange;
    private Player targetPlayer;
    private int mockTimer;
    private int cooldown;
    private boolean hasMocked;
    private Vec3 fleePos;
    private final Random random = new Random();
    private static final SoundEvent MOCK_SOUND = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("slugterra", "slug_fail"));

    public SlugMockingGoal(PathfinderMob slug, double speed, float mockRange) {
        this.slug = slug;
        this.speed = speed;
        this.mockRange = mockRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.cooldown = this.random.nextInt(100) + 100;
    }

    public boolean m_8036_() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        if (this.random.nextFloat() > 0.02f) {
            return false;
        }
        List players = this.slug.m_9236_().m_6443_(Player.class, this.slug.m_20191_().m_82400_((double)this.mockRange), this::isValidMockTarget);
        if (!players.isEmpty()) {
            this.targetPlayer = (Player)players.get(0);
            this.hasMocked = false;
            this.mockTimer = 0;
            return true;
        }
        return false;
    }

    private boolean isValidMockTarget(Player player) {
        return !(this.slug instanceof TamableAnimal) || !((TamableAnimal)this.slug).m_21830_((LivingEntity)player);
    }

    public boolean m_8045_() {
        return this.targetPlayer != null && this.targetPlayer.m_6084_() && (!this.hasMocked || this.slug.m_20280_((Entity)this.targetPlayer) < (double)(this.mockRange * this.mockRange * 4.0f));
    }

    public void m_8056_() {
        this.fleePos = null;
        this.slug.m_21573_().m_5624_((Entity)this.targetPlayer, this.speed * 0.8);
    }

    public void m_8037_() {
        if (this.targetPlayer == null) {
            return;
        }
        this.slug.m_21563_().m_24960_((Entity)this.targetPlayer, 10.0f, (float)this.slug.m_8132_());
        if (!this.hasMocked) {
            if (this.slug.m_20280_((Entity)this.targetPlayer) < 4.0) {
                ++this.mockTimer;
                if (this.mockTimer >= 20) {
                    this.playMockSound();
                    this.hasMocked = true;
                    this.findFleePosition();
                }
            } else {
                this.slug.m_21573_().m_5624_((Entity)this.targetPlayer, this.speed * 0.8);
            }
        } else if (this.fleePos != null) {
            this.slug.m_21573_().m_26519_(this.fleePos.f_82479_, this.fleePos.f_82480_, this.fleePos.f_82481_, this.speed * 1.3);
        }
    }

    private void playMockSound() {
        this.slug.m_9236_().m_6263_(null, this.slug.m_20185_(), this.slug.m_20186_(), this.slug.m_20189_(), MOCK_SOUND, SoundSource.NEUTRAL, 0.5f + this.random.nextFloat() * 0.3f, 0.8f + this.random.nextFloat() * 0.4f);
    }

    private void findFleePosition() {
        this.fleePos = LandRandomPos.m_148521_((PathfinderMob)this.slug, (int)10, (int)7, (Vec3)this.targetPlayer.m_20182_());
    }

    public void m_8041_() {
        this.targetPlayer = null;
        this.hasMocked = false;
        this.cooldown = 100 + this.random.nextInt(200);
    }

    public boolean m_183429_() {
        return true;
    }
}

