/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.block;

import falconnex.legendsofslugterra.init.SlugterraModBlocks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;

public class RockyFarmlandBlock
extends Block {
    public static final IntegerProperty MOISTURE = IntegerProperty.m_61631_((String)"moisture", (int)0, (int)7);
    public static final IntegerProperty BLOCKSTATE = IntegerProperty.m_61631_((String)"blockstate", (int)0, (int)1);

    public RockyFarmlandBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56739_).m_60913_(1.0f, 10.0f).m_60977_().m_60953_(s -> 10).m_60924_((bs, br, bp) -> false));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(0))).m_61124_((Property)BLOCKSTATE, (Comparable)Integer.valueOf(0)));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 15;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return RockyFarmlandBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return RockyFarmlandBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MOISTURE, BLOCKSTATE});
    }

    private boolean hasWaterNearby(LevelReader world, BlockPos pos) {
        for (BlockPos nearbyPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-4, 0, -4), (BlockPos)pos.m_7918_(4, 1, 4))) {
            if (!world.m_6425_(nearbyPos).m_205070_(FluidTags.f_13131_)) continue;
            return true;
        }
        return false;
    }

    private void convertToRockyDirt(Level world, BlockPos pos, BlockState oldState) {
        List entities = world.m_45933_(null, new AABB((double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 2), (double)(pos.m_123343_() + 1)));
        world.m_7731_(pos, ((Block)SlugterraModBlocks.ROCKY_DIRT.get()).m_49966_(), 3);
        if (!world.m_5776_()) {
            for (Entity entity : entities) {
                if (!(entity instanceof LivingEntity)) continue;
                entity.m_6021_(entity.m_20185_(), (double)pos.m_123342_() + 1.01, entity.m_20189_());
            }
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)oldState));
        }
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        boolean hasWater;
        BlockPos abovePos = pos.m_7494_();
        BlockState aboveState = world.m_8055_(abovePos);
        if (!aboveState.m_60795_() && aboveState.m_60815_()) {
            this.convertToRockyDirt((Level)world, pos, state);
            return;
        }
        int moisture = (Integer)state.m_61143_((Property)MOISTURE);
        int blockState = (Integer)state.m_61143_((Property)BLOCKSTATE);
        boolean bl = hasWater = this.hasWaterNearby((LevelReader)world, pos) || world.m_46758_(pos.m_7494_());
        if (!hasWater && !world.m_46471_()) {
            if (moisture > 0) {
                int newMoisture = moisture - 1;
                int newBlockState = newMoisture <= 0 ? 0 : blockState;
                world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(newMoisture))).m_61124_((Property)BLOCKSTATE, (Comparable)Integer.valueOf(newBlockState)), 2);
            } else {
                this.convertToRockyDirt((Level)world, pos, state);
            }
        } else if (hasWater && moisture < 7) {
            world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(7))).m_61124_((Property)BLOCKSTATE, (Comparable)Integer.valueOf(1)), 2);
        }
        if ((Integer)state.m_61143_((Property)MOISTURE) > 0 && aboveState.m_60795_()) {
            BlockPos cropPos = pos.m_7494_();
            BlockState cropState = world.m_8055_(cropPos);
            Block block = cropState.m_60734_();
            if (block instanceof BonemealableBlock) {
                BonemealableBlock growable = (BonemealableBlock)block;
                if (growable.m_7370_((LevelReader)world, cropPos, cropState, false) && random.m_188503_(5) == 0) {
                    growable.m_214148_(world, random, cropPos, cropState);
                }
            } else {
                block = cropState.m_60734_();
                if (block instanceof StemBlock) {
                    StemBlock stem = (StemBlock)block;
                    int age = (Integer)cropState.m_61143_((Property)StemBlock.f_57013_);
                    if (age < 7 && random.m_188503_(5) == 0) {
                        world.m_7731_(cropPos, (BlockState)cropState.m_61124_((Property)StemBlock.f_57013_, (Comparable)Integer.valueOf(age + 1)), 2);
                    }
                }
            }
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean isMoving) {
        BlockState aboveState;
        super.m_6861_(state, world, pos, neighborBlock, neighborPos, isMoving);
        if (neighborPos.equals((Object)pos.m_7494_()) && !(aboveState = world.m_8055_(pos.m_7494_())).m_60795_() && aboveState.m_60815_()) {
            world.m_7731_(pos, ((Block)SlugterraModBlocks.ROCKY_DIRT.get()).m_49966_(), 3);
        }
    }

    protected static float getGrowthSpeed(Block block, BlockGetter world, BlockPos pos) {
        float speed = 1.0f;
        BlockPos belowPos = pos.m_7495_();
        BlockState farmland = world.m_8055_(belowPos);
        if (farmland.m_60734_() instanceof RockyFarmlandBlock) {
            speed *= (float)((Integer)farmland.m_61143_((Property)MOISTURE)).intValue() / 7.0f * 3.0f;
        }
        return speed;
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!world.f_46443_ && entity instanceof LivingEntity && fallDistance > 1.0f) {
            entity.m_6021_(entity.m_20185_(), (double)pos.m_123342_() + 1.5, entity.m_20189_());
            this.convertToRockyDirt(world, pos, state);
        }
        super.m_142072_(world, state, pos, entity, fallDistance);
    }

    public boolean isFertile(BlockState state, BlockGetter world, BlockPos pos) {
        return (Integer)state.m_61143_((Property)MOISTURE) > 0;
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction direction, IPlantable plantable) {
        if (direction != Direction.UP) {
            return false;
        }
        BlockState plantState = plantable.getPlant(world, pos);
        Block plantBlock = plantState.m_60734_();
        if (plantBlock == SlugterraModBlocks.PINK_BARLEY_CROP.get()) {
            return true;
        }
        if (plantBlock instanceof CropBlock || plantBlock instanceof StemBlock || plantBlock instanceof AttachedStemBlock) {
            return true;
        }
        return plantBlock instanceof IPlantable;
    }
}

