/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.block;

import falconnex.legendsofslugterra.init.SlugterraModBlocks;
import falconnex.legendsofslugterra.procedures.RockyGrassDecayProcedure;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class RockyGrassBlock
extends Block
implements BonemealableBlock {
    private static final Map<String, List<String>> BIOME_PLANTS = new HashMap<String, List<String>>();

    public RockyGrassBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56739_).m_60913_(0.6f, 0.6f).m_60977_());
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public void m_213897_(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(blockstate, world, pos, random);
        RockyGrassDecayProcedure.execute((LevelAccessor)world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return world.m_46859_(pos.m_7494_());
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos abovePos = pos.m_7494_();
        if (world.m_46859_(abovePos)) {
            String plantId;
            BlockState plantState;
            Holder biomeHolder = world.m_204166_(pos);
            String biomeName = biomeHolder.m_203543_().map(key -> key.m_135782_().toString()).orElse("");
            List plants = BIOME_PLANTS.getOrDefault(biomeName, Collections.emptyList());
            if (!plants.isEmpty() && (plantState = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(plantId = (String)plants.get(random.m_188503_(plants.size()))))).m_49966_()) != null && plantState.m_60710_((LevelReader)world, abovePos)) {
                world.m_7731_(abovePos, plantState, 3);
            }
            this.spreadPlants(world, random, pos, biomeName);
        }
    }

    private void spreadPlants(ServerLevel world, RandomSource random, BlockPos centerPos, String biomeName) {
        int radius = 3;
        int attempts = 8;
        for (int i = 0; i < attempts; ++i) {
            String plantId;
            BlockState plantState;
            List plants;
            BlockPos targetPos = centerPos.m_7918_(random.m_188503_(radius * 2 + 1) - radius, 0, random.m_188503_(radius * 2 + 1) - radius);
            if (!world.m_46859_(targetPos.m_7494_()) || !this.isValidFloor(world.m_8055_(targetPos)) || (plants = BIOME_PLANTS.getOrDefault(biomeName, Collections.emptyList())).isEmpty() || (plantState = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(plantId = (String)plants.get(random.m_188503_(plants.size()))))).m_49966_()) == null || !plantState.m_60710_((LevelReader)world, targetPos.m_7494_())) continue;
            world.m_7731_(targetPos.m_7494_(), plantState, 3);
        }
    }

    private boolean isValidFloor(BlockState state) {
        return state.m_60713_((Block)SlugterraModBlocks.ROCKY_GRASS.get()) || state.m_60713_((Block)SlugterraModBlocks.ROCKY_DIRT.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void blockColorLoad(RegisterColorHandlersEvent.Block event) {
        event.getBlockColors().m_92589_((bs, world, pos, index) -> world != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0), new Block[]{(Block)SlugterraModBlocks.ROCKY_GRASS.get()});
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void itemColorLoad(RegisterColorHandlersEvent.Item event) {
        event.getItemColors().m_92689_((stack, index) -> GrassColor.m_46415_((double)0.5, (double)1.0), new ItemLike[]{(ItemLike)SlugterraModBlocks.ROCKY_GRASS.get()});
    }

    static {
        BIOME_PLANTS.put("slugterra:cavern", Arrays.asList("slugterra:small_blue_glowshroom", "slugterra:small_glowshroom", "slugterra:tiny_shroom", "slugterra:lumino_fern", "slugterra:lumino_grass", "slugterra:poison_shroom", "slugterra:big_poison_shroom", "slugterra:terran_bush"));
        BIOME_PLANTS.put("slugterra:arachna_cavern", Arrays.asList("slugterra:orange_neonia_small", "slugterra:orange_neonia"));
        BIOME_PLANTS.put("slugterra:arid_cavern", Arrays.asList("slugterra:dry_fern", "slugterra:thin_cactie", "minecraft:dead_bush", "minecraft:cactus"));
        BIOME_PLANTS.put("slugterra:azure_forest_cavern", Arrays.asList("slugterra:terran_bush", "slugterra:lumino_fern", "slugterra:lumino_grass", "slugterra:tiny_shroom", "slugterra:small_glowshroom", "slugterra:small_blue_glowshroom", "slugterra:poison_shroom", "slugterra:big_poison_shroom", "slugterra:bright_glowshroom", "slugterra:azuria"));
        BIOME_PLANTS.put("slugterra:brightworm_cavern", Arrays.asList("slugterra:small_glowshroom", "slugterra:small_blue_glowshroom", "slugterra:bright_glowshroom"));
        BIOME_PLANTS.put("slugterra:grandmaster_cavern", Arrays.asList("slugterra:lumino_fern", "slugterra:pine_tallshroom", "slugterra:scarlet_sage", "minecraft:bamboo"));
        BIOME_PLANTS.put("slugterra:igneous_cavern", Arrays.asList("slugterra:lime_neonia"));
        BIOME_PLANTS.put("slugterra:snowdance_cavern", Arrays.asList("slugterra:blooming_bulbs"));
        BIOME_PLANTS.put("slugterra:spectro_cavern", Arrays.asList("slugterra:purple_neonia", "slugterra:lumino_shroom", "slugterra:dark_grass"));
    }
}

