/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.entity;

import falconnex.legendsofslugterra.EntityDespawnHandler;
import falconnex.legendsofslugterra.SlugWanderGoal;
import falconnex.legendsofslugterra.ThuggletChangeGoal;
import falconnex.legendsofslugterra.ai.SlugAmphibiousMoveGoal;
import falconnex.legendsofslugterra.ai.SlugAquaticMoveController;
import falconnex.legendsofslugterra.ai.SlugHerdPanicGoal;
import falconnex.legendsofslugterra.ai.SlugLeaveWaterGoal;
import falconnex.legendsofslugterra.ai.TravelToWaterGoal;
import falconnex.legendsofslugterra.entity.ai.AvoidTamedSlugHoundGoal;
import falconnex.legendsofslugterra.init.SlugterraModEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AquabeekEntity
extends TamableAnimal
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(AquabeekEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(AquabeekEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(AquabeekEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> DATA_Damage = SynchedEntityData.m_135353_(AquabeekEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_Knockback = SynchedEntityData.m_135353_(AquabeekEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_Speed = SynchedEntityData.m_135353_(AquabeekEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    private boolean isSwimming = false;
    private boolean wasSwimming = false;
    private int ticksSinceInWater = 0;
    String prevAnim = "empty";

    public AquabeekEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<AquabeekEntity>)((EntityType)SlugterraModEntities.AQUABEEK.get()), world);
    }

    public AquabeekEntity(EntityType<AquabeekEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_274367_(0.6f);
        this.switchNavigator(false);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"aquabeek");
        this.f_19804_.m_135372_(DATA_Damage, (Object)0);
        this.f_19804_.m_135372_(DATA_Knockback, (Object)0);
        this.f_19804_.m_135372_(DATA_Speed, (Object)1);
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new AvoidTamedSlugHoundGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new SlugWanderGoal(this, 0.6));
        this.f_21345_.m_25352_(2, (Goal)new SlugAmphibiousMoveGoal((PathfinderMob)this, 0.6, 100, 15, 12));
        this.f_21345_.m_25352_(5, (Goal)new SlugHerdPanicGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new TravelToWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(6, (Goal)new SlugLeaveWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new ThuggletChangeGoal(this));
    }

    protected PathNavigation m_6037_(Level world) {
        return new AmphibiousPathNavigation((Mob)this, world);
    }

    protected void m_6119_() {
        super.m_6119_();
        this.f_21342_ = this.m_20072_() ? new SlugAquaticMoveController((PathfinderMob)this, 1.0f) : new MoveControl((Mob)this);
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slugidle"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slughurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slugdeath"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
        compound.m_128405_("DataDamage", ((Integer)this.f_19804_.m_135370_(DATA_Damage)).intValue());
        compound.m_128405_("DataKnockback", ((Integer)this.f_19804_.m_135370_(DATA_Knockback)).intValue());
        compound.m_128405_("DataSpeed", ((Integer)this.f_19804_.m_135370_(DATA_Speed)).intValue());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
        if (compound.m_128441_("DataDamage")) {
            this.f_19804_.m_135381_(DATA_Damage, (Object)compound.m_128451_("DataDamage"));
        }
        if (compound.m_128441_("DataKnockback")) {
            this.f_19804_.m_135381_(DATA_Knockback, (Object)compound.m_128451_("DataKnockback"));
        }
        if (compound.m_128441_("DataSpeed")) {
            this.f_19804_.m_135381_(DATA_Speed, (Object)compound.m_128451_("DataSpeed"));
        }
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.m_21120_(hand);
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        Item item = itemstack.m_41720_();
        if (itemstack.m_41720_() instanceof SpawnEggItem) {
            retval = super.m_6071_(sourceentity, hand);
        } else if (this.m_9236_().m_5776_()) {
            retval = this.m_21824_() && this.m_21830_((LivingEntity)sourceentity) || this.m_6898_(itemstack) ? InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_()) : InteractionResult.PASS;
        } else if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)sourceentity)) {
                if (item.m_41472_() && this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(item.m_41473_().m_38744_());
                    retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                } else if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(4.0f);
                    retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                } else {
                    retval = super.m_6071_(sourceentity, hand);
                }
            }
        } else if (this.m_6898_(itemstack)) {
            this.m_142075_(sourceentity, hand, itemstack);
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.m_21828_(sourceentity);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
                this.m_21530_();
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        } else {
            retval = super.m_6071_(sourceentity, hand);
        }
        return retval;
    }

    public void m_6043_() {
        EntityDespawnHandler.handleDespawn((Mob)this);
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_20072_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    private boolean shouldSurface() {
        return this.m_20146_() < 100 && !this.isNearBottom();
    }

    private boolean isNearBottom() {
        for (int i = 1; i < 3; ++i) {
            if (!this.m_9236_().m_8055_(this.m_20183_().m_6625_(i)).m_280296_()) continue;
            return true;
        }
        return false;
    }

    private boolean isNearSurface() {
        return !this.m_9236_().m_6425_(this.m_20183_().m_7494_()).m_76178_();
    }

    public int m_6062_() {
        return 400;
    }

    protected int m_7305_(int currentAir) {
        return this.m_6062_();
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.0f);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        AquabeekEntity retval = (AquabeekEntity)((EntityType)SlugterraModEntities.AQUABEEK.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return List.of().contains(stack.m_41720_());
    }

    public void m_8107_() {
        super.m_8107_();
        this.isSwimming = this.m_20072_();
        if (this.isSwimming && this.m_217043_().m_188501_() < 0.01f) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.m_217043_().m_188501_() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.m_217043_().m_188501_() * 2.0f - 1.0f) * 0.2f)));
        }
        if (this.isSwimming != this.wasSwimming) {
            this.switchNavigator(this.isSwimming);
            this.wasSwimming = this.isSwimming;
        }
    }

    private void switchNavigator(boolean waterNavigation) {
        if (waterNavigation) {
            this.f_21344_ = new WaterBoundPathNavigation((Mob)this, this.m_9236_());
            this.f_21342_ = new SlugAquaticMoveController((PathfinderMob)this, 1.0f);
        } else {
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
            this.f_21342_ = new MoveControl((Mob)this);
        }
    }

    public boolean m_6063_() {
        return false;
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22279_, 0.25).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 0.5).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22288_, 0.5);
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (this.isSwimming) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.Aquabeek.swim"));
            }
            if (event.isMoving() || !(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.NormalSlug.walking"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.NormalSlug.idle"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.m_20185_() - this.f_19790_;
        double d0 = this.m_20189_() - this.f_19792_;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.m_21324_(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.m_9236_().m_46467_();
        }
        if (this.swinging && this.lastSwing + 7L <= this.m_9236_().m_46467_()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.NormalSlug.attack"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 4, this::attackingPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private static class AmphibiousPathNavigation
    extends GroundPathNavigation {
        public AmphibiousPathNavigation(Mob mob, Level level) {
            super(mob, level);
        }

        protected boolean m_7632_() {
            return true;
        }

        public boolean m_6342_(BlockPos pos) {
            return this.f_26495_.m_8055_(pos).m_280296_() || this.f_26495_.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        }
    }
}

