/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.entity;

import falconnex.legendsofslugterra.EntityDespawnHandler;
import falconnex.legendsofslugterra.SlugStorage;
import falconnex.legendsofslugterra.SlugWanderGoal;
import falconnex.legendsofslugterra.ThuggletChangeGoal;
import falconnex.legendsofslugterra.ai.SlugHerdPanicGoal;
import falconnex.legendsofslugterra.entity.ai.AvoidTamedSlugHoundGoal;
import falconnex.legendsofslugterra.init.SlugterraModEntities;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ArmasheltEntity
extends TamableAnimal
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(ArmasheltEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(ArmasheltEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(ArmasheltEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> DATA_Damage = SynchedEntityData.m_135353_(ArmasheltEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_Knockback = SynchedEntityData.m_135353_(ArmasheltEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_Speed = SynchedEntityData.m_135353_(ArmasheltEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(ArmasheltEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> CHARGING_ENABLED = SynchedEntityData.m_135353_(ArmasheltEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    private int chargeCooldown;
    private ArmasheltEntity chargePartner;
    private boolean hasChargedSpeed;
    String prevAnim = "empty";

    public ArmasheltEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<ArmasheltEntity>)((EntityType)SlugterraModEntities.ARMASHELT.get()), world);
    }

    public ArmasheltEntity(EntityType<ArmasheltEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_274367_(0.6f);
        this.chargeCooldown = this.f_19796_.m_188503_(1000);
        this.hasChargedSpeed = false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"armashelttexture");
        this.f_19804_.m_135372_(DATA_Damage, (Object)0);
        this.f_19804_.m_135372_(DATA_Knockback, (Object)1);
        this.f_19804_.m_135372_(DATA_Speed, (Object)1);
        this.f_19804_.m_135372_(CHARGING, (Object)false);
        this.f_19804_.m_135372_(CHARGING_ENABLED, (Object)true);
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.f_19804_.m_135381_(CHARGING, (Object)charging);
    }

    public boolean isChargingEnabled() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING_ENABLED);
    }

    public void setChargingEnabled(boolean enabled) {
        this.f_19804_.m_135381_(CHARGING_ENABLED, (Object)enabled);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new AvoidTamedSlugHoundGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new SlugWanderGoal(this, 0.6));
        this.f_21345_.m_25352_(2, (Goal)new SlugHerdPanicGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new ArmasheltChargeGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new ThuggletChangeGoal(this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slugidle"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slughurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slugdeath"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
        compound.m_128405_("DataDamage", ((Integer)this.f_19804_.m_135370_(DATA_Damage)).intValue());
        compound.m_128405_("DataKnockback", ((Integer)this.f_19804_.m_135370_(DATA_Knockback)).intValue());
        compound.m_128405_("DataSpeed", ((Integer)this.f_19804_.m_135370_(DATA_Speed)).intValue());
        compound.m_128379_("Charging", this.isCharging());
        compound.m_128379_("ChargingEnabled", this.isChargingEnabled());
        compound.m_128405_("ChargeCooldown", this.chargeCooldown);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
        if (compound.m_128441_("DataDamage")) {
            this.f_19804_.m_135381_(DATA_Damage, (Object)compound.m_128451_("DataDamage"));
        }
        if (compound.m_128441_("DataKnockback")) {
            this.f_19804_.m_135381_(DATA_Knockback, (Object)compound.m_128451_("DataKnockback"));
        }
        if (compound.m_128441_("DataSpeed")) {
            this.f_19804_.m_135381_(DATA_Speed, (Object)compound.m_128451_("DataSpeed"));
        }
        if (compound.m_128441_("Charging")) {
            this.setCharging(compound.m_128471_("Charging"));
        }
        if (compound.m_128441_("ChargingEnabled")) {
            this.setChargingEnabled(compound.m_128471_("ChargingEnabled"));
        }
        if (compound.m_128441_("ChargeCooldown")) {
            this.chargeCooldown = compound.m_128451_("ChargeCooldown");
        }
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.m_21120_(hand);
        InteractionResult superResult = super.m_6071_(sourceentity, hand);
        if (superResult.m_19077_()) {
            return superResult;
        }
        if (itemstack.m_41619_() && hand == InteractionHand.MAIN_HAND && this.m_21824_() && this.m_21830_((LivingEntity)sourceentity)) {
            ResourceLocation sound;
            boolean newState = !this.isChargingEnabled();
            this.setChargingEnabled(newState);
            ResourceLocation resourceLocation = sound = newState ? new ResourceLocation("slugterra:slug_tamed") : new ResourceLocation("slugterra:slug_fail");
            if (!this.m_9236_().m_5776_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(sound), SoundSource.NEUTRAL, 0.5f, 1.0f);
                String message = newState ? "Armashelt charging enabled" : "Armashelt charging disabled";
                sourceentity.m_5661_((Component)Component.m_237113_((String)message), true);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (itemstack.m_41720_() instanceof SpawnEggItem) {
            return super.m_6071_(sourceentity, hand);
        }
        if (this.m_6898_(itemstack)) {
            if (this.m_21223_() < this.m_21233_()) {
                this.m_142075_(sourceentity, hand, itemstack);
                this.m_5634_(this.m_21824_() ? 4.0f : 2.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            if (!this.m_21824_() && this.f_19796_.m_188503_(3) == 0) {
                this.m_142075_(sourceentity, hand, itemstack);
                if (!ForgeEventFactory.onAnimalTame((Animal)this, (Player)sourceentity)) {
                    this.m_21828_(sourceentity);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return InteractionResult.PASS;
    }

    public void m_6043_() {
        EntityDespawnHandler.handleDespawn((Mob)this);
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
        if (!this.m_9236_().m_5776_()) {
            if (this.chargeCooldown > 0) {
                --this.chargeCooldown;
            }
            if (this.isCharging()) {
                if (!this.hasChargedSpeed) {
                    this.m_21051_(Attributes.f_22279_).m_22100_(0.35);
                    this.hasChargedSpeed = true;
                }
            } else if (this.hasChargedSpeed) {
                this.m_21051_(Attributes.f_22279_).m_22100_(0.25);
                this.hasChargedSpeed = false;
            }
            if (this.m_21223_() < this.m_21233_() / 2.0f) {
                this.setCharging(false);
                this.chargePartner = null;
            }
        }
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.0f);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        ArmasheltEntity retval = (ArmasheltEntity)((EntityType)SlugterraModEntities.ARMASHELT.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return List.of().contains(stack.m_41720_());
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 10.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (event.isMoving() || !(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.NormalSlug.walking"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.NormalSlug.idle"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.m_20185_() - this.f_19790_;
        double d0 = this.m_20189_() - this.f_19792_;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.m_21324_(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.m_9236_().m_46467_();
        }
        if (this.swinging && this.lastSwing + 7L <= this.m_9236_().m_46467_()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.NormalSlug.attack"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 4, this::attackingPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private boolean isValidCharging() {
        return this.m_6084_() && !this.m_6162_() && this.chargeCooldown == 0 && this.isChargingEnabled() && this.m_21223_() >= this.m_21233_() / 2.0f;
    }

    private void pushBackJostling(ArmasheltEntity other, float strength) {
        this.applyKnockbackFromBuffalo(strength, other.m_20185_() - this.m_20185_(), other.m_20189_() - this.m_20189_());
    }

    private void applyKnockbackFromBuffalo(float strength, double ratioX, double ratioZ) {
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)this, (float)strength, (double)ratioX, (double)ratioZ);
        if (!event.isCanceled()) {
            strength = event.getStrength();
            ratioX = event.getRatioX();
            ratioZ = event.getRatioZ();
            if (!(strength <= 0.0f)) {
                this.m_20334_(this.m_20184_().f_82479_ / 2.0 - ratioX * (double)strength, 0.3, this.m_20184_().f_82481_ / 2.0 - ratioZ * (double)strength);
            }
        }
    }

    private void resetChargeCooldown() {
        this.setCharging(false);
        this.chargePartner = null;
        this.chargeCooldown = 1000 + this.f_19796_.m_188503_(2000);
    }

    private static class ArmasheltChargeGoal
    extends Goal {
        private final ArmasheltEntity armashelt;
        private int chargeCheckCooldown = 0;

        public ArmasheltChargeGoal(ArmasheltEntity armashelt) {
            this.armashelt = armashelt;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            ArmasheltEntity entity = this.armashelt;
            CompoundTag entityData = entity.getPersistentData();
            CompoundTag entityVariables = SlugStorage.GetEntityVariables(entityData);
            if (entityVariables.m_128441_("Thugglet")) {
                return false;
            }
            if (this.chargeCheckCooldown > 0) {
                --this.chargeCheckCooldown;
                return false;
            }
            if (!this.armashelt.isValidCharging()) {
                this.chargeCheckCooldown = 60;
                return false;
            }
            if (!this.armashelt.m_21824_()) {
                this.armashelt.setChargingEnabled(true);
            }
            if (this.armashelt.chargePartner != null && this.armashelt.chargePartner.m_6084_() && this.armashelt.chargePartner.isValidCharging() && this.armashelt.chargePartner != this.armashelt) {
                return true;
            }
            this.chargeCheckCooldown = 100;
            if (this.armashelt.f_19796_.m_188503_(2) == 0) {
                ArmasheltEntity target = null;
                double closestDistance = Double.MAX_VALUE;
                for (ArmasheltEntity other : this.armashelt.m_9236_().m_6443_(ArmasheltEntity.class, this.armashelt.m_20191_().m_82400_(8.0), e -> e != this.armashelt && e.isValidCharging() && e.isChargingEnabled())) {
                    double distance = this.armashelt.m_20280_((Entity)other);
                    if (!(distance < closestDistance)) continue;
                    target = other;
                    closestDistance = distance;
                }
                if (target != null) {
                    this.armashelt.chargePartner = target;
                    return true;
                }
            }
            return false;
        }

        public boolean m_8045_() {
            return this.armashelt.isValidCharging() && this.armashelt.chargePartner != null && this.armashelt.chargePartner.m_6084_() && this.armashelt.chargePartner.isValidCharging() && this.armashelt.chargePartner.isChargingEnabled() && this.armashelt.m_20280_((Entity)this.armashelt.chargePartner) < 64.0;
        }

        public void m_8056_() {
            this.armashelt.m_21573_().m_26573_();
            if (this.armashelt.chargePartner != null) {
                this.armashelt.m_21391_((Entity)this.armashelt.chargePartner, 30.0f, 30.0f);
            }
            this.armashelt.setCharging(true);
            this.armashelt.m_21051_(Attributes.f_22279_).m_22100_(0.3);
        }

        public void m_8037_() {
            if (this.armashelt.chargePartner == null || !this.armashelt.chargePartner.m_6084_()) {
                this.armashelt.resetChargeCooldown();
                return;
            }
            this.armashelt.m_21391_((Entity)this.armashelt.chargePartner, 30.0f, 30.0f);
            this.armashelt.m_21573_().m_5624_((Entity)this.armashelt.chargePartner, 1.2);
            float distance = this.armashelt.m_20270_((Entity)this.armashelt.chargePartner);
            float attackRange = this.armashelt.m_20205_() + 0.5f;
            if (this.armashelt.m_142582_((Entity)this.armashelt.chargePartner) && distance < attackRange) {
                this.armashelt.chargePartner.m_6469_(this.armashelt.m_269291_().m_269333_((LivingEntity)this.armashelt), 0.5f);
                this.armashelt.m_6469_(this.armashelt.m_269291_().m_269333_((LivingEntity)this.armashelt.chargePartner), 0.5f);
                this.armashelt.pushBackJostling(this.armashelt.chargePartner, 0.15f);
                if (this.armashelt.chargePartner != null) {
                    this.armashelt.chargePartner.pushBackJostling(this.armashelt, 0.25f);
                }
                this.armashelt.chargeCooldown = 100 + this.armashelt.f_19796_.m_188503_(100);
                if (this.armashelt.chargePartner != null) {
                    this.armashelt.chargePartner.chargeCooldown = 100 + this.armashelt.f_19796_.m_188503_(100);
                }
                this.armashelt.chargePartner = null;
                this.armashelt.m_9236_().m_6263_(null, this.armashelt.m_20185_(), this.armashelt.m_20186_(), this.armashelt.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:small_generic_impact")), SoundSource.NEUTRAL, 0.5f, 1.0f);
            }
        }

        public void m_8041_() {
            this.armashelt.setCharging(false);
            this.armashelt.chargePartner = null;
            this.armashelt.m_21051_(Attributes.f_22279_).m_22100_(0.25);
        }
    }
}

