/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.entity;

import falconnex.legendsofslugterra.init.SlugterraModEntities;
import falconnex.legendsofslugterra.init.SlugterraModMobEffects;
import falconnex.legendsofslugterra.network.SlugterraModVariables;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

@Mod.EventBusSubscriber
public class BubbaleoneVelocimorphEntity
extends TamableAnimal
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(BubbaleoneVelocimorphEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(BubbaleoneVelocimorphEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(BubbaleoneVelocimorphEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> CARRYING_OWNER = SynchedEntityData.m_135353_(BubbaleoneVelocimorphEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> CARRYING_ENTITY = SynchedEntityData.m_135353_(BubbaleoneVelocimorphEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    private float currentScale = 1.0f;
    private static final int MAX_AIR_TIME = 160;
    private static final int SLUGGY_DURATION = 500;
    private static final int OCCLUSION_CHECK_THRESHOLD = 80;
    private static final int CATCH_GRACE_PERIOD = 10;
    private static final Map<String, Float> SPECIAL_SCALE_ADJUSTMENTS = new HashMap<String, Float>(){
        {
            this.put("minecraft:ghast", Float.valueOf(6.0f));
            this.put("minecraft:iron_golem", Float.valueOf(2.6f));
            this.put("slugterra:slug_hound", Float.valueOf(2.0f));
            this.put("slugterra:ice_ogre", Float.valueOf(2.6f));
            this.put("slugterra:cavern_crawler", Float.valueOf(1.2f));
        }
    };
    private static final Map<String, Float> SPECIAL_OFFSET_ADJUSTMENTS = new HashMap<String, Float>(){
        {
            this.put("minecraft:ghast", Float.valueOf(-1.2f));
            this.put("minecraft:iron_golem", Float.valueOf(-1.8f));
            this.put("slugterra:slug_hound", Float.valueOf(-1.3f));
            this.put("slugterra:ice_ogre", Float.valueOf(-1.9f));
            this.put("slugterra:cavern_crawler", Float.valueOf(-1.0f));
        }
    };
    String prevAnim = "empty";

    public BubbaleoneVelocimorphEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<BubbaleoneVelocimorphEntity>)((EntityType)SlugterraModEntities.BUBBALEONE_VELOCIMORPH.get()), world);
    }

    public BubbaleoneVelocimorphEntity(EntityType<BubbaleoneVelocimorphEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_274367_(0.6f);
        this.m_20331_(true);
    }

    public float getCurrentScale() {
        return this.currentScale;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"bubbaleoneflying");
        this.f_19804_.m_135372_(CARRYING_OWNER, (Object)false);
        this.f_19804_.m_135372_(CARRYING_ENTITY, Optional.empty());
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public double m_6048_() {
        return super.m_6048_() * (double)this.currentScale;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        return InteractionResult.FAIL;
    }

    public void m_6075_() {
        super.m_6075_();
        Level world = this.m_9236_();
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        BubbaleoneVelocimorphEntity entity = this;
        if (entity == null || !(entity instanceof TamableAnimal)) {
            return;
        }
        TamableAnimal tamableEntity = entity;
        int age = ((Entity)entity).f_19797_;
        boolean inGracePeriod = age < 10;
        double timeInAir = entity.getPersistentData().m_128459_("TimeInAir") + 1.0;
        entity.getPersistentData().m_128347_("TimeInAir", timeInAir);
        Vec3 motion = entity.m_20184_();
        if (motion.m_82556_() > 0.001) {
            entity.m_146922_((float)Math.toDegrees(Math.atan2(motion.f_82481_, motion.f_82479_)) - 90.0f);
            ((Entity)entity).f_19859_ = entity.m_146908_();
        }
        if (!this.m_9236_().m_5776_()) {
            BubbaleoneVelocimorphEntity.handleOwnerPickup((LevelAccessor)this.m_9236_(), (Entity)this);
        }
        if (!entity.m_20159_() && !inGracePeriod) {
            BubbaleoneVelocimorphEntity.handleEntityPickup((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (!entity.m_9236_().m_5776_() && entity.m_20194_() != null && !inGracePeriod) {
            BubbaleoneVelocimorphEntity.spawnVisualEffects((Entity)entity);
        }
        entity.m_20256_(new Vec3(entity.getPersistentData().m_128459_("v_x"), entity.getPersistentData().m_128459_("v_y"), entity.getPersistentData().m_128459_("v_z")));
        if (timeInAir > 80.0 && BubbaleoneVelocimorphEntity.isCollidingWithBlocks((LevelAccessor)world, x, y, z) && !inGracePeriod) {
            entity.getPersistentData().m_128347_("TimeInAir", 160.0);
        }
        if (timeInAir >= 160.0 && world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            BubbaleoneVelocimorphEntity.transformToProtoform(serverLevel, entity);
        }
        if (entity.m_20159_()) {
            BubbaleoneVelocimorphEntity.handleBubbaleoneMovement((Entity)this);
        }
        this.m_6210_();
    }

    public static void handleOwnerPickup(LevelAccessor world, Entity entity) {
        if (!(entity instanceof TamableAnimal)) {
            return;
        }
        TamableAnimal tamable = (TamableAnimal)entity;
        LivingEntity owner = tamable.m_269323_();
        if (owner == null || !(owner instanceof Player)) {
            return;
        }
        Player player = (Player)owner;
        if (player.m_6144_()) {
            return;
        }
        if (owner.m_20280_(entity) <= 9.0 && !owner.m_20096_() && !BubbaleoneVelocimorphEntity.isPlayerTrapped(player) && !entity.m_20159_()) {
            owner.m_20334_(0.0, 0.0, 0.0);
            entity.m_20256_(Vec3.f_82478_);
            entity.m_6021_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_());
            if (!world.m_5776_()) {
                entity.m_7998_((Entity)owner, true);
                owner.m_20331_(true);
                entity.getPersistentData().m_128347_("TimeInAir", 0.0);
                entity.m_20088_().m_135381_(CARRYING_ENTITY, Optional.of(owner.m_20148_()));
                entity.m_20088_().m_135381_(CARRYING_OWNER, (Object)true);
                double upwardVelocity = owner.m_5842_() ? 0.4 : 0.2;
                entity.getPersistentData().m_128347_("v_x", 0.0);
                entity.getPersistentData().m_128347_("v_y", upwardVelocity);
                entity.getPersistentData().m_128347_("v_z", 0.0);
                owner.m_20256_(new Vec3(0.0, upwardVelocity, 0.0));
            }
        }
        if (world.m_5776_() && ((Boolean)entity.m_20088_().m_135370_(CARRYING_OWNER)).booleanValue() && !entity.m_20159_()) {
            entity.m_6034_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_());
            entity.m_20329_((Entity)owner);
        }
    }

    private static void handleEntityPickup(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (!world.m_5776_()) {
            List nearbyEntities = world.m_6443_(Entity.class, new AABB(x, y, z, x, y, z).m_82400_(1.0), e -> BubbaleoneVelocimorphEntity.isValidPickupTarget(e, entity));
            if (!nearbyEntities.isEmpty()) {
                Entity target = (Entity)nearbyEntities.get(0);
                if (!(target instanceof LivingEntity)) {
                    return;
                }
                target.m_20331_(true);
                double upwardVelocity = target.m_5842_() ? 0.4 : 0.2;
                entity.getPersistentData().m_128347_("v_x", 0.0);
                entity.getPersistentData().m_128347_("v_y", upwardVelocity);
                entity.getPersistentData().m_128347_("v_z", 0.0);
                entity.m_7998_(target, true);
                entity.m_20088_().m_135381_(CARRYING_ENTITY, Optional.of(target.m_20148_()));
                entity.getPersistentData().m_128347_("TimeInAir", 0.0);
                target.m_20256_(new Vec3(0.0, upwardVelocity, 0.0));
            }
        } else {
            Optional targetUUID = (Optional)entity.m_20088_().m_135370_(CARRYING_ENTITY);
            if (targetUUID.isPresent() && !entity.m_20159_()) {
                Entity target = null;
                if (world instanceof ClientLevel) {
                    ClientLevel clientWorld = (ClientLevel)world;
                    for (Entity e2 : clientWorld.m_104735_()) {
                        if (!e2.m_20148_().equals(targetUUID.get())) continue;
                        target = e2;
                        break;
                    }
                }
                entity.m_6034_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                entity.m_20329_(target);
            }
        }
    }

    private static void spawnVisualEffects(Entity entity) {
        entity.m_20194_().m_129892_().m_230957_(new CommandSourceStack(CommandSource.f_80164_, entity.m_20182_(), entity.m_20155_(), entity.m_9236_() instanceof ServerLevel ? (ServerLevel)entity.m_9236_() : null, 4, entity.m_7755_().getString(), entity.m_5446_(), entity.m_9236_().m_7654_(), entity), "photon fx photon:trail_bubbaleone entity @s");
    }

    private static void transformToProtoform(ServerLevel level, TamableAnimal entity) {
        LivingEntity ridden;
        Entity carriedEntity = null;
        if (entity.getPersistentData().m_128403_("CarryingEntity")) {
            carriedEntity = level.m_8791_(entity.getPersistentData().m_128342_("CarryingEntity"));
        }
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        float yRot = entity.m_146908_();
        float xRot = entity.m_146909_();
        LivingEntity livingEntity = ridden = entity.m_20202_() instanceof LivingEntity ? (LivingEntity)entity.m_20202_() : null;
        if (carriedEntity != null || ridden != null) {
            LivingEntity toDismount = carriedEntity != null ? (LivingEntity)carriedEntity : ridden;
            toDismount.m_8127_();
            toDismount.f_19789_ = 1.0f;
            toDismount.m_20331_(false);
        }
        entity.m_146870_();
        Entity protoform = ((EntityType)SlugterraModEntities.BUBBALEONE.get()).m_20615_((Level)level);
        if (protoform == null) {
            return;
        }
        if (protoform instanceof TamableAnimal) {
            TamableAnimal tamableProto = (TamableAnimal)protoform;
            LivingEntity livingEntity2 = entity.m_269323_();
            if (livingEntity2 instanceof Player) {
                Player owner = (Player)livingEntity2;
                tamableProto.m_21828_(owner);
            }
        }
        CompoundTag entityData = entity.getPersistentData().m_128469_("entityData");
        protoform.m_20258_(entityData);
        if (entity.m_8077_()) {
            protoform.m_6593_(entity.m_7770_());
        }
        if (protoform instanceof LivingEntity) {
            LivingEntity livingProto = (LivingEntity)protoform;
            livingProto.m_7292_(new MobEffectInstance((MobEffect)SlugterraModMobEffects.SLUGGY.get(), 500, 0, false, false));
        }
        level.m_7967_(protoform);
        protoform.m_7678_(x, y, z, yRot, xRot);
        protoform.m_6034_(x, y, z);
        protoform.m_146922_(yRot);
        protoform.m_146926_(xRot);
        protoform.m_146867_();
    }

    private static boolean isCollidingWithBlocks(LevelAccessor world, double x, double y, double z) {
        return world.m_8055_(BlockPos.m_274561_((double)(x + 0.8), (double)y, (double)z)).m_60815_() || world.m_8055_(BlockPos.m_274561_((double)(x - 0.8), (double)y, (double)z)).m_60815_() || world.m_8055_(BlockPos.m_274561_((double)x, (double)(y + 0.8), (double)z)).m_60815_() || world.m_8055_(BlockPos.m_274561_((double)x, (double)(y - 0.8), (double)z)).m_60815_() || world.m_8055_(BlockPos.m_274561_((double)x, (double)y, (double)(z + 0.8))).m_60815_() || world.m_8055_(BlockPos.m_274561_((double)x, (double)y, (double)(z - 0.8))).m_60815_();
    }

    private static boolean isPlayerTrapped(Player player) {
        return player.getCapability(SlugterraModVariables.PLAYER_VARIABLES_CAPABILITY, null).map(cap -> cap.PoleroTrapped).orElse(false);
    }

    private static boolean isValidPickupTarget(Entity target, Entity entity) {
        TamableAnimal tamable;
        return target != entity && !(target instanceof ExperienceOrb) && !(target instanceof ItemEntity) && (!(entity instanceof TamableAnimal) || target != (tamable = (TamableAnimal)entity).m_269323_()) && !target.m_20159_();
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        BubbaleoneVelocimorphEntity.handleDamageEvent((Event)event, event.getEntity(), event.getSource());
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        BubbaleoneVelocimorphEntity.handleDamageEvent((Event)event, event.getEntity(), event.getSource());
    }

    private static void handleDamageEvent(Event event, LivingEntity entity, DamageSource source) {
        if (entity != null && BubbaleoneVelocimorphEntity.isRiddenByBubbaleone(entity) && !source.m_276093_(DamageTypes.f_268671_) && !source.m_276093_(DamageTypes.f_268659_) && !source.m_276093_(DamageTypes.f_268669_) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    private static boolean isRiddenByBubbaleone(LivingEntity entity) {
        for (Entity passenger : entity.m_20197_()) {
            if (!(passenger instanceof BubbaleoneVelocimorphEntity)) continue;
            return true;
        }
        return false;
    }

    private static void handleBubbaleoneMovement(Entity entity) {
        Entity entity2 = entity.m_20202_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity livingVehicle = (LivingEntity)entity2;
            boolean isUnderwater = livingVehicle.m_5842_();
            double baseLift = 0.1;
            double liftForce = isUnderwater ? baseLift * 2.0 : baseLift;
            entity.m_20202_().f_19789_ = 1.0f;
            if (livingVehicle instanceof Player) {
                TamableAnimal tamable;
                Player player = (Player)livingVehicle;
                if (entity instanceof TamableAnimal && player.equals((Object)(tamable = (TamableAnimal)entity).m_269323_()) && player.m_6144_()) {
                    entity.getPersistentData().m_128347_("TimeInAir", 300.0);
                    entity.m_8127_();
                    return;
                }
            }
            entity.getPersistentData().m_128347_("v_x", 0.0);
            entity.getPersistentData().m_128347_("v_y", liftForce);
            entity.getPersistentData().m_128347_("v_z", 0.0);
            double timeInAirIncrement = entity.m_20159_() ? 0.5 : 1.0;
            entity.getPersistentData().m_128347_("TimeInAir", entity.getPersistentData().m_128459_("TimeInAir") + timeInAirIncrement);
            livingVehicle.m_20256_(new Vec3(entity.getPersistentData().m_128459_("v_x"), entity.getPersistentData().m_128459_("v_y"), entity.getPersistentData().m_128459_("v_z")));
            if (isUnderwater && !livingVehicle.m_9236_().m_5776_()) {
                BubbaleoneVelocimorphEntity.spawnBubbleParticles(livingVehicle);
            }
        }
    }

    private static void spawnBubbleParticles(LivingEntity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 5, 0.2, 0.2, 0.2, 0.1);
        }
    }

    public void m_8119_() {
        LivingEntity riddenEntity;
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            BubbaleoneVelocimorphEntity.handleOwnerPickup((LevelAccessor)this.m_9236_(), (Entity)this);
        }
        this.updateScaleBasedOnVehicle();
        Entity entity = this.m_20202_();
        if (entity instanceof LivingEntity && (riddenEntity = (LivingEntity)entity).m_5842_()) {
            riddenEntity.m_20301_(riddenEntity.m_6062_());
            if (!riddenEntity.m_21023_(MobEffects.f_19608_)) {
                riddenEntity.m_147207_(new MobEffectInstance(MobEffects.f_19608_, 20, 0, false, false), (Entity)this);
            }
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(this.currentScale);
    }

    public void updateScaleBasedOnVehicle() {
        if (this.m_20159_()) {
            Entity vehicle = this.m_20202_();
            if (vehicle != null) {
                String typeKey = EntityType.m_20613_((EntityType)vehicle.m_6095_()).toString();
                if (SPECIAL_SCALE_ADJUSTMENTS.containsKey(typeKey)) {
                    this.currentScale = SPECIAL_SCALE_ADJUSTMENTS.get(typeKey).floatValue();
                } else if (vehicle instanceof Player) {
                    this.currentScale = 1.6f;
                } else if (vehicle instanceof LivingEntity) {
                    LivingEntity livingVehicle = (LivingEntity)vehicle;
                    float vehicleWidth = livingVehicle.m_20205_();
                    float vehicleHeight = livingVehicle.m_20206_();
                    float volume = vehicleWidth * vehicleHeight;
                    this.currentScale = Math.max(1.2f, Math.min(5.0f, 1.0f + volume * 0.5f));
                }
            }
        } else {
            this.currentScale = 1.0f;
        }
        this.m_6210_();
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        BubbaleoneVelocimorphEntity retval = (BubbaleoneVelocimorphEntity)((EntityType)SlugterraModEntities.BUBBALEONE_VELOCIMORPH.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 10.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("flying"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

