/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.entity;

import falconnex.legendsofslugterra.EntityDespawnHandler;
import falconnex.legendsofslugterra.SlugWanderGoal;
import falconnex.legendsofslugterra.ThuggletChangeGoal;
import falconnex.legendsofslugterra.ai.SlugHerdPanicGoal;
import falconnex.legendsofslugterra.entity.ai.AvoidTamedSlugHoundGoal;
import falconnex.legendsofslugterra.init.SlugterraModEntities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CrystalydEntity
extends TamableAnimal
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(CrystalydEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(CrystalydEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(CrystalydEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> DATA_Damage = SynchedEntityData.m_135353_(CrystalydEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_Knockback = SynchedEntityData.m_135353_(CrystalydEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_Speed = SynchedEntityData.m_135353_(CrystalydEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final TagKey<Block> MINABLE_ORES = BlockTags.create((ResourceLocation)new ResourceLocation("slugterra", "crystalyd_ores"));
    private static final int SEARCH_RADIUS = 16;
    private static final int SEARCH_DEPTH = 32;
    private static final int MISSION_DURATION = 2400;
    private static final int TELEPORT_COOLDOWN = 10;
    private static final int PARTICLE_FREQUENCY = 5;
    private static final String COOLDOWN_KEY = "CrystalydMiningCooldown";
    private static final int COOLDOWN_TICKS = 24000;
    private static final int DIGGING_DURATION = 60;
    private int diggingTimer = 0;
    private boolean isDigging = false;
    private boolean isMining = false;
    private int miningTimer = 0;
    private int teleportCounter = 0;
    private int particleTimer = 0;
    private List<BlockPos> orePositions = new ArrayList<BlockPos>();
    private SimpleContainer collectedItems = new SimpleContainer(27);
    private BlockPos startPos;
    private BlockPos lastMinedPos = null;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public CrystalydEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<CrystalydEntity>)((EntityType)SlugterraModEntities.CRYSTALYD.get()), world);
    }

    public CrystalydEntity(EntityType<CrystalydEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_274367_(0.6f);
        if (!this.getPersistentData().m_128441_("proto")) {
            this.getPersistentData().m_128365_("proto", (Tag)new CompoundTag());
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"crystalyd");
        this.f_19804_.m_135372_(DATA_Damage, (Object)0);
        this.f_19804_.m_135372_(DATA_Knockback, (Object)0);
        this.f_19804_.m_135372_(DATA_Speed, (Object)1);
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new AvoidTamedSlugHoundGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new SlugWanderGoal(this, 0.6));
        this.f_21345_.m_25352_(2, (Goal)new SlugHerdPanicGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new ThuggletChangeGoal(this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slugidle"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slughurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slugdeath"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isMining) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
        compound.m_128405_("DataDamage", ((Integer)this.f_19804_.m_135370_(DATA_Damage)).intValue());
        compound.m_128405_("DataKnockback", ((Integer)this.f_19804_.m_135370_(DATA_Knockback)).intValue());
        compound.m_128405_("DataSpeed", ((Integer)this.f_19804_.m_135370_(DATA_Speed)).intValue());
        compound.m_128379_("IsMining", this.isMining);
        compound.m_128405_("MiningTimer", this.miningTimer);
        if (this.startPos != null) {
            compound.m_128385_("StartPos", new int[]{this.startPos.m_123341_(), this.startPos.m_123342_(), this.startPos.m_123343_()});
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
        if (compound.m_128441_("DataDamage")) {
            this.f_19804_.m_135381_(DATA_Damage, (Object)compound.m_128451_("DataDamage"));
        }
        if (compound.m_128441_("DataKnockback")) {
            this.f_19804_.m_135381_(DATA_Knockback, (Object)compound.m_128451_("DataKnockback"));
        }
        if (compound.m_128441_("DataSpeed")) {
            this.f_19804_.m_135381_(DATA_Speed, (Object)compound.m_128451_("DataSpeed"));
        }
        this.isMining = compound.m_128471_("IsMining");
        this.miningTimer = compound.m_128451_("MiningTimer");
        if (compound.m_128441_("StartPos")) {
            int[] pos = compound.m_128465_("StartPos");
            this.startPos = new BlockPos(pos[0], pos[1], pos[2]);
        }
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.m_21120_(hand);
        if (itemstack.m_41619_() && this.m_21824_() && this.m_21830_((LivingEntity)sourceentity)) {
            long cooldownEnd;
            if (this.isMining || this.isDigging) {
                sourceentity.m_5661_((Component)Component.m_237113_((String)("\u00a76" + this.m_7755_().getString() + " \u00a7cis already mining!")), true);
                return InteractionResult.SUCCESS;
            }
            CompoundTag protoTag = this.getPersistentData().m_128469_("proto");
            long currentTime = this.m_9236_().m_46467_();
            if (currentTime < (cooldownEnd = protoTag.m_128454_(COOLDOWN_KEY))) {
                this.setAnimation("empty");
                if (!this.m_9236_().m_5776_()) {
                    long remainingTicks = cooldownEnd - currentTime;
                    long remainingMinutes = remainingTicks / 20L / 60L;
                    sourceentity.m_5661_((Component)Component.m_237113_((String)("\u23f3 \u00a76" + this.m_7755_().getString() + " \u00a7cis still recovering from last mining trip (" + remainingMinutes + "m remaining) \u00a76\ud83d\udc8e\ufe0f")), true);
                    this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slug_fail")), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
            this.isDigging = true;
            this.diggingTimer = 60;
            this.setAnimation("digging");
            if (!this.m_9236_().m_5776_()) {
                sourceentity.m_5661_((Component)Component.m_237113_((String)("\u00a76" + this.m_7755_().getString() + " \u00a7ebegins digging into the ground... \u00a76\ud83d\udc8e\ufe0f")), true);
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12331_, SoundSource.NEUTRAL, 1.0f, 0.8f);
            }
            return InteractionResult.SUCCESS;
        }
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        Item item = itemstack.m_41720_();
        if (itemstack.m_41720_() instanceof SpawnEggItem) {
            retval = super.m_6071_(sourceentity, hand);
        } else if (this.m_9236_().m_5776_()) {
            retval = this.m_21824_() && this.m_21830_((LivingEntity)sourceentity) || this.m_6898_(itemstack) ? InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_()) : InteractionResult.PASS;
        } else if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)sourceentity)) {
                if (item.m_41472_() && this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(item.m_41473_().m_38744_());
                    retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                } else if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(4.0f);
                    retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                } else {
                    retval = super.m_6071_(sourceentity, hand);
                }
            }
        } else if (this.m_6898_(itemstack)) {
            this.m_142075_(sourceentity, hand, itemstack);
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.m_21828_(sourceentity);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
                this.m_21530_();
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        } else {
            retval = super.m_6071_(sourceentity, hand);
        }
        return retval;
    }

    private void startMiningMission() {
        long cooldownEnd;
        if (this.m_9236_().m_5776_()) {
            return;
        }
        long currentTime = this.m_9236_().m_46467_();
        if (currentTime < (cooldownEnd = this.getPersistentData().m_128469_("proto").m_128454_(COOLDOWN_KEY))) {
            return;
        }
        this.isMining = true;
        this.miningTimer = 2400;
        this.startPos = this.m_20183_();
        this.orePositions.clear();
        this.collectedItems.m_6211_();
        for (int x = -16; x <= 16; ++x) {
            for (int z = -16; z <= 16; ++z) {
                for (int y = 0; y >= -32; --y) {
                    BlockPos pos = this.startPos.m_7918_(x, y, z);
                    BlockState state = this.m_9236_().m_8055_(pos);
                    if (!state.m_204336_(MINABLE_ORES)) continue;
                    this.orePositions.add(this.findSafeMiningPosition(pos));
                }
            }
        }
        CompoundTag protoTag = this.getPersistentData().m_128469_("proto");
        protoTag.m_128356_(COOLDOWN_KEY, currentTime + 24000L);
        this.getPersistentData().m_128365_("proto", (Tag)protoTag);
        this.m_21557_(true);
        this.m_6842_(true);
        this.setAnimation("mining");
        this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 2400, 255, false, false));
    }

    private BlockPos findSafeMiningPosition(BlockPos orePos) {
        for (int y = 1; y <= 3; ++y) {
            BlockPos checkPos = orePos.m_6630_(y);
            if (!this.isPositionSafeForMining(checkPos)) continue;
            return checkPos;
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos checkPos = orePos.m_121945_(dir);
            if (!this.isPositionSafeForMining(checkPos)) continue;
            return checkPos;
        }
        return orePos;
    }

    private boolean isPositionSafeForMining(BlockPos pos) {
        return this.m_9236_().m_46859_(pos) && !this.m_9236_().m_46859_(pos.m_7495_());
    }

    private void mineBlock(BlockPos pos) {
        BlockState state = this.m_9236_().m_8055_(pos);
        if (state.m_60795_()) {
            return;
        }
        List drops = Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)this.m_9236_()), (BlockPos)pos, null);
        for (ItemStack stack : drops) {
            this.collectedItems.m_19173_(stack);
        }
        this.m_9236_().m_46953_(pos, false, (Entity)this);
        this.lastMinedPos = pos;
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
        if (!this.m_9236_().m_5776_()) {
            if (!this.isMining && !this.isDigging && "digging".equals(this.getSyncedAnimation())) {
                this.setAnimation("empty");
            }
            if (this.isDigging) {
                if (this.diggingTimer <= 0) {
                    this.startMiningMission();
                    this.isDigging = false;
                } else {
                    --this.diggingTimer;
                    if (this.diggingTimer % 5 == 0) {
                        this.spawnDiggingParticles();
                    }
                    return;
                }
            }
            if (this.isMining) {
                if (this.miningTimer <= 0) {
                    this.finishMiningMission();
                    return;
                }
                --this.miningTimer;
                if (this.teleportCounter <= 0 && !this.orePositions.isEmpty()) {
                    BlockPos targetPos = this.orePositions.remove(0);
                    this.m_6021_((double)targetPos.m_123341_() + 0.5, targetPos.m_123342_() + 1, (double)targetPos.m_123343_() + 0.5);
                    this.mineBlock(targetPos);
                    this.teleportCounter = 10;
                    this.lastMinedPos = targetPos;
                } else {
                    --this.teleportCounter;
                }
                if (this.particleTimer <= 0 && this.lastMinedPos != null) {
                    this.spawnMiningParticles(this.lastMinedPos);
                    this.particleTimer = 5;
                } else {
                    --this.particleTimer;
                }
            }
        }
    }

    private void spawnDiggingParticles() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 15, 0.5, 0.1, 0.5, 0.1);
        }
    }

    private void spawnMiningParticles(BlockPos minedPos) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockState minedState = this.m_9236_().m_8055_(minedPos);
            serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, minedState), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 15, 0.3, 0.3, 0.3, 0.05);
        }
    }

    private void finishMiningMission() {
        Player owner;
        this.isMining = false;
        this.m_6021_((double)this.startPos.m_123341_() + 0.5, this.startPos.m_123342_(), (double)this.startPos.m_123343_() + 0.5);
        this.m_21557_(false);
        this.m_6842_(false);
        this.setAnimation("empty");
        for (int i = 0; i < this.collectedItems.m_6643_(); ++i) {
            ItemStack stack = this.collectedItems.m_8020_(i);
            if (stack.m_41619_()) continue;
            this.m_19983_(stack);
        }
        if (!this.m_9236_().m_5776_() && (owner = (Player)this.m_269323_()) != null) {
            owner.m_5661_((Component)Component.m_237113_((String)("\u00a76" + this.m_7755_().getString() + " \u00a7ehas returned from its mining trip! \u00a76\u26cf\ufe0f")), true);
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12019_, SoundSource.NEUTRAL, 1.0f, 1.2f);
        }
        this.collectedItems.m_6211_();
        this.lastMinedPos = null;
    }

    public void m_6043_() {
        EntityDespawnHandler.handleDespawn((Mob)this);
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.0f);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        CrystalydEntity retval = (CrystalydEntity)((EntityType)SlugterraModEntities.CRYSTALYD.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return List.of().contains(stack.m_41720_());
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 10.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (event.isMoving() || !(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("walking"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.m_20185_() - this.f_19790_;
        double d0 = this.m_20189_() - this.f_19792_;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.m_21324_(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.m_9236_().m_46467_();
        }
        if (this.swinging && this.lastSwing + 7L <= this.m_9236_().m_46467_()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("attack"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 4, this::attackingPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

