/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.entity;

import falconnex.legendsofslugterra.EntityDespawnHandler;
import falconnex.legendsofslugterra.SlugWanderGoal;
import falconnex.legendsofslugterra.ThuggletChangeGoal;
import falconnex.legendsofslugterra.ai.SlugHerdPanicGoal;
import falconnex.legendsofslugterra.entity.ai.AvoidTamedSlugHoundGoal;
import falconnex.legendsofslugterra.init.SlugterraModBlocks;
import falconnex.legendsofslugterra.init.SlugterraModEntities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DiggrixEntity
extends TamableAnimal
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(DiggrixEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(DiggrixEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(DiggrixEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> DATA_Damage = SynchedEntityData.m_135353_(DiggrixEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_Knockback = SynchedEntityData.m_135353_(DiggrixEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_Speed = SynchedEntityData.m_135353_(DiggrixEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final String COOLDOWN_TAG = "DiggrixAbilityCooldown";
    private static final int COOLDOWN_TICKS = 1200;
    private static final int WILD_DIG_CHANCE = 1000;
    private static final ResourceLocation ARID_CAVERN_BIOME = new ResourceLocation("slugterra:arid_cavern");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public DiggrixEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<DiggrixEntity>)((EntityType)SlugterraModEntities.DIGGRIX.get()), world);
    }

    public DiggrixEntity(EntityType<DiggrixEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_274367_(0.6f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"diggrix");
        this.f_19804_.m_135372_(DATA_Damage, (Object)0);
        this.f_19804_.m_135372_(DATA_Knockback, (Object)0);
        this.f_19804_.m_135372_(DATA_Speed, (Object)1);
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new AvoidTamedSlugHoundGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new SlugWanderGoal(this, 0.6));
        this.f_21345_.m_25352_(2, (Goal)new SlugHerdPanicGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new ThuggletChangeGoal(this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slugidle"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slughurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slugdeath"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
        compound.m_128405_("DataDamage", ((Integer)this.f_19804_.m_135370_(DATA_Damage)).intValue());
        compound.m_128405_("DataKnockback", ((Integer)this.f_19804_.m_135370_(DATA_Knockback)).intValue());
        compound.m_128405_("DataSpeed", ((Integer)this.f_19804_.m_135370_(DATA_Speed)).intValue());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
        if (compound.m_128441_("DataDamage")) {
            this.f_19804_.m_135381_(DATA_Damage, (Object)compound.m_128451_("DataDamage"));
        }
        if (compound.m_128441_("DataKnockback")) {
            this.f_19804_.m_135381_(DATA_Knockback, (Object)compound.m_128451_("DataKnockback"));
        }
        if (compound.m_128441_("DataSpeed")) {
            this.f_19804_.m_135381_(DATA_Speed, (Object)compound.m_128451_("DataSpeed"));
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        Item item = itemstack.m_41720_();
        if (itemstack.m_41720_() instanceof SpawnEggItem) {
            retval = super.m_6071_(player, hand);
        } else if (this.m_9236_().m_5776_()) {
            retval = this.m_21824_() && this.m_21830_((LivingEntity)player) || this.m_6898_(itemstack) ? InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_()) : InteractionResult.PASS;
        } else if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)player)) {
                if (item.m_41472_() && this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(player, hand, itemstack);
                    this.m_5634_(item.m_41473_().m_38744_());
                    retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                } else if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(player, hand, itemstack);
                    this.m_5634_(4.0f);
                    retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                } else if (itemstack.m_41619_() && player.m_21206_().m_41619_()) {
                    this.attemptDig(player);
                    retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                } else {
                    retval = super.m_6071_(player, hand);
                }
            }
        } else if (this.m_6898_(itemstack)) {
            this.m_142075_(player, hand, itemstack);
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
                this.m_21530_();
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        } else {
            retval = super.m_6071_(player, hand);
        }
        return retval;
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
        if (!this.m_9236_().m_5776_() && !this.m_21824_() && this.f_19796_.m_188503_(1000) == 0) {
            this.attemptDig(null);
        }
    }

    private void attemptDig(@Nullable Player player) {
        int cooldownTicks;
        BlockPos pos = this.m_20183_();
        Level level = this.m_9236_();
        if (level.m_8055_(pos.m_7495_()).m_60734_() != SlugterraModBlocks.CHERT.get() || !level.m_204166_(pos).m_203373_(ARID_CAVERN_BIOME) || level.m_8055_(pos).m_60734_() == SlugterraModBlocks.SLUG_DIGHOLE.get()) {
            return;
        }
        CompoundTag persistentData = this.getPersistentData();
        CompoundTag protoData = persistentData.m_128441_("proto") ? persistentData.m_128469_("proto") : new CompoundTag();
        long currentTime = level.m_46467_();
        long lastUsedTime = protoData.m_128454_("cooldown");
        int n = cooldownTicks = protoData.m_128441_("cooldownTicks") ? protoData.m_128451_("cooldownTicks") : 1200;
        if (currentTime - lastUsedTime < (long)cooldownTicks) {
            if (player != null) {
                long remainingSeconds = ((long)cooldownTicks - (currentTime - lastUsedTime)) / 20L;
                player.m_5661_((Component)Component.m_237113_((String)("\u00a78\u23f3 \u00a77Diggrix needs " + remainingSeconds + " more seconds to burrow!")), true);
                level.m_5594_(null, pos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slug_fail")), SoundSource.NEUTRAL, 0.7f, 1.0f);
            }
            return;
        }
        level.m_5594_(null, pos, SoundEvents.f_12331_, SoundSource.NEUTRAL, 0.7f, 1.0f);
        if (this.f_19796_.m_188501_() < 0.5f) {
            level.m_7731_(pos, ((Block)SlugterraModBlocks.SLUG_DIGHOLE.get()).m_49966_(), 3);
            level.m_5594_(null, pos, SoundEvents.f_12334_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player != null) {
                player.m_5661_((Component)Component.m_237113_((String)"\u00a7b\ud83c\udf00 Diggrix successfully created a burrow!"), true);
            }
        } else {
            if (player != null) {
                player.m_5661_((Component)Component.m_237113_((String)"\u00a7e\ud83d\udca8 Diggrix tried to dig, but nothing happened..."), true);
            }
            level.m_5594_(null, pos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slug_fail")), SoundSource.NEUTRAL, 0.7f, 1.0f);
        }
        protoData.m_128356_("cooldown", currentTime);
        protoData.m_128405_("cooldownTicks", 1200);
        persistentData.m_128365_("proto", (Tag)protoData);
    }

    public void m_6043_() {
        EntityDespawnHandler.handleDespawn((Mob)this);
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(1.0f);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        DiggrixEntity retval = (DiggrixEntity)((EntityType)SlugterraModEntities.DIGGRIX.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return List.of().contains(stack.m_41720_());
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 10.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (event.isMoving() || !(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.NormalSlug.walking"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.NormalSlug.idle"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.m_20185_() - this.f_19790_;
        double d0 = this.m_20189_() - this.f_19792_;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.m_21324_(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.m_9236_().m_46467_();
        }
        if (this.swinging && this.lastSwing + 7L <= this.m_9236_().m_46467_()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.NormalSlug.attack"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 4, this::attackingPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

