/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.entity;

import falconnex.legendsofslugterra.init.SlugterraModEntities;
import falconnex.legendsofslugterra.init.SlugterraModMobEffects;
import falconnex.legendsofslugterra.network.SlugterraModVariables;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

@Mod.EventBusSubscriber
public class HoverbugVelocimorphEntity
extends TamableAnimal
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(HoverbugVelocimorphEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(HoverbugVelocimorphEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(HoverbugVelocimorphEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> CARRYING_OWNER = SynchedEntityData.m_135353_(HoverbugVelocimorphEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> CARRYING_ENTITY = SynchedEntityData.m_135353_(HoverbugVelocimorphEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    private static final int MAX_AIR_TIME = 140;
    private static final int SLUGGY_DURATION = 500;
    private static final int OCCLUSION_CHECK_THRESHOLD = 20;
    private static final int CATCH_GRACE_PERIOD = 5;
    String prevAnim = "empty";

    public HoverbugVelocimorphEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<HoverbugVelocimorphEntity>)((EntityType)SlugterraModEntities.HOVERBUG_VELOCIMORPH.get()), world);
    }

    public HoverbugVelocimorphEntity(EntityType<HoverbugVelocimorphEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_274367_(0.6f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"hoverbugflying");
        this.f_19804_.m_135372_(CARRYING_OWNER, (Object)false);
        this.f_19804_.m_135372_(CARRYING_ENTITY, Optional.empty());
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        return InteractionResult.FAIL;
    }

    public void m_6075_() {
        super.m_6075_();
        Level world = this.m_9236_();
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        HoverbugVelocimorphEntity entity = this;
        if (!(entity instanceof TamableAnimal)) {
            return;
        }
        int age = ((Entity)entity).f_19797_;
        boolean inGracePeriod = age < 5;
        double timeInAir = entity.getPersistentData().m_128459_("TimeInAir") + 1.0;
        entity.getPersistentData().m_128347_("TimeInAir", timeInAir);
        Vec3 motion = entity.m_20184_();
        if (motion.m_82556_() > 0.001) {
            entity.m_146922_((float)Math.toDegrees(Math.atan2(motion.f_82481_, motion.f_82479_)) - 90.0f);
            ((Entity)entity).f_19859_ = entity.m_146908_();
        }
        if (!this.m_9236_().m_5776_()) {
            HoverbugVelocimorphEntity.handleOwnerPickup((LevelAccessor)this.m_9236_(), (Entity)this);
        }
        if (!entity.m_20159_() && !inGracePeriod) {
            HoverbugVelocimorphEntity.handleEntityPickup((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (!entity.m_9236_().m_5776_() && entity.m_20194_() != null && !inGracePeriod) {
            HoverbugVelocimorphEntity.spawnVisualEffects((Entity)entity);
        }
        entity.m_20256_(new Vec3(entity.getPersistentData().m_128459_("v_x"), entity.getPersistentData().m_128459_("v_y"), entity.getPersistentData().m_128459_("v_z")));
        if (timeInAir > 20.0 && HoverbugVelocimorphEntity.isCollidingWithBlocks((LevelAccessor)world, x, y, z) && !inGracePeriod) {
            entity.getPersistentData().m_128347_("TimeInAir", 140.0);
        }
        if (timeInAir >= 140.0 && world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            HoverbugVelocimorphEntity.transformToProtoform(serverLevel, entity);
        }
        if (entity.m_20159_()) {
            HoverbugVelocimorphEntity.handleHoverbugMovement((Entity)entity);
        }
        this.m_6210_();
    }

    private static void handleOwnerPickup(LevelAccessor world, Entity entity) {
        if (!(entity instanceof TamableAnimal)) {
            return;
        }
        TamableAnimal tamable = (TamableAnimal)entity;
        LivingEntity owner = tamable.m_269323_();
        if (owner == null || !(owner instanceof Player)) {
            return;
        }
        Player player = (Player)owner;
        if (player.m_6144_()) {
            return;
        }
        if (!(!(owner.m_20280_(entity) <= 9.0) || owner.m_20096_() || HoverbugVelocimorphEntity.isPlayerTrapped(player) || entity.m_20159_() || world.m_5776_())) {
            entity.m_7998_((Entity)owner, true);
            entity.m_20088_().m_135381_(CARRYING_OWNER, (Object)true);
            entity.m_20088_().m_135381_(CARRYING_ENTITY, Optional.of(owner.m_20148_()));
            entity.getPersistentData().m_128347_("TimeInAir", 0.0);
        }
        if (world.m_5776_() && ((Boolean)entity.m_20088_().m_135370_(CARRYING_OWNER)).booleanValue() && !entity.m_20159_()) {
            entity.m_7998_((Entity)owner, true);
        }
    }

    private static void handleEntityPickup(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (!world.m_5776_()) {
            List nearbyEntities = world.m_6443_(Entity.class, new AABB(x, y, z, x, y, z).m_82400_(1.0), e -> HoverbugVelocimorphEntity.isValidPickupTarget(e, entity));
            if (!nearbyEntities.isEmpty()) {
                TamableAnimal tamable;
                Entity target = (Entity)nearbyEntities.get(0);
                if (target.m_20160_()) {
                    target.m_20153_();
                }
                if ((!(entity instanceof TamableAnimal) || target != (tamable = (TamableAnimal)entity).m_269323_()) && target instanceof LivingEntity) {
                    LivingEntity livingTarget = (LivingEntity)target;
                    livingTarget.m_6469_(livingTarget.m_269291_().m_269333_((LivingEntity)entity), 4.0f);
                }
                entity.m_7998_(target, true);
                entity.m_20088_().m_135381_(CARRYING_ENTITY, Optional.of(target.m_20148_()));
                entity.getPersistentData().m_128347_("TimeInAir", 0.0);
            }
        } else {
            Optional targetUUID = (Optional)entity.m_20088_().m_135370_(CARRYING_ENTITY);
            if (targetUUID.isPresent() && !entity.m_20159_()) {
                Entity target = null;
                if (world instanceof ClientLevel) {
                    ClientLevel clientWorld = (ClientLevel)world;
                    for (Entity e2 : clientWorld.m_104735_()) {
                        if (!e2.m_20148_().equals(targetUUID.get())) continue;
                        target = e2;
                        break;
                    }
                }
                entity.m_6034_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                entity.m_20329_(target);
            }
        }
    }

    private static boolean isValidPickupTarget(Entity target, Entity entity) {
        TamableAnimal tamable;
        return target != entity && !(target instanceof ExperienceOrb) && !(target instanceof ItemEntity) && (!(entity instanceof TamableAnimal) || target != (tamable = (TamableAnimal)entity).m_269323_()) && !target.m_20159_();
    }

    private static void spawnVisualEffects(Entity entity) {
        entity.m_20194_().m_129892_().m_230957_(new CommandSourceStack(CommandSource.f_80164_, entity.m_20182_(), entity.m_20155_(), entity.m_9236_() instanceof ServerLevel ? (ServerLevel)entity.m_9236_() : null, 4, entity.m_7755_().getString(), entity.m_5446_(), entity.m_9236_().m_7654_(), entity), "photon fx photon:trail_hoverbug entity @s");
    }

    private static boolean isCollidingWithBlocks(LevelAccessor world, double x, double y, double z) {
        return world.m_8055_(BlockPos.m_274561_((double)(x + 0.8), (double)y, (double)z)).m_60815_() || world.m_8055_(BlockPos.m_274561_((double)(x - 0.8), (double)y, (double)z)).m_60815_() || world.m_8055_(BlockPos.m_274561_((double)x, (double)(y + 0.8), (double)z)).m_60815_() || world.m_8055_(BlockPos.m_274561_((double)x, (double)(y - 0.8), (double)z)).m_60815_() || world.m_8055_(BlockPos.m_274561_((double)x, (double)y, (double)(z + 0.8))).m_60815_() || world.m_8055_(BlockPos.m_274561_((double)x, (double)y, (double)(z - 0.8))).m_60815_();
    }

    private static boolean isPlayerTrapped(Player player) {
        return player.getCapability(SlugterraModVariables.PLAYER_VARIABLES_CAPABILITY, null).map(cap -> cap.PoleroTrapped).orElse(false);
    }

    private static void transformToProtoform(ServerLevel level, TamableAnimal entity) {
        LivingEntity ridden;
        Entity carriedEntity = null;
        if (entity.getPersistentData().m_128403_("CarryingEntity")) {
            carriedEntity = level.m_8791_(entity.getPersistentData().m_128342_("CarryingEntity"));
        }
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        float yRot = entity.m_146908_();
        float xRot = entity.m_146909_();
        LivingEntity livingEntity = ridden = entity.m_20202_() instanceof LivingEntity ? (LivingEntity)entity.m_20202_() : null;
        if (carriedEntity != null || ridden != null) {
            LivingEntity toDismount = carriedEntity != null ? (LivingEntity)carriedEntity : ridden;
            toDismount.m_8127_();
            toDismount.f_19789_ = 1.0f;
        }
        entity.m_146870_();
        Entity protoform = ((EntityType)SlugterraModEntities.HOVERBUG.get()).m_20615_((Level)level);
        if (protoform == null) {
            return;
        }
        if (protoform instanceof TamableAnimal) {
            TamableAnimal tamableProto = (TamableAnimal)protoform;
            LivingEntity livingEntity2 = entity.m_269323_();
            if (livingEntity2 instanceof Player) {
                Player owner = (Player)livingEntity2;
                tamableProto.m_21828_(owner);
            }
        }
        CompoundTag entityData = entity.getPersistentData().m_128469_("entityData");
        protoform.m_20258_(entityData);
        if (entity.m_8077_()) {
            protoform.m_6593_(entity.m_7770_());
        }
        if (protoform instanceof LivingEntity) {
            LivingEntity livingProto = (LivingEntity)protoform;
            livingProto.m_7292_(new MobEffectInstance((MobEffect)SlugterraModMobEffects.SLUGGY.get(), 500, 0, false, false));
        }
        level.m_7967_(protoform);
        protoform.m_7678_(x, y, z, yRot, xRot);
        protoform.m_6034_(x, y, z);
        protoform.m_146922_(yRot);
        protoform.m_146926_(xRot);
        protoform.m_146867_();
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingAttackEvent event) {
        LivingEntity entity = event.getEntity();
        if (event != null && event.getEntity() != null) {
            if (entity == null) {
                return;
            }
            if (entity instanceof HoverbugVelocimorphEntity || entity instanceof HoverbugVelocimorphEntity) {
                if (event != null && event.isCancelable()) {
                    event.setCanceled(true);
                } else if (event != null && event.hasResult()) {
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    private static void handleHoverbugMovement(Entity entity) {
        if (entity.m_20202_() == null) {
            return;
        }
        double vx = entity.getPersistentData().m_128459_("v_x");
        double vy = entity.getPersistentData().m_128459_("v_y");
        double vz = entity.getPersistentData().m_128459_("v_z");
        Entity entity2 = entity.m_20202_();
        if (entity2 instanceof Player) {
            TamableAnimal tamableAnimal;
            Player player = (Player)entity2;
            if (HoverbugVelocimorphEntity.isPlayerTrapped(player)) {
                return;
            }
            player.f_19789_ = 0.0f;
            if (!player.m_9236_().m_5776_()) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 5, 0, false, false));
            }
            if (entity instanceof TamableAnimal && player.equals((Object)(tamableAnimal = (TamableAnimal)entity).m_269323_())) {
                Vec3 lookDir = player.m_20154_();
                vx = lookDir.f_82479_ * 0.9;
                vy = lookDir.f_82480_ * 0.9;
                vz = lookDir.f_82481_ * 0.9;
                entity.getPersistentData().m_128347_("v_x", vx);
                entity.getPersistentData().m_128347_("v_y", vy);
                entity.getPersistentData().m_128347_("v_z", vz);
                float yaw = (float)Math.toDegrees(Math.atan2(-lookDir.f_82479_, lookDir.f_82481_));
                float pitch = (float)Math.toDegrees(-Math.asin(lookDir.f_82480_));
                entity.m_146922_(yaw);
                entity.m_146926_(pitch);
                entity.f_19859_ = yaw;
                entity.f_19860_ = pitch;
                entity.m_5616_(yaw);
                entity.m_5618_(yaw);
            }
            if (player.m_6144_()) {
                entity.getPersistentData().m_128347_("v_y", vy - 0.03);
            }
            double finalVx = vx;
            double finalVy = vy;
            double finalVz = vz;
            player.getCapability(SlugterraModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.MovementX = finalVx * 0.1;
                capability.MovementY = finalVy * 0.1;
                capability.MovementZ = finalVz * 0.1;
                capability.MovementN = 2.0;
                capability.syncPlayerVariables((Entity)player);
            });
        } else if (!(entity.m_20202_() instanceof ExperienceOrb) && !(entity.m_20202_() instanceof ItemEntity)) {
            entity.m_20202_().m_20256_(new Vec3(vx, vy, vz));
        }
        entity.getPersistentData().m_128347_("TimeInAir", entity.getPersistentData().m_128459_("TimeInAir") + 1.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            HoverbugVelocimorphEntity.handleOwnerPickup((LevelAccessor)this.m_9236_(), (Entity)this);
            HoverbugVelocimorphEntity.handleHoverbugMovement((Entity)this);
        }
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.0f);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        HoverbugVelocimorphEntity retval = (HoverbugVelocimorphEntity)((EntityType)SlugterraModEntities.HOVERBUG_VELOCIMORPH.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return List.of().contains(stack.m_41720_());
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 10.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("flying"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

