/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.entity;

import falconnex.legendsofslugterra.init.SlugterraModEntities;
import falconnex.legendsofslugterra.init.SlugterraModMobEffects;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class IceOgreEntity
extends Monster
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(IceOgreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(IceOgreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(IceOgreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> SWINGING = SynchedEntityData.m_135353_(IceOgreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> HAS_ATTACKED = SynchedEntityData.m_135353_(IceOgreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(IceOgreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> SLEEP_STAGE = SynchedEntityData.m_135353_(IceOgreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private long lastSwing;
    private long attackStartTime;
    private long sleepStartTime;
    private final Random random = new Random();
    public String animationprocedure = "empty";
    private static final int ATTACK_WINDUP_TICKS = 10;
    private static final int ATTACK_DURATION_TICKS = 18;
    private static final int SLEEP_START_DURATION = 60;
    private static final float ATTACK_REACH = 2.5f;

    public IceOgreEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<IceOgreEntity>)((EntityType)SlugterraModEntities.ICE_OGRE.get()), world);
    }

    public IceOgreEntity(EntityType<IceOgreEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 5;
        this.m_274367_(2.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"iceogretexture");
        this.f_19804_.m_135372_(SWINGING, (Object)false);
        this.f_19804_.m_135372_(HAS_ATTACKED, (Object)false);
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(SLEEP_STAGE, (Object)"awake");
    }

    public boolean isSwinging() {
        return (Boolean)this.f_19804_.m_135370_(SWINGING);
    }

    public void setSwinging(boolean swinging) {
        this.f_19804_.m_135381_(SWINGING, (Object)swinging);
    }

    public boolean hasAttacked() {
        return (Boolean)this.f_19804_.m_135370_(HAS_ATTACKED);
    }

    public void setHasAttacked(boolean hasAttacked) {
        this.f_19804_.m_135381_(HAS_ATTACKED, (Object)hasAttacked);
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)sleeping);
    }

    public String getSleepStage() {
        return (String)this.f_19804_.m_135370_(SLEEP_STAGE);
    }

    public void setSleepStage(String stage) {
        this.f_19804_.m_135381_(SLEEP_STAGE, (Object)stage);
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return 6.25;
            }

            protected void m_6739_(LivingEntity target, double distToEnemySqr) {
                if (IceOgreEntity.this.m_5803_()) {
                    return;
                }
                double reach = this.m_6639_(target);
                if (distToEnemySqr <= reach && this.m_25565_() <= 0 && !IceOgreEntity.this.isSwinging()) {
                    IceOgreEntity.this.setSwinging(true);
                    IceOgreEntity.this.attackStartTime = IceOgreEntity.this.m_9236_().m_46467_();
                    IceOgreEntity.this.setHasAttacked(false);
                    IceOgreEntity.this.setAnimation(IceOgreEntity.this.random.nextBoolean() ? "attack_leftslap" : "attack_rightslap");
                }
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean m_8036_() {
                return !IceOgreEntity.this.m_5803_() && super.m_8036_();
            }

            public boolean m_8045_() {
                return !IceOgreEntity.this.m_5803_() && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean m_8036_() {
                return !IceOgreEntity.this.m_5803_() && super.m_8036_();
            }

            public boolean m_8045_() {
                return !IceOgreEntity.this.m_5803_() && super.m_8045_();
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, false, false){

            public boolean m_8036_() {
                return !IceOgreEntity.this.m_5803_() && super.m_8036_();
            }

            public boolean m_8045_() {
                return !IceOgreEntity.this.m_5803_() && super.m_8045_();
            }
        });
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            long elapsedTicks;
            boolean shouldSleep = this.m_21023_((MobEffect)SlugterraModMobEffects.SLEEPY.get());
            if (shouldSleep && !this.m_5803_()) {
                this.setSleeping(true);
                this.setSleepStage("start");
                this.sleepStartTime = this.m_9236_().m_46467_();
                this.setAnimation("sleep_start");
                this.m_21573_().m_26573_();
                this.m_6710_(null);
                this.m_21557_(true);
            } else if (!shouldSleep && this.m_5803_()) {
                this.setSleeping(false);
                this.setSleepStage("awake");
                this.m_21557_(false);
            } else if (this.m_5803_() && "start".equals(this.getSleepStage()) && (elapsedTicks = this.m_9236_().m_46467_() - this.sleepStartTime) >= 60L) {
                this.setSleepStage("idle");
                this.setAnimation("sleep_idle");
            }
            if (!this.getSyncedAnimation().equals("undefined")) {
                this.m_6210_();
            }
        }
        if (this.isSwinging() && !this.m_5803_()) {
            long currentTime = this.m_9236_().m_46467_();
            long elapsedTicks = currentTime - this.attackStartTime;
            this.m_21573_().m_26573_();
            if (!this.hasAttacked() && elapsedTicks >= 10L) {
                LivingEntity target = this.m_5448_();
                if (target != null && this.m_20280_((Entity)target) <= 6.25) {
                    this.m_7327_((Entity)target);
                }
                this.setHasAttacked(true);
            }
            if (elapsedTicks >= 18L) {
                this.setSwinging(false);
                this.setAnimation("undefined");
                this.f_20891_ = 0;
            }
        }
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public static void init() {
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (this.m_5803_() && !source.m_276093_(DamageTypes.f_268515_)) {
            this.m_21195_((MobEffect)SlugterraModMobEffects.SLEEPY.get());
            this.setSleeping(false);
            this.setSleepStage("awake");
            this.m_21557_(false);
        }
        return super.m_6469_(source, amount);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
        compound.m_128379_("Sleeping", this.m_5803_());
        compound.m_128359_("SleepStage", this.getSleepStage());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
        if (compound.m_128441_("Sleeping")) {
            boolean wasSleeping = compound.m_128471_("Sleeping");
            this.setSleeping(wasSleeping);
            if (wasSleeping) {
                this.m_21557_(true);
            }
        }
        if (compound.m_128441_("SleepStage")) {
            String stage = compound.m_128461_("SleepStage");
            this.setSleepStage(stage);
            if ("idle".equals(stage)) {
                this.setAnimation("sleep_idle");
            } else if ("start".equals(stage)) {
                this.setAnimation("sleep_start");
            }
        }
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(1.5f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.45);
        builder = builder.m_22268_(Attributes.f_22276_, 150.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 10.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 2.0);
        builder = builder.m_22268_(Attributes.f_22282_, 3.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.m_5803_()) {
            return PlayState.STOP;
        }
        if (this.getSyncedAnimation().equals("undefined")) {
            if (!(this.isSwinging() || !event.isMoving() && event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f)) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("walk"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        String animation;
        if (this.isSwinging() && !this.m_5803_() && !(animation = this.getSyncedAnimation()).equals("undefined")) {
            return event.setAndContinue(RawAnimation.begin().thenPlay(animation));
        }
        return PlayState.CONTINUE;
    }

    private PlayState sleepingPredicate(AnimationState event) {
        String sleepStage;
        if (!this.m_5803_()) {
            return PlayState.STOP;
        }
        String animation = this.getSyncedAnimation();
        switch (sleepStage = this.getSleepStage()) {
            case "start": {
                return event.setAndContinue(RawAnimation.begin().thenPlay("sleep_start"));
            }
            case "idle": {
                return event.setAndContinue(RawAnimation.begin().thenLoop("sleep_idle"));
            }
            case "awake": {
                return event.setAndContinue(RawAnimation.begin().thenPlay("wake_up"));
            }
            case "undefined": {
                return PlayState.CONTINUE;
            }
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        String currentAnimation;
        String string = currentAnimation = !this.animationprocedure.equals("empty") ? this.animationprocedure : this.getSyncedAnimation();
        if (!currentAnimation.equals("undefined") && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay(currentAnimation));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                this.setAnimation("undefined");
                event.getController().forceAnimationReset();
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 5, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 5, this::attackingPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "sleeping", 5, this::sleepingPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 5, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_6094_() {
        return true;
    }

    protected void m_7324_(Entity entity) {
        if (entity instanceof Player && !this.m_21525_() && !this.m_5803_()) {
            this.m_6710_((LivingEntity)entity);
        }
        super.m_7324_(entity);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 2.5f;
    }
}

