/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.entity;

import falconnex.legendsofslugterra.EntityDespawnHandler;
import falconnex.legendsofslugterra.SlugStorage;
import falconnex.legendsofslugterra.SlugWanderGoal;
import falconnex.legendsofslugterra.ThuggletChangeGoal;
import falconnex.legendsofslugterra.ai.SlugHerdPanicGoal;
import falconnex.legendsofslugterra.entity.ai.AvoidTamedSlugHoundGoal;
import falconnex.legendsofslugterra.init.SlugterraModEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PhosphoroEntity
extends TamableAnimal
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(PhosphoroEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(PhosphoroEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(PhosphoroEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> DATA_Damage = SynchedEntityData.m_135353_(PhosphoroEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_Knockback = SynchedEntityData.m_135353_(PhosphoroEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_Speed = SynchedEntityData.m_135353_(PhosphoroEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> LIGHT_ACTIVE = SynchedEntityData.m_135353_(PhosphoroEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final ResourceLocation LIGHT_ON_SOUND = new ResourceLocation("slugterra", "slug_tamed");
    private static final ResourceLocation LIGHT_OFF_SOUND = new ResourceLocation("slugterra", "slug_fail");
    private static final BlockPos INVALID_POS = new BlockPos(0, -64, 0);
    private BlockPos lightBlockPos = INVALID_POS;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public PhosphoroEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<PhosphoroEntity>)((EntityType)SlugterraModEntities.PHOSPHORO.get()), world);
    }

    public PhosphoroEntity(EntityType<PhosphoroEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_274367_(0.6f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"phosphoro");
        this.f_19804_.m_135372_(DATA_Damage, (Object)0);
        this.f_19804_.m_135372_(DATA_Knockback, (Object)0);
        this.f_19804_.m_135372_(DATA_Speed, (Object)1);
        this.f_19804_.m_135372_(LIGHT_ACTIVE, (Object)false);
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new AvoidTamedSlugHoundGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new SlugWanderGoal(this, 0.6));
        this.f_21345_.m_25352_(2, (Goal)new SlugHerdPanicGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new ThuggletChangeGoal(this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slugidle"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slughurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slugdeath"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
        compound.m_128405_("DataDamage", ((Integer)this.f_19804_.m_135370_(DATA_Damage)).intValue());
        compound.m_128405_("DataKnockback", ((Integer)this.f_19804_.m_135370_(DATA_Knockback)).intValue());
        compound.m_128405_("DataSpeed", ((Integer)this.f_19804_.m_135370_(DATA_Speed)).intValue());
        compound.m_128379_("LightActive", ((Boolean)this.f_19804_.m_135370_(LIGHT_ACTIVE)).booleanValue());
        if (this.lightBlockPos != INVALID_POS) {
            compound.m_128365_("LightPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lightBlockPos));
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
        if (compound.m_128441_("DataDamage")) {
            this.f_19804_.m_135381_(DATA_Damage, (Object)compound.m_128451_("DataDamage"));
        }
        if (compound.m_128441_("DataKnockback")) {
            this.f_19804_.m_135381_(DATA_Knockback, (Object)compound.m_128451_("DataKnockback"));
        }
        if (compound.m_128441_("DataSpeed")) {
            this.f_19804_.m_135381_(DATA_Speed, (Object)compound.m_128451_("DataSpeed"));
        }
        if (compound.m_128441_("LightActive")) {
            this.f_19804_.m_135381_(LIGHT_ACTIVE, (Object)compound.m_128471_("LightActive"));
        }
        if (compound.m_128441_("LightPos")) {
            this.lightBlockPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LightPos"));
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        InteractionResult retval = InteractionResult.PASS;
        Item item = itemstack.m_41720_();
        if (itemstack.m_41720_() instanceof SpawnEggItem) {
            retval = super.m_6071_(player, hand);
        } else if (this.m_9236_().m_5776_()) {
            retval = this.m_21824_() && this.m_21830_((LivingEntity)player) || this.m_6898_(itemstack) ? InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_()) : InteractionResult.PASS;
        } else if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)player)) {
                if (item.m_41472_() && this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(player, hand, itemstack);
                    this.m_5634_(item.m_41473_().m_38744_());
                    retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                } else if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(player, hand, itemstack);
                    this.m_5634_(4.0f);
                    retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                } else if (player.m_21205_().m_41619_() && player.m_21206_().m_41619_()) {
                    CompoundTag entityVariables = SlugStorage.GetEntityVariables(this.getPersistentData());
                    if (entityVariables.m_128441_("Thugglet")) {
                        return InteractionResult.PASS;
                    }
                    this.toggleLightAbility(player);
                    player.m_21011_(hand, true);
                    retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                }
            }
        } else if (this.m_6898_(itemstack)) {
            this.m_142075_(player, hand, itemstack);
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
                this.m_21530_();
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        } else {
            retval = super.m_6071_(player, hand);
        }
        return retval;
    }

    private void toggleLightAbility(Player player) {
        boolean isActive = (Boolean)this.f_19804_.m_135370_(LIGHT_ACTIVE) == false;
        this.f_19804_.m_135381_(LIGHT_ACTIVE, (Object)isActive);
        if (isActive) {
            this.activateLight(player);
        } else {
            this.deactivateLight(player);
        }
    }

    private void activateLight(Player player) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            SoundEvent sound;
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.m_20183_().m_7494_();
            if (this.m_9236_().m_46859_(pos)) {
                serverLevel.m_46597_(pos, Blocks.f_152480_.m_49966_());
                this.lightBlockPos = pos;
            }
            if ((sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(LIGHT_ON_SOUND)) != null) {
                serverLevel.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), sound, SoundSource.AMBIENT, 1.0f, 0.9f + this.f_19796_.m_188501_() * 0.2f);
            }
            player.m_5661_((Component)Component.m_237113_((String)("\ud83d\udca1 \u00a7b" + this.m_5446_().getString() + " \u00a7fshines brightly!")), true);
        }
    }

    private void deactivateLight(Player player) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            SoundEvent sound;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.lightBlockPos != INVALID_POS && this.m_9236_().m_8055_(this.lightBlockPos).m_60713_(Blocks.f_152480_)) {
                serverLevel.m_46597_(this.lightBlockPos, Blocks.f_50016_.m_49966_());
                this.lightBlockPos = INVALID_POS;
            }
            if ((sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(LIGHT_OFF_SOUND)) != null) {
                serverLevel.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), sound, SoundSource.AMBIENT, 0.8f, 0.9f + this.f_19796_.m_188501_() * 0.2f);
            }
            player.m_5661_((Component)Component.m_237113_((String)("\ud83c\udf11 \u00a79" + this.m_5446_().getString() + " \u00a7fdims its glow...")), true);
        }
    }

    public void m_6043_() {
        EntityDespawnHandler.handleDespawn((Mob)this);
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public void m_8119_() {
        Level level;
        BlockPos currentPos;
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && ((Boolean)this.f_19804_.m_135370_(LIGHT_ACTIVE)).booleanValue() && this.lightBlockPos != INVALID_POS && !(currentPos = this.m_20183_().m_7494_()).equals((Object)this.lightBlockPos) && this.m_9236_().m_46859_(currentPos) && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_46597_(this.lightBlockPos, Blocks.f_50016_.m_49966_());
            serverLevel.m_46597_(currentPos, Blocks.f_152480_.m_49966_());
            this.lightBlockPos = currentPos;
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_9236_().m_5776_() && this.lightBlockPos != INVALID_POS && this.m_9236_().m_8055_(this.lightBlockPos).m_60713_(Blocks.f_152480_)) {
            this.m_9236_().m_46597_(this.lightBlockPos, Blocks.f_50016_.m_49966_());
        }
        super.m_142687_(reason);
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.0f);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        PhosphoroEntity retval = (PhosphoroEntity)((EntityType)SlugterraModEntities.PHOSPHORO.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return List.of().contains(stack.m_41720_());
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 10.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (event.isMoving() || !(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.NormalSlug.walking"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.NormalSlug.idle"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.m_20185_() - this.f_19790_;
        double d0 = this.m_20189_() - this.f_19792_;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.m_21324_(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.m_9236_().m_46467_();
        }
        if (this.swinging && this.lastSwing + 7L <= this.m_9236_().m_46467_()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.NormalSlug.attack"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 4, this::attackingPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

