/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.entity;

import falconnex.legendsofslugterra.EntityDespawnHandler;
import falconnex.legendsofslugterra.SlugStorage;
import falconnex.legendsofslugterra.SlugWanderGoal;
import falconnex.legendsofslugterra.SlugterraMod;
import falconnex.legendsofslugterra.ThuggletChangeGoal;
import falconnex.legendsofslugterra.ai.SlugHerdPanicGoal;
import falconnex.legendsofslugterra.entity.TexturableEntity;
import falconnex.legendsofslugterra.entity.ai.AvoidTamedSlugHoundGoal;
import falconnex.legendsofslugterra.init.SlugterraModEntities;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SandAnglerEntity
extends TamableAnimal
implements GeoEntity,
TexturableEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(SandAnglerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(SandAnglerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(SandAnglerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> DATA_Damage = SynchedEntityData.m_135353_(SandAnglerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_Knockback = SynchedEntityData.m_135353_(SandAnglerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_Speed = SynchedEntityData.m_135353_(SandAnglerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Random RANDOM = new Random();
    private static final String COOLDOWN_TAG = "cooldown";
    private static final int COOLDOWN_TICKS = 600;
    private static final double WILD_ACTIVATION_CHANCE = 2.0E-4;
    private static final String TUNNELING_TAG = "SandAnglerTunneling";
    private static final TagKey<Block> TUNNELABLE_BLOCKS = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("slugterra", "sand_angler_tunnel"));
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    private static final String[] customTextures = new String[]{"sand_angler_godkip"};
    String prevAnim = "empty";

    private String GetRandomCustomTexture() {
        int randomNumber = ThreadLocalRandom.current().nextInt(0, customTextures.length);
        return customTextures[randomNumber];
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        spawnData = super.m_6518_(world, difficulty, reason, spawnData, dataTag);
        if ((reason == MobSpawnType.NATURAL || reason == MobSpawnType.CHUNK_GENERATION || reason == MobSpawnType.SPAWN_EGG) && this.f_19796_.m_188503_(500) == 0 && world instanceof ServerLevel && !this.m_21824_()) {
            String customTexture = this.GetRandomCustomTexture();
            this.setTexture(customTexture + "_texture");
            this.getPersistentData().m_128359_("customTexture", customTexture);
        }
        return spawnData;
    }

    public SandAnglerEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<SandAnglerEntity>)((EntityType)SlugterraModEntities.SAND_ANGLER.get()), world);
    }

    public SandAnglerEntity(EntityType<SandAnglerEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_274367_(0.6f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"sandangler");
        this.f_19804_.m_135372_(DATA_Damage, (Object)0);
        this.f_19804_.m_135372_(DATA_Knockback, (Object)0);
        this.f_19804_.m_135372_(DATA_Speed, (Object)1);
    }

    @Override
    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    @Override
    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new AvoidTamedSlugHoundGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new SlugWanderGoal(this, 0.6));
        this.f_21345_.m_25352_(2, (Goal)new SlugHerdPanicGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new ThuggletChangeGoal(this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slugidle"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slughurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slugdeath"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268565_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
        compound.m_128405_("DataDamage", ((Integer)this.f_19804_.m_135370_(DATA_Damage)).intValue());
        compound.m_128405_("DataKnockback", ((Integer)this.f_19804_.m_135370_(DATA_Knockback)).intValue());
        compound.m_128405_("DataSpeed", ((Integer)this.f_19804_.m_135370_(DATA_Speed)).intValue());
        compound.m_128356_(COOLDOWN_TAG, this.getPersistentData().m_128454_(COOLDOWN_TAG));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
        if (compound.m_128441_("DataDamage")) {
            this.f_19804_.m_135381_(DATA_Damage, (Object)compound.m_128451_("DataDamage"));
        }
        if (compound.m_128441_("DataKnockback")) {
            this.f_19804_.m_135381_(DATA_Knockback, (Object)compound.m_128451_("DataKnockback"));
        }
        if (compound.m_128441_("DataSpeed")) {
            this.f_19804_.m_135381_(DATA_Speed, (Object)compound.m_128451_("DataSpeed"));
        }
        if (compound.m_128441_(COOLDOWN_TAG)) {
            this.getPersistentData().m_128356_(COOLDOWN_TAG, compound.m_128454_(COOLDOWN_TAG));
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        InteractionResult superResult = super.m_6071_(player, hand);
        if (superResult.m_19077_()) {
            return superResult;
        }
        if (itemstack.m_41619_() && hand == InteractionHand.MAIN_HAND && player.m_21206_().m_41619_() && this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            return this.attemptTunneling(player) ? InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_()) : InteractionResult.FAIL;
        }
        if (this.m_6898_(itemstack)) {
            this.m_142075_(player, hand, itemstack);
            if (this.m_21223_() < this.m_21233_()) {
                this.m_5634_(this.m_21824_() ? 4.0f : 2.0f);
            }
            if (!this.m_21824_() && this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return InteractionResult.PASS;
    }

    private boolean attemptTunneling(Player player) {
        long cooldownEnd;
        SandAnglerEntity entity = this;
        CompoundTag entityData = entity.getPersistentData();
        CompoundTag entityVariables = SlugStorage.GetEntityVariables(entityData);
        if (entityVariables.m_128441_("Thugglet")) {
            return false;
        }
        long currentTime = this.m_9236_().m_46467_();
        if (currentTime < (cooldownEnd = this.getPersistentData().m_128454_(COOLDOWN_TAG))) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slug_fail")), SoundSource.NEUTRAL, 0.5f, 1.0f);
            long remainingSeconds = (cooldownEnd - currentTime) / 20L;
            player.m_5661_((Component)Component.m_237113_((String)("\u00a7e\u23f3 Sand Angler needs " + remainingSeconds + " more seconds!")).m_130940_(ChatFormatting.GOLD), true);
            return false;
        }
        BlockPos pos = this.m_20183_();
        BlockState blockBelow = this.m_9236_().m_8055_(pos.m_7495_());
        if (!blockBelow.m_204336_(TUNNELABLE_BLOCKS)) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u274c Sand Angler can only tunnel in specific blocks!").m_130940_(ChatFormatting.RED), true);
            return false;
        }
        this.startTunneling((Entity)player);
        this.getPersistentData().m_128356_(COOLDOWN_TAG, this.m_9236_().m_46467_() + 600L);
        return true;
    }

    private void startTunneling(Entity owner) {
        if (this.getPersistentData().m_128471_(TUNNELING_TAG)) {
            this.resetAnimation();
            return;
        }
        this.getPersistentData().m_128379_(TUNNELING_TAG, true);
        this.setAnimation("digging");
        BlockPos pos = this.m_20183_();
        this.m_9236_().m_5594_(null, pos, SoundEvents.f_12334_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        BlockState blockState = this.m_9236_().m_8055_(pos.m_7495_());
        SlugterraMod.queueServerWork(100, () -> {
            if (this.getPersistentData().m_128471_(TUNNELING_TAG)) {
                this.resetAnimation();
            }
        });
        SlugterraMod.queueServerWork(20, () -> {
            if (!this.getPersistentData().m_128471_(TUNNELING_TAG)) {
                this.resetAnimation();
                return;
            }
            this.m_6842_(true);
            this.m_20331_(true);
            Level patt15349$temp = this.m_9236_();
            if (patt15349$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt15349$temp;
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5, 20, 0.3, 0.1, 0.3, 0.05);
            }
            this.m_6034_(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_());
            SlugterraMod.queueServerWork(60, () -> this.returnWithLoot(owner, pos));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnWithLoot(Entity owner, BlockPos originalPos) {
        try {
            this.m_6034_((double)originalPos.m_123341_() + 0.5, originalPos.m_123342_(), (double)originalPos.m_123343_() + 0.5);
            this.resetAnimation();
            this.m_9236_().m_5594_(null, originalPos, SoundEvents.f_12331_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockState blockState = this.m_9236_().m_8055_(originalPos.m_7495_());
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), (double)originalPos.m_123341_() + 0.5, (double)originalPos.m_123342_() + 0.1, (double)originalPos.m_123343_() + 0.5, 15, 0.3, 0.1, 0.3, 0.05);
            }
            if (!this.m_9236_().m_5776_()) {
                ItemStack loot = this.getRandomLoot();
                int count = 1 + RANDOM.nextInt(3);
                loot.m_41764_(count);
                if (owner instanceof Player) {
                    Player player = (Player)owner;
                    if (!player.m_150109_().m_36054_(loot)) {
                        player.m_36176_(loot, false);
                    }
                    if (!loot.m_41619_()) {
                        player.m_5661_((Component)Component.m_237113_((String)("\u00a76\u2728 Sand Angler returned with " + count + " " + loot.m_41786_().getString() + "!")), true);
                    }
                } else {
                    this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), (double)originalPos.m_123341_() + 0.5, (double)originalPos.m_123342_() + 0.5, (double)originalPos.m_123343_() + 0.5, loot));
                }
            }
        }
        finally {
            this.resetAnimation();
        }
    }

    private void resetAnimation() {
        this.setAnimation("empty");
        this.getPersistentData().m_128379_(TUNNELING_TAG, false);
        this.m_6842_(false);
        this.m_20331_(false);
    }

    private ItemStack getRandomLoot() {
        ItemStack stack = switch (RANDOM.nextInt(10)) {
            case 0 -> new ItemStack((ItemLike)Items.f_42518_);
            case 1 -> new ItemStack((ItemLike)Items.f_42500_);
            case 2 -> new ItemStack((ItemLike)Items.f_42583_);
            case 3 -> new ItemStack((ItemLike)Items.f_41830_);
            case 4 -> new ItemStack((ItemLike)Items.f_41832_);
            case 5 -> new ItemStack((ItemLike)Items.f_42403_);
            case 6 -> new ItemStack((ItemLike)Items.f_42461_);
            case 7 -> new ItemStack((ItemLike)Items.f_42401_);
            case 8 -> new ItemStack((ItemLike)Items.f_42525_);
            default -> new ItemStack((ItemLike)Items.f_42499_);
        };
        return stack.m_41619_() ? new ItemStack((ItemLike)Items.f_42499_) : stack;
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
        if (!this.m_9236_().m_5776_() && !this.m_21824_() && RANDOM.nextDouble() < 2.0E-4) {
            BlockPos pos = this.m_20183_();
            if (this.m_9236_().m_8055_(pos.m_7495_()).m_204336_(TUNNELABLE_BLOCKS) && this.getPersistentData().m_128454_(COOLDOWN_TAG) <= this.m_9236_().m_46467_()) {
                this.startWildTunneling();
            }
        }
    }

    private void startWildTunneling() {
        if (this.getPersistentData().m_128471_(TUNNELING_TAG)) {
            this.resetAnimation();
            return;
        }
        this.getPersistentData().m_128379_(TUNNELING_TAG, true);
        this.setAnimation("digging");
        BlockPos pos = this.m_20183_();
        this.m_9236_().m_5594_(null, pos, SoundEvents.f_12334_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        BlockState blockState = this.m_9236_().m_8055_(pos.m_7495_());
        SlugterraMod.queueServerWork(100, () -> {
            if (this.getPersistentData().m_128471_(TUNNELING_TAG)) {
                this.resetAnimation();
            }
        });
        SlugterraMod.queueServerWork(20, () -> {
            if (!this.getPersistentData().m_128471_(TUNNELING_TAG)) {
                this.resetAnimation();
                return;
            }
            this.m_6842_(true);
            this.m_20331_(true);
            Level patt20693$temp = this.m_9236_();
            if (patt20693$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt20693$temp;
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5, 20, 0.3, 0.1, 0.3, 0.05);
            }
            this.m_6034_(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_());
            SlugterraMod.queueServerWork(60, () -> this.returnWithWildLoot(pos));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnWithWildLoot(BlockPos originalPos) {
        try {
            this.m_6034_((double)originalPos.m_123341_() + 0.5, originalPos.m_123342_(), (double)originalPos.m_123343_() + 0.5);
            this.resetAnimation();
            this.m_9236_().m_5594_(null, originalPos, SoundEvents.f_12331_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockState blockState = this.m_9236_().m_8055_(originalPos.m_7495_());
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), (double)originalPos.m_123341_() + 0.5, (double)originalPos.m_123342_() + 0.1, (double)originalPos.m_123343_() + 0.5, 15, 0.3, 0.1, 0.3, 0.05);
            }
            if (!this.m_9236_().m_5776_()) {
                ItemStack loot = this.getRandomLoot();
                int count = 1 + RANDOM.nextInt(3);
                loot.m_41764_(count);
                this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), (double)originalPos.m_123341_() + 0.5, (double)originalPos.m_123342_() + 0.5, (double)originalPos.m_123343_() + 0.5, loot));
            }
        }
        finally {
            this.resetAnimation();
        }
    }

    public void m_6043_() {
        EntityDespawnHandler.handleDespawn((Mob)this);
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(1.0f);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        SandAnglerEntity retval = (SandAnglerEntity)((EntityType)SlugterraModEntities.SAND_ANGLER.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return List.of().contains(stack.m_41720_());
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 10.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (event.isMoving() || !(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("walking"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.m_20185_() - this.f_19790_;
        double d0 = this.m_20189_() - this.f_19792_;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.m_21324_(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.m_9236_().m_46467_();
        }
        if (this.swinging && this.lastSwing + 7L <= this.m_9236_().m_46467_()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.NormalSlug.attack"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 4, this::attackingPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

