/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.entity;

import falconnex.legendsofslugterra.entity.ai.HuntSlugsGoal;
import falconnex.legendsofslugterra.init.SlugterraModEntities;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SlugHoundEntity
extends TamableAnimal
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(SlugHoundEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(SlugHoundEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(SlugHoundEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(SlugHoundEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private long lastSwing;
    public String animationprocedure = "empty";
    private int inLove;
    @Nullable
    private UUID loveCause;
    private boolean huntingEnabled = true;
    private static final String[] TEXTURE_VARIANTS = new String[]{"SlugHoundSpots", "SlugHoundPurple", "SlugHoundBlue"};
    private static final float[] VARIANT_WEIGHTS = new float[]{0.6f, 0.3f, 0.1f};

    public SlugHoundEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<SlugHoundEntity>)((EntityType)SlugterraModEntities.SLUG_HOUND.get()), world);
    }

    public SlugHoundEntity(EntityType<SlugHoundEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 1;
        this.m_21557_(false);
        this.m_274367_(1.0f);
        if (!world.f_46443_) {
            this.setTexture(this.getRandomTextureVariant());
        }
    }

    private String getRandomTextureVariant() {
        float randomValue = this.f_19796_.m_188501_();
        float cumulativeWeight = 0.0f;
        for (int i = 0; i < VARIANT_WEIGHTS.length; ++i) {
            if (!(randomValue <= (cumulativeWeight += VARIANT_WEIGHTS[i]))) continue;
            return TEXTURE_VARIANTS[i];
        }
        return TEXTURE_VARIANTS[0];
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"slughound");
        this.f_19804_.m_135372_(SITTING, (Object)false);
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        spawnData = super.m_6518_(world, difficulty, reason, spawnData, dataTag);
        if (reason == MobSpawnType.NATURAL || reason == MobSpawnType.CHUNK_GENERATION) {
            if (!this.m_6162_() && this.f_19796_.m_188503_(4) == 0 && world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                SlugHoundEntity baby = (SlugHoundEntity)((EntityType)SlugterraModEntities.SLUG_HOUND.get()).m_20615_((Level)serverWorld);
                if (baby != null) {
                    double offsetX = this.f_19796_.m_188500_() * 2.0 - 1.0;
                    double offsetZ = this.f_19796_.m_188500_() * 2.0 - 1.0;
                    baby.m_7678_(this.m_20185_() + offsetX, this.m_20186_(), this.m_20189_() + offsetZ, this.m_146908_(), 0.0f);
                    baby.m_146762_(-24000);
                    baby.setTexture(this.getRandomTextureVariant());
                    baby.m_6518_((ServerLevelAccessor)serverWorld, difficulty, MobSpawnType.NATURAL, null, null);
                }
            }
            if (!this.m_21824_()) {
                this.setTexture(this.getRandomTextureVariant());
            }
        }
        return spawnData;
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public void setSitting(boolean sitting) {
        this.f_19804_.m_135381_(SITTING, (Object)sitting);
        this.m_21839_(sitting);
    }

    public void m_21839_(boolean sitting) {
        this.f_19804_.m_135381_(SITTING, (Object)sitting);
        if (sitting) {
            this.m_6710_(null);
        }
    }

    public boolean m_21827_() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public boolean isHuntingEnabled() {
        return this.huntingEnabled;
    }

    public void setHuntingEnabled(boolean enabled) {
        this.huntingEnabled = enabled;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SitWhenOrderedToGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        if (!this.m_6162_()) {
            this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, false));
            this.f_21345_.m_25352_(6, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        }
        this.f_21345_.m_25352_(3, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false){

            public boolean m_8036_() {
                return !SlugHoundEntity.this.m_21827_() && super.m_8036_();
            }

            public boolean m_8045_() {
                return !SlugHoundEntity.this.m_21827_() && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42500_}), false));
        this.f_21345_.m_25352_(7, (Goal)new SlugHoundFollowParentGoal(this, 1.1){

            @Override
            public boolean m_8036_() {
                return !SlugHoundEntity.this.m_21827_() && super.m_8036_();
            }

            @Override
            public boolean m_8045_() {
                return !SlugHoundEntity.this.m_21827_() && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new HuntSlugsGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean m_8036_() {
                return !SlugHoundEntity.this.m_21827_() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, livingEntity -> {
            TamableAnimal tamable;
            if (this.m_6162_()) {
                return false;
            }
            if (livingEntity instanceof TamableAnimal && (tamable = (TamableAnimal)livingEntity).m_21824_() && tamable.m_269323_() != null && this.m_269323_() != null && tamable.m_269323_().equals((Object)this.m_269323_())) {
                return false;
            }
            if (!this.m_21824_()) {
                return livingEntity instanceof Player;
            }
            if (this.m_269323_() instanceof Player) {
                Player owner = (Player)this.m_269323_();
                return livingEntity == owner.m_21188_() || livingEntity == owner.m_21214_() || livingEntity == this.m_21188_();
            }
            return false;
        }));
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        TamableAnimal tamable;
        if (this.m_6162_()) {
            return false;
        }
        if (target instanceof TamableAnimal && (tamable = (TamableAnimal)target).m_21824_() && tamable.m_269323_() != null && this.m_269323_() != null && tamable.m_269323_().equals((Object)this.m_269323_())) {
            return false;
        }
        if (this.m_21824_() && owner instanceof Player) {
            Player playerOwner = (Player)owner;
            return target == playerOwner.m_21188_() || target == playerOwner.m_21214_() || target == this.m_21188_();
        }
        return !this.m_21824_() && target instanceof Player;
    }

    public void m_21828_(Player player) {
        super.m_21828_(player);
        this.m_21816_(player.m_20148_());
        String currentTexture = this.getTexture();
        if (!currentTexture.endsWith("Collar")) {
            this.setTexture(currentTexture + "Collar");
        }
        this.f_21346_.m_25352_(4, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            if (player.m_6144_() && itemstack.m_41619_()) {
                this.setHuntingEnabled(!this.isHuntingEnabled());
                String message = this.isHuntingEnabled() ? "Slug Hound hunting enabled" : "Slug Hound hunting disabled";
                player.m_5661_((Component)Component.m_237113_((String)message), true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            if (itemstack.m_41619_() && !player.m_6144_()) {
                this.m_21839_(!this.m_21827_());
                this.m_21573_().m_26573_();
                this.m_6710_(null);
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            if (this.isBreedingItem(itemstack) && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(4.0f);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        if (!this.m_21824_() && this.m_6162_() && itemstack.m_150930_(Items.f_42500_)) {
            if (!this.m_9236_().m_5776_()) {
                if (this.f_19796_.m_188503_(3) == 0) {
                    this.m_21828_(player);
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                    this.m_21839_(true);
                    if (!player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                this.m_9236_().m_7605_((Entity)this, (byte)6);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (this.m_21824_() && this.isBreedingItem(itemstack)) {
            if (this.m_146764_() == 0 && this.m_5957_()) {
                this.m_142075_(player, hand, itemstack);
                this.m_27595_(player);
                return InteractionResult.SUCCESS;
            }
            if (this.m_6162_()) {
                this.m_142075_(player, hand, itemstack);
                this.m_146740_((int)((float)(-this.m_146764_() / 20) * 0.1f), true);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    public boolean isBreedingItem(ItemStack stack) {
        TagKey tag = ForgeRegistries.ITEMS.tags().createTagKey(new ResourceLocation("slugterra", "slug_hound_food"));
        return stack.m_204117_(tag);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        SlugHoundEntity baby = (SlugHoundEntity)((EntityType)SlugterraModEntities.SLUG_HOUND.get()).m_20615_((Level)serverWorld);
        baby.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(baby.m_20183_()), MobSpawnType.BREEDING, null, null);
        if (this.m_21805_() != null) {
            baby.m_21816_(this.m_21805_());
            baby.m_7105_(true);
            baby.setTexture(this.getTexture());
        } else if (ageable instanceof SlugHoundEntity && ((SlugHoundEntity)ageable).m_21805_() != null) {
            baby.m_21816_(((SlugHoundEntity)ageable).m_21805_());
            baby.m_7105_(true);
            baby.setTexture(((SlugHoundEntity)ageable).getTexture());
        } else {
            baby.setTexture(this.getRandomTextureVariant());
        }
        return baby;
    }

    public boolean m_5957_() {
        return super.m_5957_() && !this.m_21827_();
    }

    public void m_27595_(@Nullable Player player) {
        if (this.m_21827_()) {
            return;
        }
        this.inLove = 600;
        if (player != null) {
            this.loveCause = player.m_20148_();
        }
        this.m_9236_().m_7605_((Entity)this, (byte)18);
        if (!this.m_9236_().f_46443_) {
            this.m_27601_(this.inLove);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_20068_() && !this.m_20072_()) {
            Vec3 vec3 = this.m_20184_();
            this.m_20334_(vec3.f_82479_, vec3.f_82480_ - 0.08, vec3.f_82481_);
        }
        if (this.m_21827_()) {
            this.m_21573_().m_26573_();
            this.m_20256_(new Vec3(0.0, this.m_20184_().f_82480_, 0.0));
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        }
        if (this.inLove > 0) {
            --this.inLove;
            if (this.inLove % 10 == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(0.5), this.m_20187_() + 0.5, this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
        compound.m_128405_("InLove", this.inLove);
        if (this.loveCause != null) {
            compound.m_128362_("LoveCause", this.loveCause);
        }
        compound.m_128379_("Sitting", this.m_21827_());
        compound.m_128379_("HuntingEnabled", this.huntingEnabled);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
        this.inLove = compound.m_128451_("InLove");
        UUID uUID = this.loveCause = compound.m_128403_("LoveCause") ? compound.m_128342_("LoveCause") : null;
        if (this.inLove > 0) {
            this.m_27601_(this.inLove);
        }
        this.m_21839_(compound.m_128471_("Sitting"));
        if (compound.m_128441_("HuntingEnabled")) {
            this.huntingEnabled = compound.m_128471_("HuntingEnabled");
        }
    }

    private PlayState movementPredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty")) {
            return PlayState.STOP;
        }
        if (this.m_21827_()) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("sit_idle"));
        }
        double movement = this.m_20184_().m_165925_();
        if (movement > 0.001) {
            return event.setAndContinue(RawAnimation.begin().thenLoop(this.m_5912_() ? "run" : "walk"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.m_20185_() - this.f_19790_;
        double d0 = this.m_20189_() - this.f_19792_;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.m_21324_(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.m_9236_().m_46467_();
        }
        if (this.swinging && this.lastSwing + 8L <= this.m_9236_().m_46467_()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("attack"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 4, this::attackingPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22283_, 4.0);
    }

    public static void init() {
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    private static class SitWhenOrderedToGoal
    extends Goal {
        private final SlugHoundEntity slugHound;

        public SitWhenOrderedToGoal(SlugHoundEntity slugHound) {
            this.slugHound = slugHound;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!this.slugHound.m_21824_()) {
                return false;
            }
            if (this.slugHound.m_20072_()) {
                return false;
            }
            if (!this.slugHound.m_20096_()) {
                return false;
            }
            return this.slugHound.m_21827_();
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            this.slugHound.m_21573_().m_26573_();
            this.slugHound.m_20256_(Vec3.f_82478_);
            this.slugHound.m_6710_(null);
        }

        public void m_8037_() {
            if (this.slugHound.m_21573_().m_26572_()) {
                this.slugHound.m_21573_().m_26573_();
            }
        }
    }

    private static class SlugHoundFollowParentGoal
    extends FollowParentGoal {
        private final SlugHoundEntity slugHound;

        public SlugHoundFollowParentGoal(SlugHoundEntity slugHound, double speedModifier) {
            super((Animal)slugHound, speedModifier);
            this.slugHound = slugHound;
        }

        public boolean m_8036_() {
            if (this.slugHound.m_21824_()) {
                return false;
            }
            if (this.slugHound.m_21827_()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (this.slugHound.m_21824_()) {
                return false;
            }
            if (this.slugHound.m_21827_()) {
                return false;
            }
            return super.m_8045_();
        }
    }
}

