/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.network;

import falconnex.legendsofslugterra.SlugterraMod;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SlugterraModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        SlugterraMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.Shooter = message.data.Shooter;
                    variables.VelocimorphAirAbilityActivation = message.data.VelocimorphAirAbilityActivation;
                    variables.VelocimorphGravityActivation = message.data.VelocimorphGravityActivation;
                    variables.GrappleX = message.data.GrappleX;
                    variables.GrappleY = message.data.GrappleY;
                    variables.GrappleZ = message.data.GrappleZ;
                    variables.GrappleN = message.data.GrappleN;
                    variables.GrappleV = message.data.GrappleV;
                    variables.GrappleActive = message.data.GrappleActive;
                    variables.MovementX = message.data.MovementX;
                    variables.MovementY = message.data.MovementY;
                    variables.MovementZ = message.data.MovementZ;
                    variables.MovementN = message.data.MovementN;
                    variables.PoleroTrapped = message.data.PoleroTrapped;
                    variables.PlayerSpawnCarriageOnTravel = message.data.PlayerSpawnCarriageOnTravel;
                    variables.PlayerRes = message.data.PlayerRes;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean Shooter = false;
        public boolean VelocimorphAirAbilityActivation = false;
        public boolean VelocimorphGravityActivation = false;
        public double GrappleX = 0.0;
        public double GrappleY = 0.0;
        public double GrappleZ = 0.0;
        public double GrappleN = 0.0;
        public double GrappleV = 0.0;
        public boolean GrappleActive = false;
        public double MovementX = 0.0;
        public double MovementY = 0.0;
        public double MovementZ = 0.0;
        public double MovementN = 0.0;
        public boolean PoleroTrapped = false;
        public boolean PlayerSpawnCarriageOnTravel = false;
        public double PlayerRes = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                SlugterraMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("Shooter", this.Shooter);
            nbt.m_128379_("VelocimorphAirAbilityActivation", this.VelocimorphAirAbilityActivation);
            nbt.m_128379_("VelocimorphGravityActivation", this.VelocimorphGravityActivation);
            nbt.m_128347_("GrappleX", this.GrappleX);
            nbt.m_128347_("GrappleY", this.GrappleY);
            nbt.m_128347_("GrappleZ", this.GrappleZ);
            nbt.m_128347_("GrappleN", this.GrappleN);
            nbt.m_128347_("GrappleV", this.GrappleV);
            nbt.m_128379_("GrappleActive", this.GrappleActive);
            nbt.m_128347_("MovementX", this.MovementX);
            nbt.m_128347_("MovementY", this.MovementY);
            nbt.m_128347_("MovementZ", this.MovementZ);
            nbt.m_128347_("MovementN", this.MovementN);
            nbt.m_128379_("PoleroTrapped", this.PoleroTrapped);
            nbt.m_128379_("PlayerSpawnCarriageOnTravel", this.PlayerSpawnCarriageOnTravel);
            nbt.m_128347_("PlayerRes", this.PlayerRes);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.Shooter = nbt.m_128471_("Shooter");
            this.VelocimorphAirAbilityActivation = nbt.m_128471_("VelocimorphAirAbilityActivation");
            this.VelocimorphGravityActivation = nbt.m_128471_("VelocimorphGravityActivation");
            this.GrappleX = nbt.m_128459_("GrappleX");
            this.GrappleY = nbt.m_128459_("GrappleY");
            this.GrappleZ = nbt.m_128459_("GrappleZ");
            this.GrappleN = nbt.m_128459_("GrappleN");
            this.GrappleV = nbt.m_128459_("GrappleV");
            this.GrappleActive = nbt.m_128471_("GrappleActive");
            this.MovementX = nbt.m_128459_("MovementX");
            this.MovementY = nbt.m_128459_("MovementY");
            this.MovementZ = nbt.m_128459_("MovementZ");
            this.MovementN = nbt.m_128459_("MovementN");
            this.PoleroTrapped = nbt.m_128471_("PoleroTrapped");
            this.PlayerSpawnCarriageOnTravel = nbt.m_128471_("PlayerSpawnCarriageOnTravel");
            this.PlayerRes = nbt.m_128459_("PlayerRes");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("slugterra", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.GrappleX = original.GrappleX;
            clone.GrappleY = original.GrappleY;
            clone.GrappleZ = original.GrappleZ;
            clone.GrappleN = original.GrappleN;
            clone.GrappleV = original.GrappleV;
            clone.GrappleActive = original.GrappleActive;
            clone.MovementY = original.MovementY;
            clone.MovementZ = original.MovementZ;
            clone.MovementN = original.MovementN;
            clone.PlayerRes = original.PlayerRes;
            if (!event.isWasDeath()) {
                clone.Shooter = original.Shooter;
                clone.VelocimorphAirAbilityActivation = original.VelocimorphAirAbilityActivation;
                clone.VelocimorphGravityActivation = original.VelocimorphGravityActivation;
                clone.MovementX = original.MovementX;
                clone.PoleroTrapped = original.PoleroTrapped;
                clone.PlayerSpawnCarriageOnTravel = original.PlayerSpawnCarriageOnTravel;
            }
        }
    }
}

