/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.procedures;

import falconnex.legendsofslugterra.SlugStorage;
import falconnex.legendsofslugterra.entity.FlaringoEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class FlaringoProtoAbilityProcedure {
    private static final Random RANDOM = new Random();
    private static final int DEFAULT_COOLDOWN = 600;
    private static final double WILD_SNEEZE_CHANCE = 2.0E-4;
    private static final int FIRE_DURATION = 2;
    private static final double EFFECT_RADIUS = 2.0;

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        int cooldownTicks;
        FlaringoEntity flaringo;
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        Entity entity = event.getTarget();
        if (!(entity instanceof FlaringoEntity) || !(flaringo = (FlaringoEntity)entity).m_21824_()) {
            return;
        }
        if (!event.getEntity().m_21205_().m_41619_()) {
            return;
        }
        Level world = flaringo.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        CompoundTag persistentData = flaringo.getPersistentData();
        CompoundTag protoTag = persistentData.m_128441_("proto") ? persistentData.m_128469_("proto") : new CompoundTag();
        long currentTime = world.m_46467_();
        long cooldownEnd = protoTag.m_128441_("cooldown") ? protoTag.m_128454_("cooldown") : 0L;
        int n = cooldownTicks = protoTag.m_128441_("cooldownTicks") ? protoTag.m_128451_("cooldownTicks") : 600;
        if (currentTime < cooldownEnd) {
            Player eventEntity = event.getEntity();
            if (eventEntity instanceof Player) {
                Player player = eventEntity;
                long remaining = (cooldownEnd - currentTime) / 20L;
                player.m_5661_((Component)Component.m_237113_((String)("\u23f3 Flaringo needs " + remaining + " more seconds!")).m_130940_(ChatFormatting.GOLD), true);
                world.m_5594_(null, flaringo.m_20183_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slug_fail")), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return;
        }
        FlaringoProtoAbilityProcedure.triggerSneeze(world, flaringo);
        protoTag.m_128356_("cooldown", currentTime + (long)cooldownTicks);
        persistentData.m_128365_("proto", (Tag)protoTag);
        Player eventEntity = event.getEntity();
        if (eventEntity instanceof Player) {
            Player player = eventEntity;
            player.m_5661_((Component)Component.m_237113_((String)"\ud83d\udd25 Flaringo sneezed fire everywhere!").m_130940_(ChatFormatting.GOLD), true);
        }
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        LivingEntity entity = event.getEntity();
        CompoundTag entityData = entity.getPersistentData();
        CompoundTag entityVariables = SlugStorage.GetEntityVariables(entityData);
        if (entityVariables.m_128441_("Thugglet")) {
            return;
        }
        if (!(entity instanceof FlaringoEntity)) {
            return;
        }
        FlaringoEntity flaringo = (FlaringoEntity)entity;
        Level world = flaringo.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        if (!flaringo.m_21824_() && RANDOM.nextDouble() < 2.0E-4) {
            FlaringoProtoAbilityProcedure.triggerSneeze(world, flaringo);
        }
    }

    private static void triggerSneeze(Level world, FlaringoEntity flaringo) {
        flaringo.setAnimation("sneeze");
        world.m_5594_(null, flaringo.m_20183_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:flaringo_proto")), SoundSource.PLAYERS, 0.75f, 1.0f);
        AABB area = new AABB(flaringo.m_20183_()).m_82400_(2.0);
        List targets = world.m_6443_(LivingEntity.class, area, e -> e != flaringo && (!(e instanceof Player) || !flaringo.m_21830_((LivingEntity)((Player)e))));
        for (LivingEntity target : targets) {
            target.m_20254_(2);
        }
        FlaringoProtoAbilityProcedure.triggerPhotonCommand(world, flaringo);
    }

    private static void triggerPhotonCommand(Level world, FlaringoEntity flaringo) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_7654_().m_129892_().m_230957_(new CommandSourceStack(CommandSource.f_80164_, flaringo.m_20182_(), flaringo.m_20155_(), serverWorld, 4, flaringo.m_7755_().getString(), flaringo.m_5446_(), serverWorld.m_7654_(), (Entity)flaringo), "photon fx photon:flaringo_proto entity @s");
        }
    }
}

