/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.procedures;

import falconnex.legendsofslugterra.SlugStorage;
import falconnex.legendsofslugterra.entity.FlatulorhinkusEntity;
import falconnex.legendsofslugterra.init.SlugterraModSounds;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class FlatulorhinkusProtoAbilityProcedure {
    private static final Random RANDOM = new Random();
    private static final double WILD_TRIGGER_CHANCE = 5.0E-4;
    private static final int DEFAULT_COOLDOWN = 600;
    private static final double RADIUS = 1.2;
    private static final int EFFECT_DURATION = 100;

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        int cooldownTicks;
        FlatulorhinkusEntity flatulorhinkus;
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        Entity entity = event.getTarget();
        if (!(entity instanceof FlatulorhinkusEntity) || !(flatulorhinkus = (FlatulorhinkusEntity)entity).m_21824_()) {
            return;
        }
        if (!event.getEntity().m_21205_().m_41619_()) {
            return;
        }
        Level world = flatulorhinkus.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        CompoundTag persistentData = flatulorhinkus.getPersistentData();
        CompoundTag protoData = persistentData.m_128441_("proto") ? persistentData.m_128469_("proto") : new CompoundTag();
        long currentTime = world.m_46467_();
        long lastUsedTime = protoData.m_128454_("cooldown");
        int n = cooldownTicks = protoData.m_128441_("cooldownTicks") ? protoData.m_128451_("cooldownTicks") : 600;
        if (currentTime - lastUsedTime < (long)cooldownTicks) {
            if (event.getEntity() instanceof Player) {
                Player player = event.getEntity();
                int remaining = (int)(((long)cooldownTicks - (currentTime - lastUsedTime)) / 20L);
                player.m_5661_((Component)Component.m_237113_((String)"\u23f3 ").m_7220_((Component)Component.m_237113_((String)("Flatulorhinkus needs " + remaining + "s to release more gas!")).m_130940_(ChatFormatting.DARK_PURPLE)), true);
                world.m_5594_(null, flatulorhinkus.m_20183_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slug_fail")), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return;
        }
        FlatulorhinkusProtoAbilityProcedure.triggerPhotonCommand(world, flatulorhinkus);
        FlatulorhinkusProtoAbilityProcedure.applyEffects(world, flatulorhinkus);
        protoData.m_128356_("cooldown", currentTime);
        persistentData.m_128365_("proto", (Tag)protoData);
        if (event.getEntity() instanceof Player) {
            Player player = event.getEntity();
            player.m_5661_((Component)Component.m_237113_((String)"\ud83d\udca8 ").m_7220_((Component)Component.m_237113_((String)"Flatulorhinkus released a toxic gas cloud!").m_130940_(ChatFormatting.LIGHT_PURPLE)), true);
        }
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        FlatulorhinkusEntity flatulorhinkus;
        Level world;
        block7: {
            block6: {
                if (event.getEntity().m_9236_().f_46443_) {
                    return;
                }
                LivingEntity entity = event.getEntity();
                CompoundTag entityData = entity.getPersistentData();
                CompoundTag entityVariables = SlugStorage.GetEntityVariables(entityData);
                if (entityVariables.m_128441_("Thugglet")) {
                    return;
                }
                world = entity.m_9236_();
                if (!(entity instanceof FlatulorhinkusEntity)) break block6;
                flatulorhinkus = (FlatulorhinkusEntity)entity;
                if (!world.m_5776_() && !flatulorhinkus.m_21824_()) break block7;
            }
            return;
        }
        if (RANDOM.nextDouble() < 5.0E-4) {
            FlatulorhinkusProtoAbilityProcedure.triggerPhotonCommand(world, flatulorhinkus);
            FlatulorhinkusProtoAbilityProcedure.applyEffects(world, flatulorhinkus);
        }
    }

    private static void triggerPhotonCommand(Level world, FlatulorhinkusEntity flatulorhinkus) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_7654_().m_129892_().m_230957_(new CommandSourceStack(CommandSource.f_80164_, flatulorhinkus.m_20182_(), flatulorhinkus.m_20155_(), serverWorld, 4, flatulorhinkus.m_7755_().getString(), flatulorhinkus.m_5446_(), serverWorld.m_7654_(), (Entity)flatulorhinkus), "photon fx photon:flatulorhinkus_proto entity @s");
            world.m_5594_(null, flatulorhinkus.m_20183_(), (SoundEvent)SlugterraModSounds.GAS_SLUG_IMPACT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private static void applyEffects(Level world, FlatulorhinkusEntity flatulorhinkus) {
        AABB area = new AABB(flatulorhinkus.m_20183_()).m_82400_(1.2);
        List entities = world.m_6443_(LivingEntity.class, area, e -> e != flatulorhinkus);
        for (LivingEntity target : entities) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, 0, false, false));
        }
    }
}

