/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.procedures;

import falconnex.legendsofslugterra.SlugStorage;
import falconnex.legendsofslugterra.entity.FrightgeistEntity;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class FrightgeistProtoAbilityProcedure {
    private static final String ABILITY_ACTIVE_TAG = "FrightgeistAbilityActive";
    private static final ResourceLocation CAVE_AMBIENCE = new ResourceLocation("minecraft:ambient.cave");
    private static final ResourceLocation[] MONSTER_SOUNDS = new ResourceLocation[]{new ResourceLocation("minecraft:entity.zombie.ambient"), new ResourceLocation("minecraft:entity.enderman.scream"), new ResourceLocation("minecraft:entity.ghast.scream"), new ResourceLocation("minecraft:entity.witch.celebrate"), new ResourceLocation("minecraft:entity.blaze.ambient"), new ResourceLocation("minecraft:entity.zombie_villager.ambient"), new ResourceLocation("minecraft:entity.pillager.celebrate"), new ResourceLocation("minecraft:entity.evoker.prepare_attack"), new ResourceLocation("minecraft:entity.evoker.cast_spell"), new ResourceLocation("minecraft:entity.vindicator.ambient"), new ResourceLocation("minecraft:entity.illusioner.mirror_move"), new ResourceLocation("minecraft:entity.illusioner.cast_spell"), new ResourceLocation("minecraft:entity.husk.ambient"), new ResourceLocation("minecraft:entity.drowned.ambient"), new ResourceLocation("minecraft:entity.phantom.ambient"), new ResourceLocation("minecraft:entity.warden.heartbeat"), new ResourceLocation("minecraft:entity.warden.angry"), new ResourceLocation("minecraft:entity.warden.listening"), new ResourceLocation("minecraft:entity.warden.nearby_close"), new ResourceLocation("minecraft:entity.warden.nearby_closer"), new ResourceLocation("minecraft:entity.warden.roar"), new ResourceLocation("minecraft:entity.warden.sniff"), new ResourceLocation("minecraft:entity.warden.attack_impact"), new ResourceLocation("minecraft:entity.ghast.warn")};
    private static final int SOUND_CHANCE = 200;
    private static final int BLINDNESS_DURATION = 100;

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        Entity entity = event.getTarget();
        if (!(entity instanceof FrightgeistEntity)) {
            return;
        }
        FrightgeistEntity frightgeist = (FrightgeistEntity)entity;
        Player player = event.getEntity();
        if (player == null || !player.m_21205_().m_41619_()) {
            return;
        }
        FrightgeistProtoAbilityProcedure.execute(frightgeist, player);
    }

    private static void execute(FrightgeistEntity frightgeist, Player player) {
        if (!frightgeist.m_21824_() || frightgeist.m_269323_() != player) {
            return;
        }
        CompoundTag protoTag = frightgeist.getPersistentData().m_128469_("proto");
        boolean isActive = protoTag.m_128471_(ABILITY_ACTIVE_TAG);
        String frightgeistName = frightgeist.m_7755_().getString();
        protoTag.m_128379_(ABILITY_ACTIVE_TAG, !isActive);
        frightgeist.getPersistentData().m_128365_("proto", (Tag)protoTag);
        if (isActive) {
            player.m_5661_((Component)Component.m_237113_((String)("\ud83d\udc80 \u00a7f" + frightgeistName + " \u00a7afalls silent...")), true);
        } else {
            player.m_5661_((Component)Component.m_237113_((String)("\ud83d\udc7b \u00a7f" + frightgeistName + " \u00a7aawakens the darkness!")), true);
        }
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        LivingEntity entity = event.getEntity();
        CompoundTag entityData = entity.getPersistentData();
        CompoundTag entityVariables = SlugStorage.GetEntityVariables(entityData);
        if (entityVariables.m_128441_("Thugglet")) {
            return;
        }
        Level world = entity.m_9236_();
        if (!(entity instanceof FrightgeistEntity) || world.m_5776_()) {
            return;
        }
        CompoundTag protoTag = entity.getPersistentData().m_128469_("proto");
        if (!protoTag.m_128471_(ABILITY_ACTIVE_TAG)) {
            return;
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (new Random().nextInt(200) == 0) {
                ResourceLocation sound = MONSTER_SOUNDS[new Random().nextInt(MONSTER_SOUNDS.length)];
                FrightgeistProtoAbilityProcedure.playSound(serverWorld, entity.m_20183_(), sound, 1.5f);
            }
        }
    }

    @SubscribeEvent
    public static void onFrightgeistDamaged(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof FrightgeistEntity)) {
            return;
        }
        FrightgeistEntity frightgeist = (FrightgeistEntity)livingEntity;
        Entity attacker = event.getSource().m_7639_();
        if (!(attacker instanceof Player)) {
            return;
        }
        Player player = (Player)attacker;
        if (!frightgeist.m_21824_() || frightgeist.m_269323_() != player) {
            FrightgeistProtoAbilityProcedure.playSoundForPlayer(player, CAVE_AMBIENCE, 1.0f);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0, false, true));
        }
    }

    private static void playSound(ServerLevel world, BlockPos pos, ResourceLocation soundId, float volume) {
        SoundEvent soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundId);
        if (soundEvent != null) {
            world.m_5594_(null, pos, soundEvent, SoundSource.HOSTILE, volume, 1.0f);
        }
    }

    private static void playSoundForPlayer(Player player, ResourceLocation soundId, float volume) {
        Level level;
        SoundEvent soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundId);
        if (soundEvent != null && (level = player.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            serverWorld.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, SoundSource.PLAYERS, volume, 1.0f);
        }
    }
}

