/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.procedures;

import falconnex.legendsofslugterra.SlugterraMod;
import falconnex.legendsofslugterra.init.SlugterraModMobEffects;
import falconnex.legendsofslugterra.procedures.TameProtoAfterImpactSpawnCallProcedure;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class FrostcrawlerHitsEntityProcedure {
    private static final Set<BlockPos> placedIceBlocks = new HashSet<BlockPos>();
    private static final TagKey<EntityType<?>> VELOCIMORPH_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("slugterra", "velocimorph"));

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity, Entity immediatesourceentity, Entity sourceentity) {
        if (entity == null || immediatesourceentity == null || sourceentity == null) {
            return;
        }
        if (!entity.m_20149_().equals(sourceentity.m_20149_())) {
            boolean isVelocimorph = entity.m_6095_().m_204039_(VELOCIMORPH_TAG);
            TameProtoAfterImpactSpawnCallProcedure.execute(world, entity, immediatesourceentity, sourceentity);
            if (!isVelocimorph) {
                if (world instanceof ServerLevel) {
                    ServerLevel _level = (ServerLevel)world;
                    _level.m_7654_().m_129892_().m_230957_(new CommandSourceStack(CommandSource.f_80164_, new Vec3(x, y, z), Vec2.f_82462_, _level, 4, "", (Component)Component.m_237113_((String)""), _level.m_7654_(), null).m_81324_(), "/photon fx photon:impact_frostcrawler block ~ ~ ~");
                }
                FrostcrawlerHitsEntityProcedure.placeIceBlocks(world, entity);
                SlugterraMod.queueServerWork(400, () -> FrostcrawlerHitsEntityProcedure.removeIceBlocks(world));
                FrostcrawlerHitsEntityProcedure.applyFrostEffect(world, immediatesourceentity);
                FrostcrawlerHitsEntityProcedure.playImpactSound(world, x, y, z);
                entity.m_6469_(new DamageSource((Holder)world.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268433_), immediatesourceentity, sourceentity), 4.0f);
            }
        }
    }

    private static void placeIceBlocks(LevelAccessor world, Entity entity) {
        BlockPos centerPos = BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_());
        BlockState iceState = Blocks.f_50126_.m_49966_();
        if (entity instanceof Player) {
            centerPos = centerPos.m_7494_();
        }
        FrostcrawlerHitsEntityProcedure.removeIceBlocks(world);
        placedIceBlocks.clear();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    BlockPos pos = centerPos.m_7918_(dx, dy, dz);
                    if (!world.m_46859_(pos) && world.m_8055_(pos).m_60815_() || !(world instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)world;
                    serverLevel.m_46597_(pos, iceState);
                    placedIceBlocks.add(pos);
                }
            }
        }
    }

    private static void removeIceBlocks(LevelAccessor world) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            for (BlockPos pos : placedIceBlocks) {
                if (!world.m_8055_(pos).m_60713_(Blocks.f_50126_)) continue;
                serverLevel.m_46597_(pos, Blocks.f_50016_.m_49966_());
            }
            placedIceBlocks.clear();
        }
    }

    private static void applyFrostEffect(LevelAccessor world, Entity source) {
        Vec3 center = new Vec3(source.m_20185_(), source.m_20186_(), source.m_20189_());
        List<Entity> entities = world.m_6443_(Entity.class, new AABB(center, center).m_82400_(2.5), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.m_20238_(center))).toList();
        for (Entity entity : entities) {
            if (FrostcrawlerHitsEntityProcedure.isSpectator(entity) || !(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)SlugterraModMobEffects.FROST.get(), 200, 5, false, false));
        }
    }

    private static boolean isSpectator(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer.f_8941_.m_9290_() == GameType.SPECTATOR;
        }
        if (entity.m_9236_().m_5776_() && entity instanceof Player) {
            Player player = (Player)entity;
            return Minecraft.m_91087_().m_91403_().m_104949_(player.m_36316_().getId()) != null && Minecraft.m_91087_().m_91403_().m_104949_(player.m_36316_().getId()).m_105325_() == GameType.SPECTATOR;
        }
        return false;
    }

    private static void playImpactSound(LevelAccessor world, double x, double y, double z) {
        if (world instanceof Level) {
            Level level = (Level)world;
            if (!level.m_5776_()) {
                level.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:frostcrawler_impact")), SoundSource.MASTER, 1.0f, 1.0f);
            } else {
                level.m_7785_(x, y, z, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:frostcrawler_impact")), SoundSource.MASTER, 1.0f, 1.0f, false);
            }
        }
    }
}

